/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common.blocks;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minescript.common.blocks.BlockPositionReader;

public record BlockRegionReader(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, boolean safetyLimit) {
    public static BlockRegionReader withBounds(int x1, int y1, int z1, int x2, int y2, int z2, boolean safetyLimit) {
        int numChunks;
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        if (player == null) {
            throw new IllegalStateException("Unable to read blocks because player is null.");
        }
        class_638 level = minecraft.field_1687;
        int xMin = Math.min(x1, x2);
        int yMin = Math.max(Math.min(y1, y2), level.method_31607());
        int zMin = Math.min(z1, z2);
        int xMax = Math.max(x1, x2);
        int yMax = Math.min(Math.max(y1, y2), level.method_31600());
        int zMax = Math.max(z1, z2);
        if (safetyLimit && (numChunks = ((xMax - xMin) / 16 + 1) * ((zMax - zMin) / 16 + 1)) > 1600) {
            throw new IllegalArgumentException("`blockpack_read_world` exceeded soft limit of 1600 chunks (region covers " + numChunks + " chunks; override this safety check by passing `no_limit` to `copy` command or `safety_limit=False` to `blockpack_read_world` function).");
        }
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = xMin; x <= xMax; x += 16) {
            for (int z = zMin; z <= zMax; z += 16) {
                String block = BlockPositionReader.getBlockStateString((class_1937)level, (class_2338)pos.method_10103(x, 0, z));
                if (block != null && !block.equals("minecraft:void_air")) continue;
                throw new IllegalStateException("Not all chunks are loaded within the requested `copy` volume.");
            }
        }
        return new BlockRegionReader(xMin, yMin, zMin, xMax, yMax, zMax, safetyLimit);
    }

    public void readBlocks(BlockConsumer blockConsumer) {
        class_310 minecraft = class_310.method_1551();
        class_638 level = minecraft.field_1687;
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int y = this.yMin; y <= this.yMax; ++y) {
            for (int z = this.zMin; z <= this.zMax; ++z) {
                for (int x = this.xMin; x <= this.xMax; ++x) {
                    class_2680 blockState = level.method_8320((class_2338)pos.method_10103(x, y, z));
                    if (blockState.method_26215()) {
                        blockConsumer.setAir(x, y, z);
                        continue;
                    }
                    String block = BlockPositionReader.blockStateToString(blockState);
                    if (block != null) {
                        blockConsumer.setblock(x, y, z, block);
                        continue;
                    }
                    blockConsumer.reportBlockError(x, y, z, "Unexpected BlockState format at (%d, %d, %d): %s".formatted(x, y, z, blockState.toString()));
                }
            }
        }
    }

    public static interface BlockConsumer {
        public void setblock(int var1, int var2, int var3, String var4);

        public void setAir(int var1, int var2, int var3);

        public void reportBlockError(int var1, int var2, int var3, String var4);
    }
}

