/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common.mixin;

import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minescript.common.Minescript;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={KeyboardHandler.class})
public class KeyboardHandlerMixin {
    private static int KEY_ACTION_DOWN = 1;

    @Inject(at={@At(value="HEAD")}, method={"keyPress(JILnet/minecraft/client/input/KeyEvent;)V"}, cancellable=true)
    private void keyPress(long window, int action, KeyEvent event, CallbackInfo ci) {
        int key = event.key();
        int scanCode = event.scancode();
        int modifiers = event.modifiers();
        Minescript.onKeyboardEvent(key, scanCode, action, modifiers);
        Screen screen = Minecraft.getInstance().screen;
        if (screen == null) {
            Minescript.onKeyInput(key);
        } else if (Minescript.config != null && (key == Minescript.ENTER_KEY || key == Minescript.config.secondaryEnterKeyCode()) && action == KEY_ACTION_DOWN && Minescript.onKeyboardKeyPressed(screen, key)) {
            ci.cancel();
        }
    }
}

