/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class BlockPack {
    private static final int X_BUILD_MIN = -33554432;
    private static final int X_BUILD_MAX = 0x1FFFFFF;
    private static final int Y_BUILD_MIN = -64;
    private static final int Y_BUILD_MAX = 319;
    private static final int Z_BUILD_MIN = -33554432;
    private static final int Z_BUILD_MAX = 0x1FFFFFF;
    public static final int X_TILE_SIZE = 32;
    public static final int Y_TILE_SIZE = 32;
    public static final int Z_TILE_SIZE = 32;
    private static final long MASK_26_BITS = 0x3FFFFFFL;
    private static final long MASK_12_BITS = 4095L;
    private static final String FILE_FORMAT_MAGIC_BYTES = "BLOCPAK!";
    private static final int TILE_CHUNK_THRESHOLD_BYTES = 16384;
    private final Map<Integer, BlockType> symbolMap = new HashMap<Integer, BlockType>();
    private final SortedMap<Long, Tile> tiles;
    private final ImmutableMap<String, String> comments;
    public final int minTileX;
    public final int minTileY;
    public final int minTileZ;
    public final int maxTileX;
    public final int maxTileY;
    public final int maxTileZ;
    public final int minBlockX;
    public final int minBlockY;
    public final int minBlockZ;
    public final int maxBlockX;
    public final int maxBlockY;
    public final int maxBlockZ;
    private static final Pattern BLOCK_FACING_RE = Pattern.compile("facing=([a-z]*)");

    private static int worldXToTileX(int x) {
        return (x >= 0 ? x / 32 : (x + 1) / 32 - 1) * 32;
    }

    private static int worldYToTileY(int y) {
        return (y >= 0 ? y / 32 : (y + 1) / 32 - 1) * 32;
    }

    private static int worldZToTileZ(int z) {
        return (z >= 0 ? z / 32 : (z + 1) / 32 - 1) * 32;
    }

    public static long getTileKey(int x, int y, int z) {
        return BlockPack.packCoords(BlockPack.worldXToTileX(x), BlockPack.worldYToTileY(y), BlockPack.worldZToTileZ(z));
    }

    public static long packCoords(int x, int y, int z) {
        int xOffset = x - -33554432;
        int yOffset = y - -64;
        int zOffset = z - -33554432;
        return ((long)yOffset & 0xFFFL) << 52 | ((long)xOffset & 0x3FFFFFFL) << 26 | (long)zOffset & 0x3FFFFFFL;
    }

    public static int getXFromPackedCoords(long key) {
        return (int)(key >>> 26 & 0x3FFFFFFL) + -33554432;
    }

    public static int getYFromPackedCoords(long key) {
        return (int)(key >>> 52) + -64;
    }

    public static int getZFromPackedCoords(long key) {
        return (int)(key & 0x3FFFFFFL) + -33554432;
    }

    public BlockPack(Map<Integer, String> symbolMap, SortedMap<Long, Tile> tiles, Map<String, String> comments) {
        this.tiles = tiles;
        this.comments = ImmutableMap.copyOf(comments);
        for (Map.Entry<Integer, String> entry : symbolMap.entrySet()) {
            this.symbolMap.put(entry.getKey(), new BlockType(entry.getValue()));
        }
        if (tiles.isEmpty()) {
            this.minTileZ = 0;
            this.minTileY = 0;
            this.minTileX = 0;
            this.maxTileZ = 0;
            this.maxTileY = 0;
            this.maxTileX = 0;
            this.minBlockZ = 0;
            this.minBlockY = 0;
            this.minBlockX = 0;
            this.maxBlockZ = 0;
            this.maxBlockY = 0;
            this.maxBlockX = 0;
            return;
        }
        int minTileX = 0x1FFFFFF;
        int minTileY = 319;
        int minTileZ = 0x1FFFFFF;
        int maxTileX = -33554432;
        int maxTileY = -64;
        int maxTileZ = -33554432;
        for (long key : tiles.keySet()) {
            int x = BlockPack.getXFromPackedCoords(key);
            int y = BlockPack.getYFromPackedCoords(key);
            int z = BlockPack.getZFromPackedCoords(key);
            if (x < minTileX) {
                minTileX = x;
            }
            if (y < minTileY) {
                minTileY = y;
            }
            if (z < minTileZ) {
                minTileZ = z;
            }
            if (x > maxTileX) {
                maxTileX = x;
            }
            if (y > maxTileY) {
                maxTileY = y;
            }
            if (z <= maxTileZ) continue;
            maxTileZ = z;
        }
        this.minTileX = minTileX;
        this.minTileY = minTileY;
        this.minTileZ = minTileZ;
        this.maxTileX = maxTileX + 32 - 1;
        this.maxTileY = maxTileY + 32 - 1;
        this.maxTileZ = maxTileZ + 32 - 1;
        int minBlockX = 0x1FFFFFF;
        int minBlockY = 319;
        int minBlockZ = 0x1FFFFFF;
        int maxBlockX = -33554432;
        int maxBlockY = -64;
        int maxBlockZ = -33554432;
        int[] coord = new int[3];
        for (Map.Entry<Long, Tile> entry : tiles.entrySet()) {
            int blockZ;
            int blockY;
            int blockX;
            int i;
            long key = entry.getKey();
            int tileX = BlockPack.getXFromPackedCoords(key);
            int tileY = BlockPack.getYFromPackedCoords(key);
            int tileZ = BlockPack.getZFromPackedCoords(key);
            Tile tile = entry.getValue();
            if (tileX != minTileX && tileX != maxTileX && tileY != minTileY && tileY != maxTileY && tileZ != minTileZ && tileZ != maxTileZ) continue;
            for (i = 0; i < tile.fills.length; ++i) {
                if (i % 3 == 2) continue;
                Tile.getCoord(tile.fills[i], coord);
                blockX = tileX + coord[0];
                if (blockX < minBlockX) {
                    minBlockX = blockX;
                }
                if (blockX > maxBlockX) {
                    maxBlockX = blockX;
                }
                if ((blockY = tileY + coord[1]) < minBlockY) {
                    minBlockY = blockY;
                }
                if (blockY > maxBlockY) {
                    maxBlockY = blockY;
                }
                if ((blockZ = tileZ + coord[2]) < minBlockZ) {
                    minBlockZ = blockZ;
                }
                if (blockZ <= maxBlockZ) continue;
                maxBlockZ = blockZ;
            }
            for (i = 0; i < tile.setblocks.length; i += 2) {
                Tile.getCoord(tile.setblocks[i], coord);
                blockX = tileX + coord[0];
                if (blockX < minBlockX) {
                    minBlockX = blockX;
                }
                if (blockX > maxBlockX) {
                    maxBlockX = blockX;
                }
                if ((blockY = tileY + coord[1]) < minBlockY) {
                    minBlockY = blockY;
                }
                if (blockY > maxBlockY) {
                    maxBlockY = blockY;
                }
                if ((blockZ = tileZ + coord[2]) < minBlockZ) {
                    minBlockZ = blockZ;
                }
                if (blockZ <= maxBlockZ) continue;
                maxBlockZ = blockZ;
            }
        }
        this.minBlockX = minBlockX;
        this.minBlockY = minBlockY;
        this.minBlockZ = minBlockZ;
        this.maxBlockX = maxBlockX;
        this.maxBlockY = maxBlockY;
        this.maxBlockZ = maxBlockZ;
    }

    public ImmutableMap<String, String> comments() {
        return this.comments;
    }

    public int[] blockBounds() {
        return new int[]{this.minBlockX, this.minBlockY, this.minBlockZ, this.maxBlockX, this.maxBlockY, this.maxBlockZ};
    }

    private static void writeShortArray(DataOutputStream dataOut, short[] shorts) throws IOException {
        byte[] bytes = new byte[shorts.length * 2];
        dataOut.writeInt(shorts.length);
        for (int i = 0; i < shorts.length; ++i) {
            bytes[2 * i] = (byte)(shorts[i] >>> 8);
            bytes[2 * i + 1] = (byte)(shorts[i] & 0xFF);
        }
        dataOut.write(bytes);
    }

    private static short[] readShortArray(DataInputStream dataIn) throws IOException {
        int numShorts = dataIn.readInt();
        byte[] bytes = new byte[numShorts * 2];
        short[] shorts = new short[numShorts];
        dataIn.readFully(bytes);
        for (int i = 0; i < numShorts; ++i) {
            shorts[i] = (short)(bytes[2 * i] << 8 | bytes[2 * i + 1] & 0xFF);
        }
        return shorts;
    }

    private static void writeIntArray(DataOutputStream dataOut, int[] ints) throws IOException {
        byte[] bytes = new byte[ints.length * 4];
        dataOut.writeInt(ints.length);
        for (int i = 0; i < ints.length; ++i) {
            bytes[4 * i] = (byte)(ints[i] >>> 24);
            bytes[4 * i + 1] = (byte)(ints[i] >>> 16 & 0xFF);
            bytes[4 * i + 2] = (byte)(ints[i] >>> 8 & 0xFF);
            bytes[4 * i + 3] = (byte)(ints[i] & 0xFF);
        }
        dataOut.write(bytes);
    }

    private static int[] readIntArray(DataInputStream dataIn) throws IOException {
        int numInts = dataIn.readInt();
        byte[] bytes = new byte[numInts * 4];
        int[] ints = new int[numInts];
        dataIn.readFully(bytes);
        for (int i = 0; i < numInts; ++i) {
            ints[i] = bytes[4 * i] << 24 | bytes[4 * i + 1] << 16 | bytes[4 * i + 2] << 8 | bytes[4 * i + 3] & 0xFF;
        }
        return ints;
    }

    private static void writeAsciiString(DataOutputStream dataOut, String string) throws IOException {
        dataOut.write(string.getBytes(StandardCharsets.US_ASCII));
    }

    private static String readAsciiString(DataInputStream dataIn, int length) throws IOException {
        byte[] bytes = new byte[length];
        dataIn.readFully(bytes);
        String asciiString = new String(bytes, StandardCharsets.US_ASCII);
        return asciiString;
    }

    private static void writeUtf8String(DataOutputStream dataOut, String string) throws IOException {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        dataOut.writeInt(bytes.length);
        dataOut.write(bytes);
    }

    private static String readUtf8String(DataInputStream dataIn) throws IOException {
        byte[] bytes = new byte[dataIn.readInt()];
        dataIn.readFully(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static int computeCrc32(byte[] bytes) {
        CRC32 crc32 = new CRC32();
        crc32.update(bytes);
        return (int)(crc32.getValue() & 0xFFFFFFFFFFFFFFFFL);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] toBytes() {
        try (ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dataOut = new DataOutputStream(bytesOut);){
                this.writeStream(dataOut);
                byArray = bytesOut.toByteArray();
            }
            return byArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toBase64EncodedString() {
        return Base64.getEncoder().encodeToString(this.toBytes());
    }

    public void writeZipFile(String filename) throws Exception {
        String filenameBase;
        int dotZipIndex = ((String)filename).toLowerCase().lastIndexOf(".zip");
        int lastDirSeparatorPos = Math.max(((String)filename).lastIndexOf(47), ((String)filename).lastIndexOf(92));
        if (dotZipIndex > 0) {
            filenameBase = ((String)filename).substring(lastDirSeparatorPos + 1, dotZipIndex);
        } else {
            filenameBase = ((String)filename).substring(lastDirSeparatorPos + 1);
            filename = (String)filename + ".zip";
        }
        try (ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(new File((String)filename)));
             DataOutputStream dataOut = new DataOutputStream(zipOut);){
            zipOut.putNextEntry(new ZipEntry(filenameBase + ".blox"));
            zipOut.setLevel(6);
            this.writeStream(dataOut);
            zipOut.closeEntry();
        }
    }

    private static void writeChunk(DataOutputStream dataOut, String chunkName, ChunkWriter chunkWriter) throws IOException {
        if (chunkName.length() != 4) {
            throw new IllegalArgumentException(String.format("Expected chunk name to have 4 chars but got \"%s\"", chunkName));
        }
        try (ByteArrayOutputStream chunkBytesOut = new ByteArrayOutputStream();
             DataOutputStream chunkDataOut = new DataOutputStream(chunkBytesOut);){
            BlockPack.writeAsciiString(chunkDataOut, chunkName);
            chunkWriter.writeChunk(chunkDataOut);
            dataOut.writeInt(chunkDataOut.size() - 4);
            chunkBytesOut.writeTo(dataOut);
            dataOut.writeInt(BlockPack.computeCrc32(chunkBytesOut.toByteArray()));
        }
    }

    private void writeHeadChunk(DataOutputStream dataOut) throws IOException {
        int majorVersion = 1;
        int minorVersion = 0;
        int patchVersion = 0;
        dataOut.writeInt(majorVersion << 24 | minorVersion << 16 | patchVersion << 8);
    }

    private void writePaletteChunk(DataOutputStream dataOut) throws IOException {
        int maxSymbolId = this.symbolMap.isEmpty() ? -1 : Collections.max(this.symbolMap.keySet());
        dataOut.writeInt(maxSymbolId + 1);
        for (int i = 0; i < maxSymbolId + 1; ++i) {
            BlockType blockType = this.symbolMap.get(i);
            BlockPack.writeUtf8String(dataOut, blockType.symbol == null ? "" : blockType.symbol);
        }
    }

    private static void readHeadChunk(DataInputStream dataIn) throws IOException {
        int version = dataIn.readInt();
        if (version >>> 24 != 1) {
            throw new IllegalArgumentException(String.format("Expected version in blockpack zip entry to be v1.*.* but got v%d.%d.%d", version >>> 24, version >>> 16 & 0xFF, version >>> 8 & 0xFF));
        }
    }

    private static Map<Integer, String> readPaletteChunk(DataInputStream dataIn) throws IOException {
        HashMap<Integer, String> symbolMap = new HashMap<Integer, String>();
        int symbolMapSize = dataIn.readInt();
        for (int i = 0; i < symbolMapSize; ++i) {
            symbolMap.put(i, BlockPack.readUtf8String(dataIn));
        }
        return symbolMap;
    }

    private static void readTileChunk(DataInputStream dataIn, SortedMap<Long, Tile> tiles) throws IOException {
        long numTiles = dataIn.readInt();
        int i = 0;
        while ((long)i < numTiles) {
            long key = dataIn.readLong();
            int xOffset = BlockPack.getXFromPackedCoords(key);
            int yOffset = BlockPack.getYFromPackedCoords(key);
            int zOffset = BlockPack.getZFromPackedCoords(key);
            int[] blockTypes = BlockPack.readIntArray(dataIn);
            short[] fills = BlockPack.readShortArray(dataIn);
            short[] setblocks = BlockPack.readShortArray(dataIn);
            Tile tile = new Tile(xOffset, yOffset, zOffset, blockTypes, fills, setblocks);
            tiles.put(key, tile);
            ++i;
        }
    }

    private static void readTextChunk(DataInputStream dataIn, int textLength, Map<String, String> comments) throws IOException {
        byte[] bytes = new byte[textLength];
        dataIn.readFully(bytes);
        String text = new String(bytes, StandardCharsets.UTF_8);
        int nullPos = text.indexOf(0);
        if (nullPos == -1) {
            throw new IllegalArgumentException(String.format("Comment in \"text\" chunk of blockpack is missing a null delimiter: \"%s\"", text));
        }
        String key = text.substring(0, nullPos);
        String value = text.substring(nullPos + 1);
        comments.put(key, value);
    }

    private void writeStream(DataOutputStream dataOut) throws Exception {
        BlockPack.writeAsciiString(dataOut, FILE_FORMAT_MAGIC_BYTES);
        BlockPack.writeChunk(dataOut, "Head", this::writeHeadChunk);
        for (Map.Entry entry : this.comments.entrySet()) {
            BlockPack.writeChunk(dataOut, "text", d -> d.write(String.format("%s\u0000%s", entry.getKey(), entry.getValue()).getBytes(StandardCharsets.UTF_8)));
        }
        BlockPack.writeChunk(dataOut, "Plte", this::writePaletteChunk);
        try (TileChunkWriter tileChunkWriter = new TileChunkWriter(dataOut);){
            for (Map.Entry<Long, Tile> entry : this.tiles.entrySet()) {
                tileChunkWriter.write(entry.getKey(), entry.getValue());
            }
        }
        BlockPack.writeChunk(dataOut, "Done", d -> {});
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static BlockPack fromBytes(byte[] bytes) {
        try (ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);){
            BlockPack blockPack;
            try (DataInputStream dataIn = new DataInputStream(bytesIn);){
                blockPack = BlockPack.readStream(dataIn);
            }
            return blockPack;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static BlockPack fromBase64EncodedString(String base64) {
        return BlockPack.fromBytes(Base64.getDecoder().decode(base64));
    }

    public static BlockPack readZipFile(String filename) throws Exception {
        int dotZipIndex = ((String)filename).toLowerCase().lastIndexOf(".zip");
        if (dotZipIndex <= 0) {
            filename = (String)filename + ".zip";
        }
        try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(new File((String)filename)));
             DataInputStream dataIn = new DataInputStream(zipIn);){
            ZipEntry zipEntry;
            while ((zipEntry = zipIn.getNextEntry()) != null) {
                if (!zipEntry.getName().toLowerCase().endsWith(".blox")) continue;
                BlockPack blockPack = BlockPack.readStream(dataIn);
                return blockPack;
            }
        }
        throw new IllegalArgumentException("Expected an entry ending with `.blox` in the zip archive, but no such entry found in " + (String)filename);
    }

    private static BlockPack readStream(DataInputStream dataIn) throws IOException {
        String op = null;
        try {
            op = "reading first 8 (magic) bytes";
            String first8Bytes = BlockPack.readAsciiString(dataIn, 8);
            if (!first8Bytes.equals(FILE_FORMAT_MAGIC_BYTES)) {
                throw new IllegalArgumentException(String.format("Expected first 8 bytes of blockpack data to be \"%s\" but got \"%s\"", FILE_FORMAT_MAGIC_BYTES, first8Bytes));
            }
            HashSet<String> exhaustedChunks = new HashSet<String>();
            op = "reading blockpack `Head` chunk";
            ChunkReader chunkReader = new ChunkReader(dataIn, "Head");
            BlockPack.readHeadChunk(chunkReader.dataInputStream());
            exhaustedChunks.add(chunkReader.chunkName());
            Map<Integer, String> symbolMap = null;
            TreeMap<Long, Tile> tiles = new TreeMap<Long, Tile>();
            HashMap<String, String> comments = new HashMap<String, String>();
            op = "reading blockpack chunk";
            chunkReader = new ChunkReader(dataIn);
            while (!chunkReader.chunkName().equals("Done")) {
                if (exhaustedChunks.contains(chunkReader.chunkName())) {
                    throw new IllegalArgumentException(String.format("\"%s\" chunk appears more than once in blockpack", chunkReader.chunkName()));
                }
                switch (chunkReader.chunkName()) {
                    case "Plte": {
                        exhaustedChunks.add(chunkReader.chunkName());
                        symbolMap = BlockPack.readPaletteChunk(chunkReader.dataInputStream());
                        break;
                    }
                    case "Tile": {
                        BlockPack.readTileChunk(chunkReader.dataInputStream(), tiles);
                        break;
                    }
                    case "text": {
                        BlockPack.readTextChunk(chunkReader.dataInputStream(), chunkReader.chunkLength(), comments);
                        break;
                    }
                    default: {
                        if (!Character.isUpperCase(chunkReader.chunkName().charAt(0))) break;
                        throw new IllegalArgumentException(String.format("Unrecognized critical chunk named \"%s\" in blockpack", chunkReader.chunkName()));
                    }
                }
                chunkReader = new ChunkReader(dataIn);
            }
            if (symbolMap == null) {
                throw new IllegalArgumentException("Required chunk \"Plte\" not found in blockpack");
            }
            return new BlockPack(symbolMap, tiles, comments);
        }
        catch (IOException e) {
            if (e.getMessage() == null) {
                throw new IOException(e.getClass().getSimpleName() + " while " + op);
            }
            throw new IOException(e.getMessage() + " (while " + op + ")");
        }
    }

    private static boolean mapDirectionToXZ(String direction, int[] vector) {
        switch (direction) {
            case "north": {
                vector[0] = 0;
                vector[1] = -1;
                return true;
            }
            case "south": {
                vector[0] = 0;
                vector[1] = 1;
                return true;
            }
            case "east": {
                vector[0] = 1;
                vector[1] = 0;
                return true;
            }
            case "west": {
                vector[0] = -1;
                vector[1] = 0;
                return true;
            }
        }
        return false;
    }

    private static String mapXZToDirection(int x, int z) {
        if (x == 0) {
            switch (z) {
                case -1: {
                    return "north";
                }
                case 1: {
                    return "south";
                }
            }
        }
        if (z == 0) {
            switch (x) {
                case -1: {
                    return "west";
                }
                case 1: {
                    return "east";
                }
            }
        }
        return null;
    }

    private static String reorientBlock(String block, int[] rotation) {
        int newDirectionZ;
        int newDirectionX;
        String newDirection;
        int[] vector;
        String direction;
        Matcher match = BLOCK_FACING_RE.matcher(block);
        if (match.find() && BlockPack.mapDirectionToXZ(direction = match.group(1), vector = new int[]{0, 0}) && (newDirection = BlockPack.mapXZToDirection(newDirectionX = rotation[0] * vector[0] + rotation[2] * vector[1], newDirectionZ = rotation[6] * vector[0] + rotation[8] * vector[1])) != null) {
            return match.replaceFirst("facing=" + newDirection);
        }
        return block;
    }

    public void getBlockCommands(int[] rotation, int[] offset, final Consumer<String> commandConsumer) {
        this.getBlocks(new TransformedBlockConsumer(rotation, offset, new BlockConsumer(){

            @Override
            public void setblock(int x, int y, int z, String block) {
                commandConsumer.accept(String.format("setblock %d %d %d %s", x, y, z, block));
            }

            @Override
            public void fill(int x1, int y1, int z1, int x2, int y2, int z2, String block) {
                commandConsumer.accept(String.format("fill %d %d %d %d %d %d %s", x1, y1, z1, x2, y2, z2, block));
            }
        }));
    }

    public void getBlocks(BlockConsumer blockConsumer) {
        for (Tile tile : this.tiles.values()) {
            tile.getBlocksInAscendingYOrder(this.symbolMap, blockConsumer);
        }
    }

    private static class BlockType {
        public final String symbol;
        public final boolean stable;

        public BlockType(String symbol) {
            this.symbol = symbol;
            this.stable = true;
        }
    }

    public static class Tile {
        private final int xOffset;
        private final int yOffset;
        private final int zOffset;
        private final int[] blockTypes;
        private final short[] fills;
        private final short[] setblocks;

        public Tile(int xOffset, int yOffset, int zOffset, int[] blockTypes, short[] fills, short[] setblocks) {
            this.blockTypes = blockTypes;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.zOffset = zOffset;
            this.setblocks = setblocks;
            this.fills = fills;
        }

        public void getBlockCommands(boolean setblockOnly, Map<Integer, BlockType> symbolMap, Consumer<String> commandConsumer) {
            int i;
            int[] coord = new int[3];
            for (i = 0; i < this.fills.length; i += 3) {
                Tile.getCoord(this.fills[i], coord);
                int x1 = this.xOffset + coord[0];
                int y1 = this.yOffset + coord[1];
                int z1 = this.zOffset + coord[2];
                Tile.getCoord(this.fills[i + 1], coord);
                int x2 = this.xOffset + coord[0];
                int y2 = this.yOffset + coord[1];
                int z2 = this.zOffset + coord[2];
                int blockTypeId = this.blockTypes[this.fills[i + 2]];
                BlockType blockType = symbolMap.get(blockTypeId);
                if (setblockOnly) {
                    for (int x = x1; x <= x2; ++x) {
                        for (int y = y1; y <= y2; ++y) {
                            for (int z = z1; z <= z2; ++z) {
                                commandConsumer.accept(String.format("setblock %d %d %d %s", x, y, z, blockType.symbol));
                            }
                        }
                    }
                    continue;
                }
                commandConsumer.accept(String.format("fill %d %d %d %d %d %d %s", x1, y1, z1, x2, y2, z2, blockType.symbol));
            }
            for (i = 0; i < this.setblocks.length; i += 2) {
                Tile.getCoord(this.setblocks[i], coord);
                int x = this.xOffset + coord[0];
                int y = this.yOffset + coord[1];
                int z = this.zOffset + coord[2];
                int blockTypeId = this.blockTypes[this.setblocks[i + 1]];
                BlockType blockType = symbolMap.get(blockTypeId);
                commandConsumer.accept(String.format("setblock %d %d %d %s", x, y, z, blockType.symbol));
            }
        }

        private static int[] getCoord(short s, int[] coord) {
            coord[0] = s >> 10;
            coord[1] = s >> 5 & 0x1F;
            coord[2] = s & 0x1F;
            return coord;
        }

        public void getBlocksInAscendingYOrder(Map<Integer, BlockType> symbolMap, BlockConsumer blockConsumer) {
            int setblocksSize = this.setblocks.length;
            int fillsSize = this.fills.length;
            int setblocksPos = 0;
            int fillsPos = 0;
            int[] coord = new int[3];
            while (setblocksPos < setblocksSize || fillsPos < fillsSize) {
                int i;
                int setblocksY;
                int fillsY = fillsPos < fillsSize ? Tile.getCoord(this.fills[fillsPos], coord)[1] : Integer.MAX_VALUE;
                int n = setblocksY = setblocksPos < setblocksSize ? Tile.getCoord(this.setblocks[setblocksPos], coord)[1] : Integer.MAX_VALUE;
                if (fillsY <= setblocksY) {
                    i = fillsPos;
                    Tile.getCoord(this.fills[i], coord);
                    int x1 = this.xOffset + coord[0];
                    int y1 = this.yOffset + coord[1];
                    int z1 = this.zOffset + coord[2];
                    Tile.getCoord(this.fills[i + 1], coord);
                    int x2 = this.xOffset + coord[0];
                    int y2 = this.yOffset + coord[1];
                    int z2 = this.zOffset + coord[2];
                    int blockTypeId = this.blockTypes[this.fills[i + 2]];
                    BlockType blockType = symbolMap.get(blockTypeId);
                    blockConsumer.fill(x1, y1, z1, x2, y2, z2, blockType.symbol);
                    fillsPos += 3;
                }
                if (setblocksY >= fillsY) continue;
                i = setblocksPos;
                Tile.getCoord(this.setblocks[i], coord);
                int x = this.xOffset + coord[0];
                int y = this.yOffset + coord[1];
                int z = this.zOffset + coord[2];
                int blockTypeId = this.blockTypes[this.setblocks[i + 1]];
                BlockType blockType = symbolMap.get(blockTypeId);
                blockConsumer.setblock(x, y, z, blockType.symbol);
                setblocksPos += 2;
            }
        }
    }

    private static interface ChunkWriter {
        public void writeChunk(DataOutputStream var1) throws IOException;
    }

    private static class TileChunkWriter
    implements AutoCloseable {
        private final DataOutputStream dataOut;
        private final ByteArrayOutputStream tmpBytesOut;
        private final DataOutputStream tmpDataOut;
        private int numTilesPending = 0;

        public TileChunkWriter(DataOutputStream dataOut) {
            this.dataOut = dataOut;
            this.tmpBytesOut = new ByteArrayOutputStream();
            this.tmpDataOut = new DataOutputStream(this.tmpBytesOut);
        }

        public void write(long tileKey, Tile tile) throws IOException {
            this.tmpDataOut.writeLong(tileKey);
            BlockPack.writeIntArray(this.tmpDataOut, tile.blockTypes);
            BlockPack.writeShortArray(this.tmpDataOut, tile.fills);
            BlockPack.writeShortArray(this.tmpDataOut, tile.setblocks);
            ++this.numTilesPending;
            if (this.tmpBytesOut.size() > 16384) {
                this.flushChunk();
            }
        }

        @Override
        public void close() throws Exception {
            if (this.tmpBytesOut.size() > 0) {
                this.flushChunk();
            }
        }

        private void flushChunk() throws IOException {
            BlockPack.writeChunk(this.dataOut, "Tile", d -> {
                d.writeInt(this.numTilesPending);
                this.tmpBytesOut.writeTo(d);
                this.tmpBytesOut.reset();
                this.numTilesPending = 0;
            });
        }
    }

    private static class ChunkReader {
        private final String chunkName;
        private final DataInputStream chunkDataIn;
        private final int chunkLength;

        public ChunkReader(DataInputStream dataIn) throws IOException {
            this(dataIn, null);
        }

        public ChunkReader(DataInputStream dataIn, String expectedChunkName) throws IOException {
            int computedCrc;
            this.chunkLength = dataIn.readInt();
            byte[] chunkBytes = new byte[this.chunkLength + 4];
            dataIn.readFully(chunkBytes);
            ByteArrayInputStream chunkBytesIn = new ByteArrayInputStream(chunkBytes);
            this.chunkDataIn = new DataInputStream(chunkBytesIn);
            this.chunkName = BlockPack.readAsciiString(this.chunkDataIn, 4);
            if (expectedChunkName != null && !this.chunkName.equals(expectedChunkName)) {
                throw new IllegalArgumentException(String.format("Expected chunk named \"%s\" but got \"%s\"", expectedChunkName, this.chunkName));
            }
            int recordedCrc = dataIn.readInt();
            if (recordedCrc != (computedCrc = BlockPack.computeCrc32(chunkBytes))) {
                throw new IllegalArgumentException(String.format("Computed chunk CRC32 0x%x does not match recorded CRC32 0x%x", computedCrc, recordedCrc));
            }
        }

        public String chunkName() {
            return this.chunkName;
        }

        DataInputStream dataInputStream() {
            return this.chunkDataIn;
        }

        int chunkLength() {
            return this.chunkLength;
        }
    }

    public static class TransformedBlockConsumer
    implements BlockConsumer {
        private final int[] rotation;
        private final int[] offset;
        private final BlockConsumer blockConsumer;

        public TransformedBlockConsumer(int[] rotation, int[] offset, BlockConsumer blockConsumer) {
            if (rotation != null && rotation.length != 9) {
                throw new IllegalArgumentException("Expected rotation to have 9 ints but got " + rotation.length);
            }
            if (offset != null && offset.length != 3) {
                throw new IllegalArgumentException("Expected offset to have 3 ints but got " + offset.length);
            }
            this.rotation = rotation;
            this.offset = offset;
            this.blockConsumer = blockConsumer;
        }

        @Override
        public void setblock(int x, int y, int z, String block) {
            if (this.rotation != null) {
                int newX = this.rotation[0] * x + this.rotation[1] * y + this.rotation[2] * z;
                int newY = this.rotation[3] * x + this.rotation[4] * y + this.rotation[5] * z;
                int newZ = this.rotation[6] * x + this.rotation[7] * y + this.rotation[8] * z;
                x = newX;
                y = newY;
                z = newZ;
                block = BlockPack.reorientBlock(block, this.rotation);
            }
            if (this.offset != null) {
                x += this.offset[0];
                y += this.offset[1];
                z += this.offset[2];
            }
            this.blockConsumer.setblock(x, y, z, block);
        }

        @Override
        public void fill(int x1, int y1, int z1, int x2, int y2, int z2, String block) {
            if (this.rotation != null) {
                int newX1 = this.rotation[0] * x1 + this.rotation[1] * y1 + this.rotation[2] * z1;
                int newY1 = this.rotation[3] * x1 + this.rotation[4] * y1 + this.rotation[5] * z1;
                int newZ1 = this.rotation[6] * x1 + this.rotation[7] * y1 + this.rotation[8] * z1;
                int newX2 = this.rotation[0] * x2 + this.rotation[1] * y2 + this.rotation[2] * z2;
                int newY2 = this.rotation[3] * x2 + this.rotation[4] * y2 + this.rotation[5] * z2;
                int newZ2 = this.rotation[6] * x2 + this.rotation[7] * y2 + this.rotation[8] * z2;
                if (newX1 < newX2) {
                    x1 = newX1;
                    x2 = newX2;
                } else {
                    x2 = newX1;
                    x1 = newX2;
                }
                if (newY1 < newY2) {
                    y1 = newY1;
                    y2 = newY2;
                } else {
                    y2 = newY1;
                    y1 = newY2;
                }
                if (newZ1 < newZ2) {
                    z1 = newZ1;
                    z2 = newZ2;
                } else {
                    z2 = newZ1;
                    z1 = newZ2;
                }
                block = BlockPack.reorientBlock(block, this.rotation);
            }
            if (this.offset != null) {
                x1 += this.offset[0];
                y1 += this.offset[1];
                z1 += this.offset[2];
                x2 += this.offset[0];
                y2 += this.offset[1];
                z2 += this.offset[2];
            }
            this.blockConsumer.fill(x1, y1, z1, x2, y2, z2, block);
        }
    }

    public static interface BlockConsumer {
        public void setblock(int var1, int var2, int var3, String var4);

        public void fill(int var1, int var2, int var3, int var4, int var5, int var6, String var7);
    }
}

