/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1936;
import net.minecraft.class_310;
import net.minecraft.class_631;
import net.minecraft.class_638;
import net.minescript.common.JobControl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkLoadEventListener
implements JobControl.Operation {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<Long, Boolean> chunksToLoad = new ConcurrentHashMap<Long, Boolean>();
    private final int levelHashCode;
    private final DoneCallback doneCallback;
    private int numUnloadedChunks = 0;
    private boolean suspended = false;
    private boolean finished = false;

    public ChunkLoadEventListener(int x1, int z1, int x2, int z2, DoneCallback doneCallback) {
        class_310 minecraft = class_310.method_1551();
        this.levelHashCode = minecraft.field_1687.hashCode();
        LOGGER.info("listener chunk region in level {}: {} {} {} {}", (Object)this.levelHashCode, (Object)x1, (Object)z1, (Object)x2, (Object)z2);
        int chunkX1 = ChunkLoadEventListener.worldCoordToChunkCoord(x1);
        int chunkZ1 = ChunkLoadEventListener.worldCoordToChunkCoord(z1);
        int chunkX2 = ChunkLoadEventListener.worldCoordToChunkCoord(x2);
        int chunkZ2 = ChunkLoadEventListener.worldCoordToChunkCoord(z2);
        int chunkXMin = Math.min(chunkX1, chunkX2);
        int chunkXMax = Math.max(chunkX1, chunkX2);
        int chunkZMin = Math.min(chunkZ1, chunkZ2);
        int chunkZMax = Math.max(chunkZ1, chunkZ2);
        for (int chunkX = chunkXMin; chunkX <= chunkXMax; ++chunkX) {
            for (int chunkZ = chunkZMin; chunkZ <= chunkZMax; ++chunkZ) {
                LOGGER.info("listener chunk registered: {} {}", (Object)chunkX, (Object)chunkZ);
                long packedChunkXZ = ChunkLoadEventListener.packInts(chunkX, chunkZ);
                this.chunksToLoad.put(packedChunkXZ, false);
            }
        }
        this.doneCallback = doneCallback;
    }

    @Override
    public String name() {
        return "chunk_load_listener";
    }

    @Override
    public synchronized void suspend() {
        this.suspended = true;
    }

    @Override
    public synchronized boolean resumeAndCheckDone() {
        this.suspended = false;
        this.updateChunkStatuses();
        return this.checkFullyLoaded();
    }

    @Override
    public synchronized void cancel() {
        this.onFinished(false, true);
    }

    public synchronized void updateChunkStatuses() {
        class_310 minecraft = class_310.method_1551();
        class_638 level = minecraft.field_1687;
        if (level.hashCode() != this.levelHashCode) {
            LOGGER.info("chunk listener's world doesn't match current world; clearing listener");
            this.chunksToLoad.clear();
            this.numUnloadedChunks = 0;
            return;
        }
        this.numUnloadedChunks = 0;
        class_631 chunkManager = level.method_2935();
        for (Map.Entry<Long, Boolean> entry : this.chunksToLoad.entrySet()) {
            long packedChunkXZ = entry.getKey();
            int[] chunkCoords = ChunkLoadEventListener.unpackLong(packedChunkXZ);
            boolean isLoaded = chunkManager.method_21730(chunkCoords[0], chunkCoords[1]) != null;
            entry.setValue(isLoaded);
            if (isLoaded) continue;
            ++this.numUnloadedChunks;
        }
        LOGGER.info("Unloaded chunks after updateChunkStatuses: {}", (Object)this.numUnloadedChunks);
    }

    public synchronized boolean onChunkLoaded(class_1936 chunkLevel, int chunkX, int chunkZ) {
        if (this.suspended) {
            return false;
        }
        if (chunkLevel.hashCode() != this.levelHashCode) {
            return false;
        }
        long packedChunkXZ = ChunkLoadEventListener.packInts(chunkX, chunkZ);
        if (!this.chunksToLoad.containsKey(packedChunkXZ)) {
            return false;
        }
        boolean wasLoaded = this.chunksToLoad.put(packedChunkXZ, true);
        if (!wasLoaded) {
            LOGGER.info("listener chunk loaded for level {}: {} {}", (Object)this.levelHashCode, (Object)chunkX, (Object)chunkZ);
            --this.numUnloadedChunks;
            if (this.numUnloadedChunks == 0) {
                this.onFinished(true, false);
                return true;
            }
        }
        return false;
    }

    public synchronized void onChunkUnloaded(class_1936 chunkLevel, int chunkX, int chunkZ) {
        if (this.suspended) {
            return;
        }
        if (chunkLevel.hashCode() != this.levelHashCode) {
            return;
        }
        long packedChunkXZ = ChunkLoadEventListener.packInts(chunkX, chunkZ);
        if (!this.chunksToLoad.containsKey(packedChunkXZ)) {
            return;
        }
        boolean wasLoaded = this.chunksToLoad.put(packedChunkXZ, false);
        if (wasLoaded) {
            ++this.numUnloadedChunks;
        }
    }

    public synchronized boolean checkFullyLoaded() {
        if (this.numUnloadedChunks == 0) {
            this.onFinished(true, true);
            return true;
        }
        return false;
    }

    private synchronized void onFinished(boolean success, boolean removeFromListeners) {
        if (this.finished) {
            LOGGER.warn("ChunkLoadEventListener already finished; finished again with {}", (Object)(success ? "success" : "failure"));
            return;
        }
        this.finished = true;
        this.doneCallback.done(success, removeFromListeners);
    }

    private static int worldCoordToChunkCoord(int x) {
        return x >= 0 ? x / 16 : (x + 1) / 16 - 1;
    }

    private static long packInts(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }

    private static int[] unpackLong(long x) {
        return new int[]{(int)(x >> 32), (int)x};
    }

    static interface DoneCallback {
        public void done(boolean var1, boolean var2);
    }
}

