/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minescript.common.Math3d;

public record EntitySelection(Optional<String> uuid, Optional<String> name, Optional<String> type, Optional<List<Double>> position, Optional<List<Double>> offset, OptionalDouble minDistance, OptionalDouble maxDistance, Optional<SortType> sort, OptionalInt limit) {
    public List<class_1297> selectFrom(Iterable<? extends class_1297> entities) {
        int limitInt;
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        Optional<Pattern> uuidPattern = this.uuid.map(Pattern::compile);
        Optional<Pattern> namePattern = this.name.map(Pattern::compile);
        Optional<Pattern> typePattern = this.type.map(Pattern::compile);
        OptionalDouble minDistanceSquared = EntitySelection.optionalSquare(this.minDistance);
        OptionalDouble maxDistanceSquared = EntitySelection.optionalSquare(this.maxDistance);
        double baseX = player.method_23317();
        double baseY = player.method_23318();
        double baseZ = player.method_23321();
        if (this.position.isPresent()) {
            baseX = this.position.get().get(0);
            baseY = this.position.get().get(1);
            baseZ = this.position.get().get(2);
        }
        double offsetX = 0.0;
        double offsetY = 0.0;
        double offsetZ = 0.0;
        if (this.offset.isPresent()) {
            offsetX = this.offset.get().get(0);
            offsetY = this.offset.get().get(1);
            offsetZ = this.offset.get().get(2);
        }
        double minX = Math.min(baseX, baseX + offsetX);
        double maxX = Math.max(baseX, baseX + offsetX);
        double minY = Math.min(baseY, baseY + offsetY);
        double maxY = Math.max(baseY, baseY + offsetY);
        double minZ = Math.min(baseZ, baseZ + offsetZ);
        double maxZ = Math.max(baseZ, baseZ + offsetZ);
        List<Object> results = new ArrayList<class_1297>();
        for (class_1297 class_12972 : entities) {
            Matcher match;
            double entityX = class_12972.method_23317();
            double entityY = class_12972.method_23318();
            double entityZ = class_12972.method_23321();
            double entityDistance = -1.0;
            if (minDistanceSquared.isPresent() && (entityDistance = Math3d.computeDistanceSquared(baseX, baseY, baseZ, entityX, entityY, entityZ)) < minDistanceSquared.getAsDouble()) continue;
            if (maxDistanceSquared.isPresent()) {
                if (entityDistance < 0.0) {
                    entityDistance = Math3d.computeDistanceSquared(baseX, baseY, baseZ, entityX, entityY, entityZ);
                }
                if (entityDistance > maxDistanceSquared.getAsDouble()) continue;
            }
            if (this.offset.isPresent() && (entityX < minX || entityY < minY || entityZ < minZ || entityX > maxX || entityY > maxY || entityZ > maxZ) || uuidPattern.isPresent() && !(match = uuidPattern.get().matcher(class_12972.method_5667().toString())).matches() || namePattern.isPresent() && !(match = namePattern.get().matcher(class_12972.method_5477().getString())).matches() || typePattern.isPresent() && !(match = typePattern.get().matcher(class_12972.method_5864().toString())).matches()) continue;
            results.add(class_12972);
        }
        if (this.sort.isPresent()) {
            switch (this.sort.get().ordinal()) {
                case 0: {
                    results.sort(EntityDistanceComparator.nearest(baseX, baseY, baseZ));
                    break;
                }
                case 1: {
                    results.sort(EntityDistanceComparator.furthest(baseX, baseY, baseZ));
                    break;
                }
                case 2: {
                    results.sort(new EntityHashComparator());
                    break;
                }
            }
        }
        if (this.limit.isPresent() && (limitInt = this.limit.getAsInt()) < results.size()) {
            results = results.subList(0, limitInt);
        }
        return results;
    }

    private static double computeEntityDistanceSquared(double x, double y, double z, class_1297 e) {
        double x2 = e.method_23317();
        double y2 = e.method_23318();
        double z2 = e.method_23321();
        double dx = x - x2;
        double dy = y - y2;
        double dz = z - z2;
        return dx * dx + dy * dy + dz * dz;
    }

    private static OptionalDouble optionalSquare(OptionalDouble od) {
        if (od.isEmpty()) {
            return od;
        }
        double d = od.getAsDouble();
        return OptionalDouble.of(d * d);
    }

    public static enum SortType {
        NEAREST,
        FURTHEST,
        RANDOM,
        ARBITRARY;

    }

    private static class EntityDistanceComparator
    implements Comparator<class_1297> {
        private final double x;
        private final double y;
        private final double z;
        private final int sign;

        public static EntityDistanceComparator nearest(double x, double y, double z) {
            return new EntityDistanceComparator(x, y, z, 1);
        }

        public static EntityDistanceComparator furthest(double x, double y, double z) {
            return new EntityDistanceComparator(x, y, z, -1);
        }

        private EntityDistanceComparator(double x, double y, double z, int sign) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.sign = sign;
        }

        @Override
        public int compare(class_1297 e1, class_1297 e2) {
            if (e1 == e2) {
                return 0;
            }
            int comparison = Double.compare(EntitySelection.computeEntityDistanceSquared(this.x, this.y, this.z, e1), EntitySelection.computeEntityDistanceSquared(this.x, this.y, this.z, e2));
            if (comparison == 0) {
                return Integer.compare(e1.hashCode(), e2.hashCode());
            }
            return this.sign * comparison;
        }
    }

    private static class EntityHashComparator
    implements Comparator<class_1297> {
        private EntityHashComparator() {
        }

        @Override
        public int compare(class_1297 e1, class_1297 e2) {
            if (e1 == e2) {
                return 0;
            }
            int comparison = Integer.compare(e1.hashCode(), e2.hashCode());
            if (comparison == 0) {
                return Double.compare(e1.method_23317(), e2.method_23317());
            }
            return comparison;
        }
    }
}

