/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilePattern {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String pattern;

    private FilePattern(String pattern) {
        this.pattern = pattern;
    }

    public static FilePattern of(String pattern) {
        return new FilePattern(pattern);
    }

    public static FilePattern of(Path path) {
        return new FilePattern(path.toString());
    }

    public FilePattern and(String pattern) {
        if (FilePattern.isAbsolutePath(pattern)) {
            return FilePattern.of(pattern);
        }
        return FilePattern.of(FilePattern.combinePaths(this.pattern, pattern));
    }

    public FilePattern and(FilePattern path) {
        if (path.isAbsolute()) {
            return path;
        }
        return FilePattern.of(FilePattern.combinePaths(this.pattern, path.toString()));
    }

    public FilePattern and(Path path) {
        if (path.isAbsolute()) {
            return FilePattern.of(path);
        }
        return FilePattern.of(FilePattern.combinePaths(this.pattern, path.toString()));
    }

    public String toString() {
        return this.pattern;
    }

    private static String combinePaths(String path1, String path2) {
        boolean empty2;
        boolean empty1 = path1 == null || path1.isEmpty();
        boolean bl = empty2 = path2 == null || path2.isEmpty();
        if (empty1 && empty2) {
            return "";
        }
        if (empty1) {
            return path2 == null ? "" : path2.replace("\\", "/");
        }
        if (empty2) {
            return path1 == null ? "" : path1.replace("\\", "/");
        }
        String a = path1.replace("\\", "/");
        String b = path2.replace("\\", "/");
        if (a.endsWith("/")) {
            a = a.substring(0, a.length() - 1);
        }
        if (b.startsWith("/")) {
            b = b.substring(1);
        }
        return a + "/" + b;
    }

    public boolean isAbsolute() {
        return FilePattern.isAbsolutePath(this.pattern);
    }

    private static boolean isAbsolutePath(String path) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        if (path.startsWith("/")) {
            return true;
        }
        if (path.startsWith("\\\\")) {
            return true;
        }
        if (path.length() >= 3) {
            boolean isLetter;
            char letter = path.charAt(0);
            char colon = path.charAt(1);
            char sep = path.charAt(2);
            boolean bl = isLetter = letter >= 'a' && letter <= 'z' || letter >= 'A' && letter <= 'Z';
            if (isLetter && colon == ':' && (sep == '/' || sep == '\\')) {
                return true;
            }
        }
        return false;
    }

    public Optional<Path> resolvePath() {
        List<Path> matchingFiles = this.resolvePathsWithLimit(1);
        return matchingFiles.isEmpty() ? Optional.empty() : Optional.of(matchingFiles.get(0));
    }

    public List<Path> resolvePaths() {
        return this.resolvePathsWithLimit(Integer.MAX_VALUE);
    }

    private List<Path> resolvePathsWithLimit(final int limit) {
        String patternString = this.pattern;
        boolean globSymbolsInPattern = FilePattern.isGlobPattern(patternString);
        Path fullPath = null;
        Path staticRoot = Paths.get(".", new String[0]);
        if (!globSymbolsInPattern) {
            Path remainingPattern = fullPath = Paths.get(patternString, new String[0]);
            if (fullPath.isAbsolute()) {
                staticRoot = fullPath.getRoot();
                remainingPattern = staticRoot.relativize(fullPath);
            }
            for (Path part : remainingPattern) {
                String partStr = part.toString();
                if (staticRoot.toString().equals(".")) {
                    staticRoot = Paths.get(partStr, new String[0]);
                    continue;
                }
                staticRoot = staticRoot.resolve(partStr);
            }
            return Files.exists(fullPath, new LinkOption[0]) ? List.of(fullPath) : List.of();
        }
        String normalized = patternString.replace('\\', '/');
        String[] parts = normalized.split("/");
        if (patternString.startsWith("/")) {
            staticRoot = Paths.get("/", new String[0]);
        } else if (patternString.startsWith("\\\\")) {
            staticRoot = Paths.get(".", new String[0]);
        } else if (parts.length > 0 && parts[0].matches("[A-Za-z]:")) {
            staticRoot = Paths.get(parts[0] + "/", new String[0]);
        }
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (part.isEmpty()) continue;
            if (FilePattern.isGlobPattern(part)) break;
            staticRoot = staticRoot.toString().equals(".") ? Paths.get(part, new String[0]) : staticRoot.resolve(part);
        }
        if (!Files.exists(staticRoot, new LinkOption[0])) {
            return List.of();
        }
        final String globSyntax = "glob:" + patternString.replace("\\", "\\\\");
        final PathMatcher matcher = FileSystems.getDefault().getPathMatcher(globSyntax);
        final ArrayList<Path> matchingFiles = new ArrayList<Path>();
        try {
            Files.walkFileTree(staticRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (matcher.matches(file)) {
                        matchingFiles.add(file);
                        LOGGER.info("Found matching file for {}: {}", (Object)globSyntax, (Object)file);
                        if (matchingFiles.size() >= limit) {
                            return FileVisitResult.TERMINATE;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    LOGGER.warn("Error reading file from {}: {}", (Object)globSyntax, (Object)exc.toString());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (dir.getFileName().toString().startsWith(".")) {
                        LOGGER.warn("Skipping dot dir while resolving {}: {}", (Object)globSyntax, (Object)dir);
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (matcher.matches(dir)) {
                        matchingFiles.add(dir);
                        LOGGER.info("Found matching dir for {}: {}", (Object)globSyntax, (Object)dir);
                        if (matchingFiles.size() >= limit) {
                            return FileVisitResult.TERMINATE;
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("IOException while resolving %s".formatted(globSyntax), (Throwable)e);
        }
        return matchingFiles;
    }

    private static boolean isGlobPattern(String s) {
        return s.contains("*") || s.contains("?") || s.contains("{") || s.contains("[");
    }
}

