/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.util.concurrent.Callable;
import net.minescript.common.Jsonable;

public class ScriptValue {
    private final Object value;
    private final Callable<JsonElement> toJson;
    public static final ScriptValue TRUE = ScriptValue.of(true);
    public static final ScriptValue FALSE = ScriptValue.of(false);
    public static final ScriptValue NULL = new ScriptValue(null, () -> JsonNull.INSTANCE);

    private ScriptValue(Object value, Callable<JsonElement> toJson) {
        this.value = value;
        this.toJson = toJson;
    }

    public static ScriptValue of(Object value, Callable<JsonElement> toJson) {
        return new ScriptValue(value, toJson);
    }

    public static ScriptValue of(Boolean value) {
        return new ScriptValue(value, () -> new JsonPrimitive(value));
    }

    public static ScriptValue of(Number value) {
        return new ScriptValue(value, () -> new JsonPrimitive(value));
    }

    public static ScriptValue of(String value) {
        return new ScriptValue(value, () -> new JsonPrimitive(value));
    }

    public static ScriptValue of(Jsonable value) {
        return new ScriptValue(value, value::toJson);
    }

    public static <T> ScriptValue of(T[] value) {
        return new ScriptValue(value, () -> new Gson().toJsonTree((Object)value));
    }

    public static <T> ScriptValue ofNullables(T[] value) {
        return new ScriptValue(value, () -> new GsonBuilder().serializeNulls().create().toJsonTree((Object)value));
    }

    public static ScriptValue fromJson(JsonElement value) {
        return new ScriptValue(value, () -> value);
    }

    public Object get() {
        return this.value;
    }

    public String toString() {
        return this.toJson().toString();
    }

    JsonElement toJson() {
        try {
            return this.toJson.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

