/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common.blocks;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.pyjinn.interpreter.Script;

public sealed interface BlockPositionReader {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final Pattern BLOCK_STATE_RE = Pattern.compile("^Block\\{([^}]*)\\}(\\[.*\\])?$");

    public String getblock(Object var1);

    public static String blockStateToString(class_2680 blockState) {
        Matcher match = BLOCK_STATE_RE.matcher(blockState.toString());
        if (!match.find()) {
            return null;
        }
        String blockType = match.group(1);
        String blockAttrs = match.group(2) == null ? "" : match.group(2);
        return blockType + blockAttrs;
    }

    public static String getBlockStateString(class_1937 level, class_2338 pos) {
        return BlockPositionReader.blockStateToString(level.method_8320(pos));
    }

    public static BlockPositionReader create(class_1937 level, Object samplePosition) {
        if (samplePosition instanceof List) {
            LOGGER.info("Identified getblocklist position type: List<?> ({})", (Object)samplePosition.getClass().getName());
            return new JavaList(level, new class_2338.class_2339());
        }
        if (samplePosition instanceof Object[]) {
            LOGGER.info("Identified getblocklist position type: Object[]");
            return new JavaObjectArray(level, new class_2338.class_2339());
        }
        if (samplePosition instanceof Integer[]) {
            LOGGER.info("Identified getblocklist position type: Integer[]");
            return new JavaIntegerArray(level, new class_2338.class_2339());
        }
        if (samplePosition instanceof int[]) {
            LOGGER.info("Identified getblocklist position type: int[]");
            return new JavaIntArray(level, new class_2338.class_2339());
        }
        if (samplePosition instanceof Script.ItemGetter) {
            LOGGER.info("Identified getblocklist position type: Script.ItemGetter ({})", (Object)samplePosition.getClass().getName());
            return new PyjinnItemGetter(level, new class_2338.class_2339());
        }
        if (samplePosition == null) {
            throw new IllegalArgumentException("getblocklist() expected a list, tuple, List<>, Object[], Integer[], or int[] of [x, y, z] but got null");
        }
        throw new IllegalArgumentException("getblocklist() expected a list, tuple, List<>, Object[], Integer[], or int[] of " + "[x, y, z] but got %s (%s)".formatted(samplePosition, samplePosition.getClass().getName()));
    }

    public record JavaList(class_1937 level, class_2338.class_2339 reusablePos) implements BlockPositionReader
    {
        @Override
        public String getblock(Object position) {
            if (position instanceof List) {
                List list = (List)position;
                if (!(list.size() == 3 && list.get(0) instanceof Number && list.get(1) instanceof Number && list.get(2) instanceof Number)) {
                    throw new IllegalArgumentException("getblocklist() expected List of [x, y, z] but got %s".formatted(list));
                }
                int x = ((Number)list.get(0)).intValue();
                int y = ((Number)list.get(1)).intValue();
                int z = ((Number)list.get(2)).intValue();
                return BlockPositionReader.getBlockStateString(this.level, (class_2338)this.reusablePos.method_10103(x, y, z));
            }
            throw new IllegalArgumentException("getblocklist() expected List of [x, y, z] but got %s (%s)".formatted(position, position.getClass().getName()));
        }
    }

    public record JavaObjectArray(class_1937 level, class_2338.class_2339 reusablePos) implements BlockPositionReader
    {
        @Override
        public String getblock(Object position) {
            if (position instanceof Object[]) {
                Object[] array = (Object[])position;
                if (!(array.length == 3 && array[0] instanceof Number && array[1] instanceof Number && array[2] instanceof Number)) {
                    throw new IllegalArgumentException("getblocklist() expected Object[] of [x, y, z] but got %s".formatted(Arrays.toString(array)));
                }
                int x = ((Number)array[0]).intValue();
                int y = ((Number)array[1]).intValue();
                int z = ((Number)array[2]).intValue();
                return BlockPositionReader.getBlockStateString(this.level, (class_2338)this.reusablePos.method_10103(x, y, z));
            }
            throw new IllegalArgumentException("getblocklist() expected Object[] of [x, y, z] but got %s (%s)".formatted(position, position.getClass().getName()));
        }
    }

    public record JavaIntegerArray(class_1937 level, class_2338.class_2339 reusablePos) implements BlockPositionReader
    {
        @Override
        public String getblock(Object position) {
            if (position instanceof Integer[]) {
                Object[] array = (Integer[])position;
                if (array.length != 3) {
                    throw new IllegalArgumentException("getblocklist() expected Integer[] of [x, y, z] but got %s".formatted(Arrays.toString(array)));
                }
                int x = array[0];
                int y = array[1];
                int z = (Integer)array[2];
                return BlockPositionReader.getBlockStateString(this.level, (class_2338)this.reusablePos.method_10103(x, y, z));
            }
            throw new IllegalArgumentException("getblocklist() expected Integer[] of [x, y, z] but got %s (%s)".formatted(position, position.getClass().getName()));
        }
    }

    public record JavaIntArray(class_1937 level, class_2338.class_2339 reusablePos) implements BlockPositionReader
    {
        @Override
        public String getblock(Object position) {
            if (position instanceof int[]) {
                int[] array = (int[])position;
                if (array.length != 3) {
                    throw new IllegalArgumentException("getblocklist() expected int[] of [x, y, z] but got %s".formatted(Arrays.toString(array)));
                }
                int x = array[0];
                int y = array[1];
                int z = array[2];
                return BlockPositionReader.getBlockStateString(this.level, (class_2338)this.reusablePos.method_10103(x, y, z));
            }
            throw new IllegalArgumentException("getblocklist() expected int[] of [x, y, z] but got %s (%s)".formatted(position, position.getClass().getName()));
        }
    }

    public record PyjinnItemGetter(class_1937 level, class_2338.class_2339 reusablePos) implements BlockPositionReader
    {
        @Override
        public String getblock(Object position) {
            if (position instanceof Script.ItemGetter) {
                Script.ItemGetter getter = (Script.ItemGetter)position;
                if (!(getter.__len__() == 3 && getter.__getitem__((Object)0) instanceof Number && getter.__getitem__((Object)1) instanceof Number && getter.__getitem__((Object)2) instanceof Number)) {
                    throw new IllegalArgumentException("getblocklist() expected a Pyjinn list or tuple of [x, y, z] but got %s".formatted(getter));
                }
                int x = ((Number)getter.__getitem__((Object)0)).intValue();
                int y = ((Number)getter.__getitem__((Object)1)).intValue();
                int z = ((Number)getter.__getitem__((Object)2)).intValue();
                return BlockPositionReader.getBlockStateString(this.level, (class_2338)this.reusablePos.method_10103(x, y, z));
            }
            throw new IllegalArgumentException("getblocklist() expected a Pyjinn list or tuple of [x, y, z] but got %s (%s)".formatted(position, position.getClass().getName()));
        }
    }
}

