/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import net.minescript.common.BlockPack;
import net.minescript.common.BlockPacker;
import net.minescript.common.CommandSyntax;
import net.minescript.common.Config;
import net.minescript.common.FunctionExecutor;
import net.minescript.common.JobControl;
import net.minescript.common.JobState;
import net.minescript.common.Message;
import net.minescript.common.ResourceTracker;
import net.minescript.common.ScriptConfig;
import net.minescript.common.ScriptFunctionRunner;
import net.minescript.common.ScriptValue;
import net.minescript.common.SystemMessageQueue;
import net.minescript.common.Task;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Job
implements JobControl {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().serializeNulls().create();
    protected final int jobId;
    protected final Optional<Integer> parentJobId;
    protected final ScriptConfig.BoundCommand command;
    protected final Task task;
    protected final Config config;
    protected final SystemMessageQueue systemMessageQueue;
    private volatile JobState state = JobState.NOT_STARTED;
    private final Consumer<Message> messageConsumer;
    private final Runnable doneCallback;
    private final Queue<Message> jobTickQueue = new ConcurrentLinkedQueue<Message>();
    private final Queue<Message> jobRenderQueue = new ConcurrentLinkedQueue<Message>();
    private final Lock lock = new ReentrantLock(true);
    private Map<Long, JobControl.Operation> operations = new ConcurrentHashMap<Long, JobControl.Operation>();

    protected Job(int jobId, Optional<Integer> parentJobId, ScriptConfig.BoundCommand command, Task task, Config config, SystemMessageQueue systemMessageQueue, Consumer<Message> messageConsumer, Runnable doneCallback) {
        this.jobId = jobId;
        this.parentJobId = parentJobId;
        this.command = command;
        this.task = task;
        this.config = config;
        this.systemMessageQueue = systemMessageQueue;
        this.messageConsumer = messageConsumer == null ? this.jobTickQueue::add : messageConsumer;
        this.doneCallback = doneCallback;
    }

    @Override
    public ScriptConfig.BoundCommand boundCommand() {
        return this.command;
    }

    @Override
    public void addOperation(long opId, JobControl.Operation op) {
        if (this.operations.put(opId, op) != null) {
            throw new IllegalStateException("Job added operation with duplicate ID: " + opId);
        }
    }

    public boolean removeOperation(long opId) {
        return this.operations.remove(opId) == null;
    }

    @Override
    public boolean cancelOperation(long opId) {
        JobControl.Operation op;
        if (this.config.debugOutput()) {
            LOGGER.info("Cancelling operation {} among {} in job {}", (Object)opId, this.operations.keySet(), (Object)this.jobId);
        }
        if ((op = this.operations.remove(opId)) != null) {
            op.cancel();
            return true;
        }
        LOGGER.warn("Failed to cancel operation {} among {} in job {}", (Object)opId, this.operations.keySet(), (Object)this.jobId);
        return false;
    }

    @Override
    public JobState state() {
        return this.state;
    }

    @Override
    public void yield() {
        this.lock.lock();
        this.lock.unlock();
    }

    @Override
    public Queue<Message> renderQueue() {
        return this.jobRenderQueue;
    }

    @Override
    public Queue<Message> tickQueue() {
        return this.jobTickQueue;
    }

    @Override
    public boolean respond(long functionCallId, ScriptValue returnValue, boolean finalReply) {
        String string;
        Object object;
        boolean result = this.task.sendResponse(functionCallId, returnValue, finalReply);
        if (functionCallId == 0L && (object = returnValue.get()) instanceof String && (string = (String)object).equals("exit!")) {
            if (this.config.debugOutput()) {
                LOGGER.info("Job {} got `exit!`, setting state to DONE", (Object)this.jobId);
            }
            this.state = JobState.DONE;
        }
        return result;
    }

    @Override
    public boolean raiseException(long functionCallId, Exception exception) {
        return this.task.sendException(functionCallId, exception);
    }

    protected boolean handleStdout(String text) {
        return false;
    }

    @Override
    public void processStdout(String text) {
        if (this.handleStdout(text)) {
            return;
        }
        switch (this.command.redirects().stdout()) {
            case CHAT: {
                if (text.startsWith("/")) {
                    this.messageConsumer.accept(Message.createMinecraftCommand(text.substring(1)));
                    break;
                }
                if (text.startsWith("\\")) {
                    this.messageConsumer.accept(Message.createMinescriptCommand(text.substring(1)));
                    break;
                }
                this.messageConsumer.accept(Message.createChatMessage(text));
                break;
            }
            case DEFAULT: 
            case ECHO: {
                this.messageConsumer.accept(Message.fromPlainText(text));
                break;
            }
            case LOG: {
                LOGGER.info(text);
                break;
            }
        }
    }

    @Override
    public void processStderr(String text) {
        if (this.config.stderrChatIgnorePattern().matcher(text).find()) {
            return;
        }
        switch (this.command.redirects().stderr()) {
            case CHAT: {
                if (text.startsWith("/")) {
                    this.messageConsumer.accept(Message.createMinecraftCommand(text.substring(1)));
                    break;
                }
                if (text.startsWith("\\")) {
                    this.messageConsumer.accept(Message.createMinescriptCommand(text.substring(1)));
                    break;
                }
                this.messageConsumer.accept(Message.createChatMessage(text));
                break;
            }
            case DEFAULT: 
            case ECHO: {
                this.messageConsumer.accept(Message.formatAsJsonColoredText(text, "yellow"));
                break;
            }
            case LOG: {
                LOGGER.info(text);
                break;
            }
        }
    }

    @Override
    public void logJobException(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        this.systemMessageQueue.logUserError("Exception in job `{}`: {} (see logs/latest.log for details)", this.jobSummary(), e.toString());
        LOGGER.error("exception stack trace in job `{}`: {}", (Object)this.jobSummary(), (Object)sw.toString());
    }

    protected abstract void start();

    @Override
    public boolean suspend() {
        if (this.state == JobState.KILLED) {
            this.systemMessageQueue.logUserError("Job already killed: {}", this.jobSummary());
            return false;
        }
        if (this.state == JobState.SUSPENDED) {
            this.systemMessageQueue.logUserError("Job already suspended: {}", this.jobSummary());
            return false;
        }
        try {
            int timeoutSeconds = 2;
            if (this.lock.tryLock(timeoutSeconds, TimeUnit.SECONDS)) {
                this.state = JobState.SUSPENDED;
                this.suspendOperations();
                return true;
            }
            this.systemMessageQueue.logUserError("Timed out trying to suspend job after {} seconds: {}", timeoutSeconds, this.jobSummary());
            return false;
        }
        catch (InterruptedException e) {
            this.systemMessageQueue.logException(e);
            return false;
        }
    }

    private void suspendOperations() {
        for (JobControl.Operation op : this.operations.values()) {
            op.suspend();
        }
    }

    @Override
    public boolean resume() {
        if (this.state != JobState.SUSPENDED && this.state != JobState.KILLED) {
            this.systemMessageQueue.logUserError("Job not suspended: {}", this.jobSummary());
            return false;
        }
        if (this.state == JobState.SUSPENDED) {
            this.state = JobState.RUNNING;
            this.resumeOperations();
        }
        try {
            this.lock.unlock();
        }
        catch (IllegalMonitorStateException e) {
            this.systemMessageQueue.logException(e);
            return false;
        }
        return true;
    }

    private void resumeOperations() {
        Iterator<JobControl.Operation> iter = this.operations.values().iterator();
        while (iter.hasNext()) {
            JobControl.Operation op = iter.next();
            if (!op.resumeAndCheckDone()) continue;
            iter.remove();
        }
    }

    @Override
    public void requestKill() {
        JobState prevState = this.state;
        this.state = JobState.KILLED;
        if (prevState == JobState.SUSPENDED) {
            this.resume();
        }
    }

    protected void setState(JobState state) {
        this.state = state;
    }

    protected abstract void onClose();

    protected final void close() {
        for (JobControl.Operation op : this.operations.values()) {
            op.cancel();
        }
        this.operations.clear();
        this.onClose();
        this.doneCallback.run();
    }

    @Override
    public int jobId() {
        return this.jobId;
    }

    @Override
    public Optional<Integer> parentJobId() {
        return this.parentJobId;
    }

    @Override
    public final String jobSummary() {
        return this.jobSummaryWithStatus("");
    }

    protected final String jobSummaryWithStatus(String status) {
        Object displayCommand = CommandSyntax.quoteCommand(this.command.command());
        if (((String)displayCommand).length() > 61) {
            displayCommand = ((String)displayCommand).substring(0, 61) + "...";
        }
        return String.format("[%d%s] %s%s%s", this.jobId, this.parentJobId.map(id -> ", parent=%d".formatted(id)).orElse(""), status, status.isEmpty() ? "" : ": ", displayCommand);
    }

    public String toString() {
        return this.jobSummaryWithStatus(this.state.toString());
    }

    public static class SubprocessJob
    extends Job {
        private final ScriptFunctionRunner scriptFunctionRunner;
        private Thread thread;
        public final ResourceTracker<Object> objects;
        public final ResourceTracker<BlockPack> blockpacks;
        public final ResourceTracker<BlockPacker> blockpackers;
        private static final String FUNCTION_PREFIX = "?mnsc:";

        public SubprocessJob(int jobId, Optional<Integer> parentJobId, ScriptConfig.BoundCommand command, Task task, Config config, SystemMessageQueue systemMessageQueue, ScriptFunctionRunner scriptFunctionRunner, Runnable doneCallback) {
            super(jobId, parentJobId, command, task, config, systemMessageQueue, null, doneCallback);
            this.scriptFunctionRunner = scriptFunctionRunner;
            this.objects = new ResourceTracker<Object>(Object.class, jobId, config);
            this.blockpacks = new ResourceTracker<BlockPack>(BlockPack.class, jobId, config);
            this.blockpackers = new ResourceTracker<BlockPacker>(BlockPacker.class, jobId, config);
        }

        @Override
        protected void start() {
            this.thread = new Thread(() -> SubprocessJob.runOnJobThread(this, this.task, this.systemMessageQueue, this.config), String.format("job-%d-%s", this.jobId, this.command.command()[0]));
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void runOnJobThread(Job job, Task task, SystemMessageQueue systemMessageQueue, Config config) {
            if (job.state() == JobState.NOT_STARTED) {
                job.setState(JobState.RUNNING);
            }
            try {
                long startTimeMillis = System.currentTimeMillis();
                int exitCode = task.run(job.boundCommand(), job);
                LOGGER.info("Job `{}` exited with code {}, draining message queues...", (Object)job.jobSummary(), (Object)exitCode);
                int millisToSleep = 1000;
                while (!(job.state() == JobState.KILLED || job.tickQueue().isEmpty() && job.renderQueue().isEmpty())) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        job.logJobException(e);
                    }
                }
                long endTimeMillis = System.currentTimeMillis();
                long reportJobSuccessThresholdMillis = config.reportJobSuccessThresholdMillis();
                if (exitCode != 0) {
                    systemMessageQueue.logUserError(job.jobSummaryWithStatus("Exited with error code " + exitCode), new Object[0]);
                } else if (reportJobSuccessThresholdMillis >= 0L && endTimeMillis - startTimeMillis > reportJobSuccessThresholdMillis) {
                    if (job.state() != JobState.KILLED) {
                        job.setState(JobState.DONE);
                    }
                    systemMessageQueue.logUserInfo(job.toString(), new Object[0]);
                }
            }
            finally {
                job.close();
            }
        }

        @Override
        protected boolean handleStdout(String text) {
            if (text.startsWith(FUNCTION_PREFIX)) {
                this.processFunctionCall(text.substring(FUNCTION_PREFIX.length()));
                return true;
            }
            return false;
        }

        private void processFunctionCall(String functionCallLine) {
            List args;
            FunctionExecutor executor;
            String[] functionCall = functionCallLine.split("\\s+", 4);
            long funcCallId = Long.valueOf(functionCall[0]);
            try {
                executor = FunctionExecutor.fromValue(functionCall[1]);
            }
            catch (IllegalArgumentException e) {
                this.raiseException(funcCallId, e);
                return;
            }
            String functionName = functionCall[2];
            String argsString = functionCall[3];
            try {
                args = (List)GSON.fromJson(argsString, ArrayList.class);
            }
            catch (JsonSyntaxException e) {
                String exceptionMessage = String.format("Syntax error in script function args to `%s`: `%s`. This is likely caused by unsynchronized output printed to stdout elsewhere in this script. If the error persists, try replacing those raw print() calls with minescript.echo() or printing to stderr instead.", functionName, functionCallLine);
                this.raiseException(funcCallId, new IllegalArgumentException(exceptionMessage));
                return;
            }
            if (executor == FunctionExecutor.SCRIPT_LOOP) {
                this.scriptFunctionRunner.run(this, functionName, funcCallId, args);
                return;
            }
            if (executor == FunctionExecutor.RENDER_LOOP) {
                this.renderQueue().add(Message.createFunctionCall(funcCallId, executor, functionName, args));
                return;
            }
            this.tickQueue().add(Message.createFunctionCall(funcCallId, executor, functionName, args));
        }

        @Override
        protected void onClose() {
            this.objects.releaseAll();
            this.blockpacks.releaseAll();
            this.blockpackers.releaseAll();
        }
    }
}

