/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.pyjinn.interpreter.Script;

public class ScriptFunctionCall {
    private final String name;
    private final ArgList args;
    private CallingConvention callingConvention = CallingConvention.PYTHON;

    public ScriptFunctionCall(String name, List<?> args) {
        this.name = name;
        this.args = new ArgList(name, args);
    }

    public void setCallingConvention(CallingConvention convention) {
        this.callingConvention = convention;
    }

    public String name() {
        return this.name;
    }

    public ArgList args() {
        return this.args;
    }

    public CallingConvention callingConvention() {
        return this.callingConvention;
    }

    public String toString() {
        return String.format("%s%s", this.name, this.args);
    }

    public static enum CallingConvention {
        PYTHON,
        JAVA;

    }

    public static class ArgList {
        private String functionName;
        private final List<?> args;
        private String[] expectedArgsNames = null;

        public ArgList(String functionName, List<?> args) {
            this.functionName = functionName;
            this.args = args;
        }

        public boolean isEmpty() {
            return this.args.isEmpty();
        }

        public int size() {
            return this.args.size();
        }

        public List<?> rawArgs() {
            return this.args;
        }

        public String toString() {
            return "(" + this.args.stream().map(Object::toString).collect(Collectors.joining(", ")) + ")";
        }

        public Object get(int argPos) {
            return this.args.get(argPos);
        }

        public void expectSize(int expectedArgs) {
            if (this.args.size() != expectedArgs) {
                throw new IllegalArgumentException(String.format("`%s` expected %d arg%s but got: %s", this.functionName, expectedArgs, expectedArgs == 1 ? "" : "s", this));
            }
        }

        public void expectArgs(String ... argNames) {
            this.expectSize(argNames.length);
            this.expectedArgsNames = argNames;
        }

        public boolean getBoolean(int argPos) {
            Object object = this.args.get(argPos);
            if (!(object instanceof Boolean)) {
                throw new IllegalArgumentException(this.expectedArgsNames == null ? String.format("`%s` expected arg %d to be bool but got: %s", this.functionName, argPos + 1, object) : String.format("`%s` expected %s to be bool but got: %s", this.functionName, this.expectedArgsNames[argPos], object));
            }
            Boolean value = (Boolean)object;
            return value;
        }

        public int getStrictInt(int argPos) {
            Object object = this.args.get(argPos);
            OptionalInt value = ArgList.getStrictIntValue(object);
            if (value.isEmpty()) {
                throw new IllegalArgumentException(this.expectedArgsNames == null ? String.format("`%s` expected arg %d to be int but got: %s", this.functionName, argPos + 1, object) : String.format("`%s` expected %s to be int but got: %s", this.functionName, this.expectedArgsNames[argPos], object));
            }
            return value.getAsInt();
        }

        public OptionalInt getOptionalStrictInt(int argPos) {
            return this.args.get(argPos) == null ? OptionalInt.empty() : OptionalInt.of(this.getStrictInt(argPos));
        }

        public int getConvertibleInt(int argPos) {
            Object object = this.args.get(argPos);
            if (!(object instanceof Number)) {
                throw new IllegalArgumentException(this.expectedArgsNames == null ? String.format("`%s` expected arg %d to be convertible to int but got: %s", this.functionName, argPos + 1, object) : String.format("`%s` expected %s to be convertible to int but got: %s", this.functionName, this.expectedArgsNames[argPos], object));
            }
            Number number = (Number)object;
            return number.intValue();
        }

        public long getStrictLong(int argPos) {
            Object object = this.args.get(argPos);
            OptionalLong value = ArgList.getStrictLongValue(object);
            if (value.isEmpty()) {
                throw new IllegalArgumentException(this.expectedArgsNames == null ? String.format("`%s` expected arg %d to be long but got: %s", this.functionName, argPos + 1, object) : String.format("`%s` expected %s to be long but got: %s", this.functionName, this.expectedArgsNames[argPos], object));
            }
            return value.getAsLong();
        }

        public double getDouble(int argPos) {
            Object object = this.args.get(argPos);
            OptionalDouble optional = ArgList.getDoubleValue(object);
            if (optional.isEmpty()) {
                throw new IllegalArgumentException(this.expectedArgsNames == null ? String.format("`%s` expected arg %d to be float but got: %s", this.functionName, argPos + 1, object) : String.format("`%s` expected %s to be float but got: %s", this.functionName, this.expectedArgsNames[argPos], object));
            }
            return optional.getAsDouble();
        }

        public OptionalDouble getOptionalDouble(int argPos) {
            return this.args.get(argPos) == null ? OptionalDouble.empty() : OptionalDouble.of(this.getDouble(argPos));
        }

        public String getString(int argPos) {
            Object object = this.args.get(argPos);
            if (!(object instanceof String)) {
                throw new IllegalArgumentException(this.expectedArgsNames == null ? String.format("`%s` expected arg %d to be string but got: %s", this.functionName, argPos + 1, object) : String.format("`%s` expected %s to be string but got: %s", this.functionName, this.expectedArgsNames[argPos], object));
            }
            return (String)object;
        }

        public Optional<String> getOptionalString(int argPos) {
            return this.args.get(argPos) == null ? Optional.empty() : Optional.of(this.getString(argPos));
        }

        public List<Integer> getIntListWithSize(int argPos, int expectedSize) {
            List list;
            Object object = this.convertToList(this.args.get(argPos));
            if (!(object instanceof List) || (list = (List)object).size() != expectedSize) {
                throw new IllegalArgumentException(this.expectedArgsNames == null ? String.format("`%s` expected arg %d to be list of %d ints but got: %s", this.functionName, argPos + 1, expectedSize, object) : String.format("`%s` expected %s to be list of %d ints but got: %s", this.functionName, this.expectedArgsNames[argPos], expectedSize, object));
            }
            ArrayList<Integer> intList = new ArrayList<Integer>();
            for (Object element : list) {
                OptionalInt asInt = ArgList.getStrictIntValue(element);
                if (asInt.isEmpty()) {
                    throw new IllegalArgumentException(this.expectedArgsNames == null ? String.format("`%s` expected arg %d to be list of %d ints but got: %s", this.functionName, argPos + 1, expectedSize, object) : String.format("`%s` expected %s to be list of %d ints but got: %s", this.functionName, this.expectedArgsNames[argPos], expectedSize, object));
                }
                intList.add(asInt.getAsInt());
            }
            return intList;
        }

        public Optional<List<Integer>> getOptionalIntListWithSize(int argPos, int expectedSize) {
            return this.args.get(argPos) == null ? Optional.empty() : Optional.of(this.getIntListWithSize(argPos, expectedSize));
        }

        public List<Double> getDoubleListWithSize(int argPos, int expectedSize) {
            List list;
            Object object = this.convertToList(this.args.get(argPos));
            if (!(object instanceof List) || (list = (List)object).size() != expectedSize) {
                throw new IllegalArgumentException(this.expectedArgsNames == null ? String.format("`%s` expected arg %d to be list of %d floats but got: %s", this.functionName, argPos + 1, expectedSize, object) : String.format("`%s` expected %s to be list of %d floats but got: %s", this.functionName, this.expectedArgsNames[argPos], expectedSize, object));
            }
            ArrayList<Double> intList = new ArrayList<Double>();
            for (Object element : list) {
                OptionalDouble asDouble = ArgList.getDoubleValue(element);
                if (asDouble.isEmpty()) {
                    throw new IllegalArgumentException(this.expectedArgsNames == null ? String.format("`%s` expected arg %d to be list of %d floats but got: %s", this.functionName, argPos + 1, expectedSize, object) : String.format("`%s` expected %s to be list of %d floats but got: %s", this.functionName, this.expectedArgsNames[argPos], expectedSize, object));
                }
                intList.add(asDouble.getAsDouble());
            }
            return intList;
        }

        public Optional<List<Double>> getOptionalDoubleListWithSize(int argPos, int expectedSize) {
            return this.args.get(argPos) == null ? Optional.empty() : Optional.of(this.getDoubleListWithSize(argPos, expectedSize));
        }

        public List<String> getConvertibleStringList(int argPos) {
            Object object = this.convertToList(this.args.get(argPos));
            if (!(object instanceof List)) {
                throw new IllegalArgumentException(this.expectedArgsNames == null ? String.format("`%s` expected arg %d to be list of strings but got: %s", this.functionName, argPos + 1, object) : String.format("`%s` expected %s to be list of strings but got: %s", this.functionName, this.expectedArgsNames[argPos], object));
            }
            List list = (List)object;
            ArrayList<String> stringList = new ArrayList<String>();
            for (Object element : list) {
                stringList.add(element.toString());
            }
            return stringList;
        }

        private Object convertToList(Object object) {
            if (object instanceof Script.PyjList) {
                Script.PyjList pyjList = (Script.PyjList)object;
                return Script.JavaListFunction.INSTANCE.call(null, new Object[]{pyjList});
            }
            if (object instanceof Script.PyjTuple) {
                Script.PyjTuple pyjTuple = (Script.PyjTuple)object;
                return StreamSupport.stream(pyjTuple.spliterator(), false).toList();
            }
            return object;
        }

        public Map<String, Object> getStringKeyMap(int argPos) {
            Object object = this.args.get(argPos);
            if (!(object instanceof Map)) {
                throw new IllegalArgumentException(this.expectedArgsNames == null ? String.format("`%s` expected arg %d to be string map but got: %s", this.functionName, argPos + 1, object) : String.format("`%s` expected %s to be string map but got: %s", this.functionName, this.expectedArgsNames[argPos], object));
            }
            Map map = (Map)object;
            for (Object key : map.keySet()) {
                if (key instanceof String) continue;
                throw new IllegalArgumentException(this.expectedArgsNames == null ? String.format("`%s` expected arg %d to be map keyed by strings but found key '%s': %s", this.functionName, argPos + 1, key, object) : String.format("`%s` expected %s to be map keyed by strings but found key '%s': %s", this.functionName, this.expectedArgsNames[argPos], key, object));
            }
            return map;
        }

        public Map<String, String> getConvertibleStringMap(int argPos) {
            Object object = this.args.get(argPos);
            if (!(object instanceof Map)) {
                throw new IllegalArgumentException(this.expectedArgsNames == null ? String.format("`%s` expected arg %d to be string map but got: %s", this.functionName, argPos + 1, object) : String.format("`%s` expected %s to be string map but got: %s", this.functionName, this.expectedArgsNames[argPos], object));
            }
            Map map = (Map)object;
            HashMap<String, String> stringMap = new HashMap<String, String>();
            for (Map.Entry entry : map.entrySet()) {
                stringMap.put(entry.getKey().toString(), entry.getValue().toString());
            }
            return stringMap;
        }

        public static OptionalDouble getDoubleValue(Object object) {
            if (object instanceof Number) {
                Number number = (Number)object;
                if (number instanceof Double) {
                    return OptionalDouble.of(number.doubleValue());
                }
                if (number instanceof Float) {
                    return OptionalDouble.of(number.doubleValue());
                }
                if (number instanceof Long) {
                    return OptionalDouble.of(number.doubleValue());
                }
                if (number instanceof Integer) {
                    return OptionalDouble.of(number.doubleValue());
                }
            }
            return OptionalDouble.empty();
        }

        public static OptionalInt getStrictIntValue(Object object) {
            double dbl;
            if (!(object instanceof Number)) {
                return OptionalInt.empty();
            }
            Number number = (Number)object;
            if (number instanceof Integer) {
                return OptionalInt.of(number.intValue());
            }
            if (number instanceof Long) {
                long lng = number.longValue();
                if (lng >= Integer.MIN_VALUE && lng <= Integer.MAX_VALUE) {
                    return OptionalInt.of(number.intValue());
                }
                return OptionalInt.empty();
            }
            if (number instanceof Double && !Double.isInfinite(dbl = number.doubleValue()) && dbl == Math.floor(dbl)) {
                return OptionalInt.of(number.intValue());
            }
            return OptionalInt.empty();
        }

        public static OptionalLong getStrictLongValue(Object object) {
            double dbl;
            if (!(object instanceof Number)) {
                return OptionalLong.empty();
            }
            Number number = (Number)object;
            if (number instanceof Integer) {
                return OptionalLong.of(number.intValue());
            }
            if (number instanceof Long) {
                return OptionalLong.of(number.longValue());
            }
            if (number instanceof Double && !Double.isInfinite(dbl = number.doubleValue()) && dbl == Math.floor(dbl)) {
                return OptionalLong.of(number.longValue());
            }
            return OptionalLong.empty();
        }
    }
}

