/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common;

import java.util.ArrayDeque;
import java.util.Base64;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.minescript.common.BlockPack;

public class BlockPacker
implements BlockPack.BlockConsumer {
    private final SortedMap<Long, Tile> tiles = new TreeMap<Long, Tile>();
    private final IdAllocator idAllocator = new IdAllocator();
    private Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private Map<Integer, String> symbolMap = new HashMap<Integer, String>();
    private Map<String, String> comments = new HashMap<String, String>();
    private boolean debug = false;

    public BlockPacker() {
        int voidId = this.idAllocator.allocateId();
        if (voidId != 0) {
            throw new IllegalStateException(String.format("Expected type ID of structure_void to be 0 but got %d", voidId));
        }
        this.typeMap.put("structure_void", voidId);
        this.symbolMap.put(voidId, "structure_void");
    }

    public void enableDebug() {
        this.debug = true;
    }

    private static short[] convertBytesToShorts(byte[] bytes) {
        if (bytes.length % 2 != 0) {
            throw new IllegalArgumentException("Expected array with even number of bytes but got " + bytes.length);
        }
        short[] shorts = new short[bytes.length / 2];
        for (int i = 0; i < shorts.length; ++i) {
            shorts[i] = (short)((bytes[i * 2] & 0xFF) << 8 | bytes[i * 2 + 1] & 0xFF);
        }
        return shorts;
    }

    public void addBlocks(int offsetX, int offsetY, int offsetZ, String setblocksBase64, String fillsBase64, List<String> blocks) {
        short[] setblocksArray = BlockPacker.convertBytesToShorts(Base64.getDecoder().decode(setblocksBase64));
        short[] fillsArray = BlockPacker.convertBytesToShorts(Base64.getDecoder().decode(fillsBase64));
        this.addBlocks(offsetX, offsetY, offsetZ, setblocksArray, fillsArray, blocks);
    }

    public void addBlocks(int offsetX, int offsetY, int offsetZ, short[] setblocksArray, short[] fillsArray, List<String> blocks) {
        int i;
        if (fillsArray.length % 7 != 0) {
            throw new IllegalArgumentException("Expected `fills` array with length divisible by 7 but got " + fillsArray.length);
        }
        if (setblocksArray.length % 4 != 0) {
            throw new IllegalArgumentException("Expected `setblocks` array with length divisible by 4 but got " + setblocksArray.length);
        }
        for (i = 0; i < fillsArray.length; i += 7) {
            this.fill(offsetX + fillsArray[i], offsetY + fillsArray[i + 1], offsetZ + fillsArray[i + 2], offsetX + fillsArray[i + 3], offsetY + fillsArray[i + 4], offsetZ + fillsArray[i + 5], blocks.get(fillsArray[i + 6]));
        }
        for (i = 0; i < setblocksArray.length; i += 4) {
            this.setblock(offsetX + setblocksArray[i], offsetY + setblocksArray[i + 1], offsetZ + setblocksArray[i + 2], blocks.get(setblocksArray[i + 3]));
        }
    }

    @Override
    public void fill(int x1, int y1, int z1, int x2, int y2, int z2, String blockType) {
        int minX = Math.min(x1, x2);
        int maxX = Math.max(x1, x2);
        int minY = Math.min(y1, y2);
        int maxY = Math.max(y1, y2);
        int minZ = Math.min(z1, z2);
        int maxZ = Math.max(z1, z2);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    this.setblock(x, y, z, blockType);
                }
            }
        }
    }

    @Override
    public void setblock(int x, int y, int z, String blockType) {
        long key = BlockPack.getTileKey(x, y, z);
        Tile tile = this.tiles.computeIfAbsent(key, k -> new Tile(BlockPack.getXFromPackedCoords(key), BlockPack.getYFromPackedCoords(key), BlockPack.getZFromPackedCoords(key)));
        int blockTypeId = this.typeMap.computeIfAbsent(blockType, k -> this.idAllocator.allocateId());
        this.symbolMap.putIfAbsent(blockTypeId, blockType);
        tile.setBlock(x, y, z, blockTypeId);
    }

    public void printDebugInfo() {
        for (Map.Entry<Integer, String> entry : this.symbolMap.entrySet()) {
            System.out.printf("# symbol: %d -> %s\n", entry.getKey(), entry.getValue());
        }
        for (Tile tile : this.tiles.values()) {
            int x = tile.xOffset;
            int y = tile.yOffset;
            int z = tile.zOffset;
            System.out.printf("# tile offset: %d %d %d\n", x, y, z);
            System.out.print(tile.getDebugInfo(this.symbolMap));
        }
    }

    public Map<String, String> comments() {
        return this.comments;
    }

    public BlockPack pack() {
        TreeMap<Long, BlockPack.Tile> packedTiles = new TreeMap<Long, BlockPack.Tile>();
        int packBytes = 0;
        int runLengthBytes = 0;
        int bytes = 0;
        for (Map.Entry<Long, Tile> entry : this.tiles.entrySet()) {
            long key = entry.getKey();
            Tile tile = entry.getValue();
            tile.computeRunLengths();
            tile.updateTypeList();
            ShortList fills = new ShortList();
            ShortList setblocks = new ShortList();
            tile.computeBlockCommands(fills, setblocks);
            BlockPack.Tile packedTile = new BlockPack.Tile(tile.xOffset, tile.yOffset, tile.zOffset, tile.types, fills.toArray(), setblocks.toArray());
            packedTiles.put(key, packedTile);
            if (!this.debug) continue;
            int tilePackBytes = setblocks.size() * 2 + fills.size() * 2;
            packBytes += tilePackBytes;
            short prevBlock = -1;
            int runLengths = 0;
            for (int i = 0; i < tile.blocks.length; ++i) {
                short block = tile.blocks[i];
                if (block == prevBlock) continue;
                prevBlock = block;
                ++runLengths;
            }
            int tileRunLengthBytes = runLengths * 4;
            runLengthBytes += tileRunLengthBytes;
            bytes += Math.min(tilePackBytes, tileRunLengthBytes);
            System.out.printf("tilebytes: offset %d,%d,%d  packed %d  runlen %d  diff %d\n", tile.xOffset, tile.yOffset, tile.zOffset, tilePackBytes, tileRunLengthBytes, tileRunLengthBytes - tilePackBytes);
        }
        if (this.debug) {
            int symbolBytes = 0;
            for (Map.Entry<Integer, String> entry : this.symbolMap.entrySet()) {
                symbolBytes += entry.getValue().length();
            }
            System.out.printf("symbolbytes: %d for %d entries\n", symbolBytes, this.symbolMap.size());
            System.out.printf("totalbytes: min=%d packed=%d runlen=%d diff=%d\n", bytes, packBytes, runLengthBytes, runLengthBytes - packBytes);
        }
        return new BlockPack(this.symbolMap, packedTiles, this.comments);
    }

    static class IdAllocator {
        private Deque<Integer> freelist = new ArrayDeque<Integer>();
        private int nextId = 0;

        IdAllocator() {
        }

        public int allocateId() {
            if (this.freelist.isEmpty()) {
                return this.nextId++;
            }
            return this.freelist.removeFirst();
        }

        public void freeId(int id) {
            this.freelist.addLast(id);
        }
    }

    public static class Tile {
        private final int xOffset;
        private final int yOffset;
        private final int zOffset;
        private final int xSize;
        private final int ySize;
        private final int zSize;
        private final int xzArea;
        private Map<Integer, Short> tileTypeMap = new HashMap<Integer, Short>();
        private Map<Short, Integer> typeFrequencies = new HashMap<Short, Integer>();
        private int[] types;
        private final IdAllocator tileIdAllocator = new IdAllocator();
        private int maxFrequencyType = -1;
        private boolean prefillVolume = false;
        private static final int STRUCTURE_VOID_BLOCK = 0;
        private final short[] blocks;
        private short[] blockMetrics;

        public Tile(int xOffset, int yOffset, int zOffset) {
            this(xOffset, yOffset, zOffset, 32, 32, 32);
        }

        public Tile(int xOffset, int yOffset, int zOffset, int xSize, int ySize, int zSize) {
            if (xSize < 1 || xSize > 32) {
                throw new IllegalArgumentException("xSize outside bounds [1, 32]: " + xSize);
            }
            if (ySize < 1 || ySize > 32) {
                throw new IllegalArgumentException("ySize outside bounds [1, 32]: " + ySize);
            }
            if (zSize < 1 || zSize > 32) {
                throw new IllegalArgumentException("zSize outside bounds [1, 32]: " + zSize);
            }
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.zOffset = zOffset;
            this.xSize = xSize;
            this.ySize = ySize;
            this.zSize = zSize;
            this.xzArea = xSize * zSize;
            int xyzVolume = this.xzArea * ySize;
            this.blocks = new short[xyzVolume];
            this.blockMetrics = null;
            short voidId = this.tileTypeId(0);
            if (voidId != 0) {
                throw new IllegalStateException(String.format("Expected type ID of structure_void to be 0 but got %d", voidId));
            }
            this.typeFrequencies.put(voidId, xyzVolume);
        }

        public int coordToIndex(int x, int y, int z) {
            return x + this.xSize * z + this.xzArea * y;
        }

        private void indexToCoordArray(int index, int[] coord) {
            coord[0] = index % this.xSize;
            coord[2] = index / this.xSize % this.zSize;
            coord[1] = index / this.xzArea;
        }

        private String indexToCoordString(int index) {
            int[] coord = new int[3];
            this.indexToCoordArray(index, coord);
            return String.format("(%d, %d, %d)", coord[0], coord[1], coord[2]);
        }

        private short tileTypeId(int packerTypeId) {
            return this.tileTypeMap.computeIfAbsent(packerTypeId, k -> {
                int id = this.tileIdAllocator.allocateId();
                if (id < 0 || id > Short.MAX_VALUE) {
                    throw new IllegalStateException(String.format("BlockPacker.Tile allocated block type ID outside of expected range 0..%d: %d", (short)Short.MAX_VALUE, id));
                }
                return (short)id;
            });
        }

        private void updateTypeList() {
            if (this.types != null && this.types.length == this.tileTypeMap.size()) {
                return;
            }
            this.types = new int[this.tileTypeMap.size()];
            for (Map.Entry<Integer, Short> entry : this.tileTypeMap.entrySet()) {
                this.types[entry.getValue().shortValue()] = entry.getKey();
            }
        }

        public void setBlock(int x, int y, int z, int blockTypeId) {
            short previousBlockType;
            if (x < this.xOffset || x >= this.xOffset + this.xSize || y < this.yOffset || y >= this.yOffset + this.ySize || z < this.zOffset || z >= this.zOffset + this.zSize) {
                throw new ArrayIndexOutOfBoundsException(String.format("Coord (%d, %d, %d) out of bounds for volume [%d..%d, %d..%d, %d..%d]", x, y, z, this.xOffset, this.xOffset + this.xSize, this.yOffset, this.yOffset + this.ySize, this.zOffset, this.zOffset + this.zSize));
            }
            short type = this.tileTypeId(blockTypeId);
            if (type != (previousBlockType = this.setBlockType(x - this.xOffset, y - this.yOffset, z - this.zOffset, type))) {
                int previousBlockTypeFrequency = this.typeFrequencies.get(previousBlockType) - 1;
                if (previousBlockTypeFrequency == 0) {
                    this.typeFrequencies.remove(previousBlockType);
                    this.tileIdAllocator.freeId(previousBlockType);
                } else {
                    this.typeFrequencies.put(previousBlockType, previousBlockTypeFrequency);
                }
                this.typeFrequencies.put(type, this.typeFrequencies.computeIfAbsent(type, k -> 0) + 1);
            }
        }

        public void computeRunLengths() {
            this.blockMetrics = new short[this.blocks.length];
            int maxFrequency = 0;
            for (Map.Entry<Short, Integer> entry : this.typeFrequencies.entrySet()) {
                Short type = entry.getKey();
                Integer frequency = entry.getValue();
                if (frequency <= maxFrequency) continue;
                this.maxFrequencyType = type.shortValue();
                maxFrequency = frequency;
            }
            for (int y = this.ySize - 1; y >= 0; --y) {
                for (int z = this.zSize - 1; z >= 0; --z) {
                    for (int x = this.xSize - 1; x >= 0; --x) {
                        int index = this.coordToIndex(x, y, z);
                        short type = this.getBlockType(index);
                        if (this.prefillVolume && type == this.maxFrequencyType) continue;
                        int xPlusOneIndex = this.coordToIndex(x + 1, y, z);
                        int yPlusOneIndex = this.coordToIndex(x, y + 1, z);
                        int zPlusOneIndex = this.coordToIndex(x, y, z + 1);
                        int plusXRun = x < this.xSize - 1 && this.getBlockType(xPlusOneIndex) == type ? 1 + this.getBlockPlusXRun(xPlusOneIndex) : 0;
                        int plusYRun = y < this.ySize - 1 && this.getBlockType(yPlusOneIndex) == type ? 1 + this.getBlockPlusYRun(yPlusOneIndex) : 0;
                        int plusZRun = z < this.zSize - 1 && this.getBlockType(zPlusOneIndex) == type ? 1 + this.getBlockPlusZRun(zPlusOneIndex) : 0;
                        this.setBlockRuns(index, plusXRun, plusYRun, plusZRun);
                    }
                }
            }
        }

        public void computeBlockCommands(ShortList fills, ShortList setblocks) {
            for (int y = 0; y < this.ySize; ++y) {
                for (int x = 0; x < this.xSize; ++x) {
                    for (int z = 0; z < this.zSize; ++z) {
                        short blockType;
                        int index = this.coordToIndex(x, y, z);
                        if (this.isBlockPacked(index) || (blockType = this.getBlockType(index)) == 0 || this.prefillVolume && this.getBlockType(index) == this.maxFrequencyType) continue;
                        int minXRun = this.xSize;
                        int minZRun = this.zSize;
                        int maxArea = 0;
                        int maxAreaX = -1;
                        int maxAreaZ = -1;
                        int minYRun = Integer.MAX_VALUE;
                        int xRun = this.getBlockPlusXRun(index);
                        for (int x2 = x; x2 < x + xRun + 1; ++x2) {
                            int zRun = this.getBlockPlusZRun(this.coordToIndex(x2, y, z));
                            if (zRun < minZRun) {
                                minZRun = zRun;
                            }
                            for (int z2 = z; z2 < z + minZRun + 1; ++z2) {
                                int area = (x2 - x + 1) * (z2 - z + 1);
                                if (area <= maxArea) continue;
                                maxArea = area;
                                maxAreaX = x2;
                                maxAreaZ = z2;
                            }
                        }
                        if (maxAreaX != -1 && maxAreaZ != -1) {
                            for (int x2 = x; x2 < maxAreaX + 1; ++x2) {
                                for (int z2 = z; z2 < maxAreaZ + 1; ++z2) {
                                    int yRun = this.getBlockPlusYRun(this.coordToIndex(x2, y, z2));
                                    if (yRun >= minYRun) continue;
                                    minYRun = yRun;
                                }
                            }
                        }
                        if (minYRun >= Integer.MAX_VALUE) continue;
                        int dx = maxAreaX - x;
                        int dy = minYRun;
                        int dz = maxAreaZ - z;
                        if (dx == 0 && dy == 0 && dz == 0) {
                            setblocks.addCoord(x, y, z).add(blockType);
                        } else {
                            fills.addCoord(x, y, z).addCoord(maxAreaX, y + minYRun, maxAreaZ).add(blockType);
                        }
                        for (int x2 = x; x2 < maxAreaX + 1; ++x2) {
                            for (int z2 = z; z2 < maxAreaZ + 1; ++z2) {
                                for (int y2 = y; y2 < y + minYRun + 1; ++y2) {
                                    this.setBlockPacked(x2, y2, z2);
                                }
                            }
                        }
                    }
                }
            }
        }

        private short setBlockType(int x, int y, int z, short type) {
            int index = this.coordToIndex(x, y, z);
            short previousBlockType = this.blocks[index];
            this.blocks[index] = type;
            return previousBlockType;
        }

        private void setBlockPacked(int x, int y, int z) {
            int index;
            int n = index = this.coordToIndex(x, y, z);
            this.blockMetrics[n] = (short)(this.blockMetrics[n] | 0x8000);
        }

        private void setBlockRuns(int index, int plusXRun, int plusYRun, int plusZRun) {
            if (plusXRun < 0 || plusXRun >= this.xSize) {
                throw new IllegalArgumentException(String.format("+x run length not in range [0, %d): %d", this.xSize, plusXRun));
            }
            if (plusYRun < 0 || plusYRun >= this.ySize) {
                throw new IllegalArgumentException(String.format("+y run length not in range [0, %d): %d", this.ySize, plusYRun));
            }
            if (plusZRun < 0 || plusZRun >= this.zSize) {
                throw new IllegalArgumentException(String.format("+z run length not in range [0, %d): %d", this.zSize, plusZRun));
            }
            int value = this.blockMetrics[index];
            value = value & 0x8000 | plusXRun | plusYRun << 5 | plusZRun << 10;
            this.blockMetrics[index] = (short)value;
        }

        private short getBlockType(int index) {
            return this.blocks[index];
        }

        private int getBlockPlusXRun(int index) {
            return this.blockMetrics[index] & 0x1F;
        }

        private int getBlockPlusYRun(int index) {
            return (this.blockMetrics[index] & 0x3E0) >> 5;
        }

        private int getBlockPlusZRun(int index) {
            return (this.blockMetrics[index] & 0x7C00) >> 10;
        }

        private boolean isBlockPacked(int index) {
            return (this.blockMetrics[index] & 0x8000) != 0;
        }

        private static String hex(int value) {
            return String.format("%X", value);
        }

        public String getDebugInfo(Map<Integer, String> symbolMap) {
            this.updateTypeList();
            StringBuilder buffer = new StringBuilder();
            buffer.append("Type map:\n");
            for (int i = 0; i < this.types.length; ++i) {
                if (!this.typeFrequencies.containsKey((short)i)) continue;
                buffer.append(String.format("  %d -> [%dx] %d -> %s\n", i, this.typeFrequencies.get((short)i), this.types[i], symbolMap.get(this.types[i])));
            }
            buffer.append('\n');
            for (int y = this.ySize - 1; y >= 0; --y) {
                buffer.append("y=");
                buffer.append(Tile.hex(y));
                buffer.append(":\n");
                buffer.append("    x:");
                for (int i = 0; i < this.xSize; ++i) {
                    buffer.append("        " + Tile.hex(i));
                }
                buffer.append('\n');
                for (int z = 0; z < this.zSize; ++z) {
                    buffer.append("  z=");
                    buffer.append(Tile.hex(z));
                    buffer.append(":");
                    for (int x = 0; x < this.xSize; ++x) {
                        buffer.append(" ");
                        int index = this.coordToIndex(x, y, z);
                        buffer.append(String.format("%2d:%X,%X,%X", this.getBlockType(index), this.getBlockPlusXRun(index), this.getBlockPlusYRun(index), this.getBlockPlusZRun(index)));
                    }
                    buffer.append('\n');
                }
                buffer.append('\n');
            }
            return buffer.toString();
        }
    }

    public static class ShortList {
        private int size = 0;
        private short[] shorts = new short[64];

        public ShortList addCoord(int x, int y, int z) {
            return this.add((short)(x << 10 | y << 5 | z));
        }

        public ShortList add(short i) {
            if (this.size >= this.shorts.length) {
                short[] newInts = new short[2 * this.shorts.length];
                System.arraycopy(this.shorts, 0, newInts, 0, this.shorts.length);
                this.shorts = newInts;
            }
            this.shorts[this.size++] = i;
            return this;
        }

        public int size() {
            return this.size;
        }

        public short get(int i) {
            return this.shorts[i];
        }

        public short[] toArray() {
            short[] copy = new short[this.size];
            System.arraycopy(this.shorts, 0, copy, 0, this.size);
            return copy;
        }
    }
}

