/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minescript.common.FilePattern;
import net.minescript.common.Message;
import net.minescript.common.ScriptConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class Config {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern CONFIG_LINE_RE = Pattern.compile("([^=]+)=(.*)");
    private static final Pattern DOUBLE_QUOTED_STRING_RE = Pattern.compile("\"(.*)\"");
    private static final Pattern CONFIG_AUTORUN_RE = Pattern.compile("autorun\\[(.*)\\]");
    private static Gson GSON = new GsonBuilder().serializeNulls().create();
    private static final ImmutableList<String> VARIABLE_LIST = ImmutableList.of((Object)"python", (Object)"command", (Object)"escape_command_double_quotes", (Object)"command_path", (Object)"pyjinn_import_path", (Object)"max_commands_per_cycle", (Object)"command_cycle_deadline_usecs", (Object)"ticks_per_cycle", (Object)"incremental_command_suggestions", (Object)"debug_output", (Object)"stderr_chat_ignore_pattern", (Object)"minescript_on_chat_received_event", (Object[])new String[]{"secondary_enter_key_code", "report_job_success_threshold_millis", "autorun["});
    private static final ImmutableList<String> CONFIG_VARIABLE_LIST = ImmutableList.copyOf((Collection)VARIABLE_LIST.stream().map(s -> "config " + s).collect(Collectors.toList()));
    private final String minescriptDirName;
    private final Path absMinescriptDir;
    private final File file;
    private long lastConfigLoadTime = 0L;
    private String pythonLocation;
    private final ImmutableList<String> builtinCommands;
    private final ImmutableSet<String> ignoreDirsForCompletions;
    private ScriptConfig scriptConfig;
    private final List<String> commands = new ArrayList<String>();
    private Pattern stderrChatIgnorePattern = Pattern.compile("^$");
    private boolean minescriptOnChatReceivedEvent = false;
    private int secondaryEnterKeyCode = 335;
    private Map<String, List<Message>> autorunCommands = new ConcurrentHashMap<String, List<Message>>();
    private boolean debugOutput = false;
    private boolean incrementalCommandSuggestions = false;
    private int ticksPerCycle = 1;
    private int maxCommandsPerCycle = 15;
    private int commandCycleDeadlineUsecs = 10000;
    private int reportJobSuccessThresholdMillis = 3000;

    public Config(String minescriptDirName, String configFileName, ImmutableList<String> builtinCommands, ImmutableSet<String> ignoreDirsForCompletions) {
        this.minescriptDirName = minescriptDirName;
        this.absMinescriptDir = Paths.get(System.getProperty("user.dir"), minescriptDirName);
        this.file = new File(Paths.get(minescriptDirName, configFileName).toString());
        this.builtinCommands = builtinCommands;
        this.ignoreDirsForCompletions = ignoreDirsForCompletions;
    }

    public File file() {
        return this.file;
    }

    public void load() {
        if (this.file.lastModified() < this.lastConfigLoadTime) {
            return;
        }
        this.lastConfigLoadTime = System.currentTimeMillis();
        this.commands.clear();
        this.autorunCommands.clear();
        this.scriptConfig = new ScriptConfig(this.minescriptDirName, this.builtinCommands, this.ignoreDirsForCompletions);
        try (BufferedReader reader = new BufferedReader(new FileReader(this.file.getPath()));){
            Object line;
            Object continuedLine = null;
            int lineNum = 0;
            int[] lineNumWrapper = new int[1];
            while ((line = reader.readLine()) != null) {
                lineNumWrapper[0] = ++lineNum;
                if (((String)(line = ((String)line).stripLeading())).endsWith("\\\\")) {
                    line = ((String)line).substring(0, ((String)line).length() - 1);
                } else if (((String)line).endsWith("\\")) {
                    line = ((String)line).substring(0, ((String)line).length() - 1);
                    if (continuedLine == null) {
                        continuedLine = line;
                        continue;
                    }
                    continuedLine = (String)continuedLine + " " + (String)line;
                    continue;
                }
                if (continuedLine != null) {
                    line = continuedLine + " " + (String)line;
                    continuedLine = null;
                }
                if (((String)line).matches("[^=]*=\\s*\\{.*") && !((String)line).strip().endsWith("}")) {
                    continuedLine = line;
                    continue;
                }
                if (((String)(line = ((String)line).strip())).isEmpty() || ((String)line).startsWith("#")) continue;
                Matcher match = CONFIG_LINE_RE.matcher((CharSequence)line);
                if (match.matches()) {
                    String name = match.group(1).strip();
                    String value = match.group(2).strip();
                    if ((match = DOUBLE_QUOTED_STRING_RE.matcher(value)).matches()) {
                        value = match.group(1);
                    }
                    this.setValue(name, value, status -> {
                        if (status.success()) {
                            LOGGER.info(status.message());
                        } else {
                            LOGGER.error("config.txt:{}: {}", (Object)lineNumWrapper[0], (Object)status.message());
                        }
                    });
                    continue;
                }
                LOGGER.warn("config.txt:{}: unable parse config line: {}", (Object)lineNum, line);
            }
        }
        catch (IOException e) {
            LOGGER.error("Exception loading config file: {}", (Throwable)e);
        }
    }

    public ScriptConfig scriptConfig() {
        return this.scriptConfig;
    }

    public List<Message> getAutorunCommands(String worldName) {
        return this.autorunCommands.get(worldName);
    }

    public Pattern stderrChatIgnorePattern() {
        return this.stderrChatIgnorePattern;
    }

    public boolean minescriptOnChatReceivedEvent() {
        return this.minescriptOnChatReceivedEvent;
    }

    public int secondaryEnterKeyCode() {
        return this.secondaryEnterKeyCode;
    }

    public int reportJobSuccessThresholdMillis() {
        return this.reportJobSuccessThresholdMillis;
    }

    public void setDebugOutptut(boolean enable) {
        this.debugOutput = enable;
    }

    public boolean debugOutput() {
        return this.debugOutput;
    }

    public void setIncrementalCommandSuggestions(boolean enable) {
        this.incrementalCommandSuggestions = enable;
    }

    public boolean incrementalCommandSuggestions() {
        return this.incrementalCommandSuggestions;
    }

    public int maxCommandsPerCycle() {
        return this.maxCommandsPerCycle;
    }

    public int commandCycleDeadlineUsecs() {
        return this.commandCycleDeadlineUsecs;
    }

    public int ticksPerCycle() {
        return this.ticksPerCycle;
    }

    public ImmutableList<String> getConfigVariables() {
        return CONFIG_VARIABLE_LIST;
    }

    public void forEachValue(BiConsumer<String, String> consumer) {
        consumer.accept("python", this.getValue("python"));
        consumer.accept("command", this.getValue("command"));
        consumer.accept("escape_command_double_quotes", this.getValue("escape_command_double_quotes"));
        consumer.accept("command_path", this.getValue("command_path"));
        consumer.accept("pyjinn_import_path", this.getValue("pyjinn_import_path"));
        consumer.accept("max_commands_per_cycle", this.getValue("max_commands_per_cycle"));
        consumer.accept("command_cycle_deadline_usecs", this.getValue("command_cycle_deadline_usecs"));
        consumer.accept("ticks_per_cycle", this.getValue("ticks_per_cycle"));
        consumer.accept("incremental_command_suggestions", this.getValue("incremental_command_suggestions"));
        consumer.accept("debug_output", this.getValue("debug_output"));
        consumer.accept("stderr_chat_ignore_pattern", this.getValue("stderr_chat_ignore_pattern"));
        consumer.accept("minescript_on_chat_received_event", this.getValue("minescript_on_chat_received_event"));
        consumer.accept("secondary_enter_key_code", this.getValue("secondary_enter_key_code"));
        consumer.accept("report_job_success_threshold_millis", this.getValue("report_job_success_threshold_millis"));
        for (Map.Entry<String, List<Message>> entry : this.autorunCommands.entrySet()) {
            String worldName = entry.getKey();
            List<Message> commands = entry.getValue();
            consumer.accept(String.format("autorun[%s]", worldName), String.join((CharSequence)"\n", commands.stream().map(Message::value).collect(Collectors.toList())));
        }
    }

    public String getValue(String name) {
        switch (name) {
            case "python": {
                return this.pythonLocation;
            }
            case "command": {
                return String.join((CharSequence)"\n", this.commands);
            }
            case "escape_command_double_quotes": {
                return String.valueOf(this.scriptConfig.escapeCommandDoubleQuotes());
            }
            case "command_path": {
                return this.scriptConfig.commandPath().stream().map(FilePattern::toString).collect(Collectors.joining(File.pathSeparator));
            }
            case "pyjinn_import_path": {
                return this.scriptConfig.pyjinnImportPath().stream().map(FilePattern::toString).collect(Collectors.joining(File.pathSeparator));
            }
            case "max_commands_per_cycle": {
                return String.valueOf(this.maxCommandsPerCycle);
            }
            case "command_cycle_deadline_usecs": {
                return String.valueOf(this.commandCycleDeadlineUsecs);
            }
            case "ticks_per_cycle": {
                return String.valueOf(this.ticksPerCycle);
            }
            case "incremental_command_suggestions": {
                return String.valueOf(this.incrementalCommandSuggestions);
            }
            case "debug_output": {
                return String.valueOf(this.debugOutput);
            }
            case "stderr_chat_ignore_pattern": {
                return this.stderrChatIgnorePattern.toString();
            }
            case "minescript_on_chat_received_event": {
                return String.valueOf(this.minescriptOnChatReceivedEvent);
            }
            case "secondary_enter_key_code": {
                return String.valueOf(this.secondaryEnterKeyCode);
            }
            case "report_job_success_threshold_millis": {
                return String.valueOf(this.reportJobSuccessThresholdMillis);
            }
        }
        Matcher match = CONFIG_AUTORUN_RE.matcher(name);
        if (match.matches()) {
            String worldName = match.group(1);
            List<Message> commands = this.autorunCommands.get(worldName);
            if (commands == null) {
                return "<null>";
            }
            return String.join((CharSequence)"\n", commands.stream().map(Message::value).collect(Collectors.toList()));
        }
        throw new IllegalArgumentException(String.format("Unrecognized config var: \"%s\"", name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String name, String value, Consumer<Status> out) {
        switch (name) {
            case "python": {
                String python = System.getProperty("os.name").startsWith("Windows") ? (value.contains("%userprofile%") ? value.replace("%userprofile%", System.getProperty("user.home")) : value) : (value.startsWith("~/") ? value.replaceFirst("~", Matcher.quoteReplacement(System.getProperty("user.home"))) : value);
                ImmutableList commandPattern = ImmutableList.of((Object)python, (Object)"-u", (Object)"{command}", (Object)"{args}");
                ImmutableList environmentVars = ImmutableList.of((Object)("PYTHONPATH=" + String.join((CharSequence)File.pathSeparator, (Iterable<? extends CharSequence>)ImmutableList.of((Object)this.absMinescriptDir.resolve(Paths.get("system", "lib")).toString(), (Object)this.absMinescriptDir.toString()))));
                try {
                    ScriptConfig.CommandConfig commandConfig = new ScriptConfig.CommandConfig(".py", (List<String>)commandPattern, (List<String>)environmentVars);
                    this.scriptConfig.configureSubprocessFileType(commandConfig);
                    this.reportInfo(out, "Setting config var: {} = \"{}\" ({})", name, value, commandConfig);
                    this.pythonLocation = python;
                }
                catch (Exception e) {
                    this.reportError(out, "Failed to configure .py script execution: {}", e.toString());
                }
                break;
            }
            case "command": {
                this.commands.add(value);
                try {
                    ScriptConfig.CommandConfig commandConfig = (ScriptConfig.CommandConfig)GSON.fromJson(value, ScriptConfig.CommandConfig.class);
                    this.scriptConfig.configureSubprocessFileType(commandConfig);
                    this.reportInfo(out, "Configured script execution for \"{}\"", commandConfig);
                }
                catch (Exception e) {
                    this.reportError(out, "Failed to configure script execution: {}", e.toString());
                }
                break;
            }
            case "escape_command_double_quotes": {
                boolean isEnabled = Boolean.valueOf(value);
                this.scriptConfig.setEscapeCommandDoubleQuotes(isEnabled);
                this.reportInfo(out, "Setting escape_command_double_quotes to {}", isEnabled);
                break;
            }
            case "command_path": {
                List<FilePattern> commandPath = Arrays.stream(value.split(Pattern.quote(File.pathSeparator), -1)).map(FilePattern::of).toList();
                this.scriptConfig.setCommandPath(commandPath);
                this.reportInfo(out, "Setting command_path to {}", commandPath);
                break;
            }
            case "pyjinn_import_path": {
                List<FilePattern> pyjinnImportPath = Arrays.stream(value.split(Pattern.quote(File.pathSeparator), -1)).map(FilePattern::of).toList();
                this.scriptConfig.setPyjinnImportPath(pyjinnImportPath);
                this.reportInfo(out, "Setting pyjinn_import_path to {}", pyjinnImportPath);
                break;
            }
            case "max_commands_per_cycle": {
                try {
                    int numCommands = Integer.valueOf(value);
                    if (numCommands < 1) {
                        numCommands = 1;
                    }
                    this.maxCommandsPerCycle = numCommands;
                    this.reportInfo(out, "Setting max_commands_per_cycle to {}", this.maxCommandsPerCycle);
                }
                catch (NumberFormatException e) {
                    this.reportError(out, "Unable to parse max_commands_per_cycle as integer: {}", value);
                }
                break;
            }
            case "command_cycle_deadline_usecs": {
                try {
                    int deadline = Integer.valueOf(value);
                    if (deadline < 1) {
                        deadline = 1;
                    }
                    this.commandCycleDeadlineUsecs = deadline;
                    this.reportInfo(out, "Setting command_cycle_deadline_usecs to {}", this.commandCycleDeadlineUsecs);
                }
                catch (NumberFormatException e) {
                    this.reportError(out, "Unable to parse command_cycle_deadline_usecs as integer: {}", value);
                }
                break;
            }
            case "ticks_per_cycle": {
                try {
                    int ticks = Integer.valueOf(value);
                    if (ticks < 1) {
                        ticks = 1;
                    }
                    this.ticksPerCycle = ticks;
                    this.reportInfo(out, "Setting ticks_per_cycle to {}", this.ticksPerCycle);
                }
                catch (NumberFormatException e) {
                    this.reportError(out, "Unable to parse ticks_per_cycle as integer: {}", value);
                }
                break;
            }
            case "incremental_command_suggestions": {
                this.incrementalCommandSuggestions = Boolean.valueOf(value);
                this.reportInfo(out, "Setting minescript_incremental_command_suggestions to {}", this.incrementalCommandSuggestions);
                break;
            }
            case "debug_output": {
                this.debugOutput = Boolean.valueOf(value);
                this.reportInfo(out, "Setting debug_output to {}", this.debugOutput);
                break;
            }
            case "stderr_chat_ignore_pattern": {
                this.stderrChatIgnorePattern = Pattern.compile(value);
                this.reportInfo(out, "Setting stderr_chat_ignore_pattern to {}", value);
                break;
            }
            case "minescript_on_chat_received_event": {
                boolean enable;
                this.minescriptOnChatReceivedEvent = enable = Boolean.valueOf(value).booleanValue();
                this.reportInfo(out, "Minescript execution on client chat events {}.", enable ? "enabled" : "disabled");
                if (!enable) break;
                this.reportInfo(out, "e.g. add command to command block: [execute as Player run tell Player \\help]", new Object[0]);
                break;
            }
            case "secondary_enter_key_code": {
                try {
                    this.secondaryEnterKeyCode = Integer.valueOf(value);
                    this.reportInfo(out, "Setting secondary_enter_key_code to {}", this.secondaryEnterKeyCode);
                }
                catch (NumberFormatException e) {
                    this.reportError(out, "Unable to parse secondary_enter_key_code as integer: {}", value);
                }
                break;
            }
            case "report_job_success_threshold_millis": {
                try {
                    this.reportJobSuccessThresholdMillis = Integer.valueOf(value);
                    this.reportInfo(out, "Setting report_job_success_threshold_millis to {}", this.reportJobSuccessThresholdMillis);
                }
                catch (NumberFormatException e) {
                    this.reportError(out, "Unable to parse report_job_success_threshold_millis as integer: {}", value);
                }
                break;
            }
            default: {
                Matcher match = CONFIG_AUTORUN_RE.matcher(name);
                if (match.matches()) {
                    Message command = (value = value.strip()).startsWith("/") ? Message.createMinecraftCommand(value.substring(1)) : (value.startsWith("\\") ? Message.createMinescriptCommand(value.substring(1)) : Message.createMinescriptCommand(value));
                    String worldName = match.group(1);
                    Map<String, List<Message>> map = this.autorunCommands;
                    synchronized (map) {
                        List commandList = this.autorunCommands.computeIfAbsent(worldName, k -> new ArrayList());
                        commandList.add(command);
                    }
                    this.reportInfo(out, "Added autorun command `{}` for `{}`", command, worldName);
                    break;
                }
                this.reportError(out, "Unrecognized config var: {}", name);
            }
        }
    }

    private void reportInfo(Consumer<Status> out, String messagePattern, Object ... arguments) {
        out.accept(new Status(true, ParameterizedMessage.format((String)messagePattern, (Object[])arguments)));
    }

    public void reportError(Consumer<Status> out, String messagePattern, Object ... arguments) {
        out.accept(new Status(false, ParameterizedMessage.format((String)messagePattern, (Object[])arguments)));
    }

    public record Status(boolean success, String message) {
    }
}

