/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common;

import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Predicate;
import net.minescript.common.JobControl;
import net.minescript.common.ScriptValue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class EventListener
implements JobControl.Operation {
    private static final Logger LOGGER = LogManager.getLogger();
    private final JobControl job;
    private final String name;
    private OptionalLong funcCallId = OptionalLong.empty();
    private State state = State.IDLE;
    private boolean suspended = false;
    private Runnable doneCallback;
    private Optional<Predicate<Object>> filter = Optional.empty();

    public EventListener(JobControl job, String eventName, Runnable doneCallback) {
        this.job = job;
        this.name = eventName + "_listener";
        this.doneCallback = doneCallback;
    }

    public void setFilter(Predicate<Object> filter) {
        this.filter = Optional.of(filter);
    }

    public boolean applies(Object event) {
        if (this.filter.isPresent()) {
            return this.filter.get().test(event);
        }
        return true;
    }

    int jobId() {
        return this.job.jobId();
    }

    JobControl job() {
        return this.job;
    }

    @Override
    public String name() {
        return this.name;
    }

    public synchronized void start(long funcCallId) {
        if (this.state != State.CANCELLED) {
            this.funcCallId = OptionalLong.of(funcCallId);
            this.state = State.ACTIVE;
        }
    }

    public synchronized boolean isActive() {
        return !this.suspended && this.state == State.ACTIVE;
    }

    @Override
    public synchronized void suspend() {
        this.suspended = true;
    }

    @Override
    public boolean resumeAndCheckDone() {
        if (this.state == State.CANCELLED) {
            return true;
        }
        this.suspended = false;
        return false;
    }

    @Override
    public synchronized void cancel() {
        LOGGER.info("Cancelling EventListener `{}` for job {} func {}", (Object)this.name(), (Object)this.jobId(), (Object)this.funcCallId);
        this.state = State.CANCELLED;
        this.funcCallId = OptionalLong.empty();
        this.doneCallback.run();
    }

    public synchronized boolean respond(ScriptValue value) {
        if (this.funcCallId.isPresent()) {
            return this.job.respond(this.funcCallId.getAsLong(), value, false);
        }
        return false;
    }

    public static enum State {
        IDLE,
        ACTIVE,
        CANCELLED;

    }
}

