/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common;

import net.minescript.common.SystemMessageQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.pyjinn.interpreter.Script;

class ScriptExceptionHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    ScriptExceptionHandler() {
    }

    public static void reportException(SystemMessageQueue systemMessageQueue, Throwable e) {
        systemMessageQueue.logUserError(ScriptExceptionHandler.prettyPrintScriptException(e, true), new Object[0]);
        LOGGER.error("Caught script exception:", e);
    }

    private static String prettyPrintScriptException(Throwable e, boolean toplevelException) {
        StringBuilder out = new StringBuilder();
        if (toplevelException) {
            out.append("Traceback (most recent call last):\n");
        }
        StackTraceElement[] frames = e.getStackTrace();
        for (int i = frames.length - 1; i >= 0; --i) {
            StackTraceElement frame = frames[i];
            String filename = frame.getFileName();
            if (filename == null || !filename.toLowerCase().endsWith(".py") && !filename.toLowerCase().endsWith(".pyj")) continue;
            out.append("  File \"%s\", line %d\n".formatted(filename, frame.getLineNumber()));
        }
        Throwable cause = e.getCause();
        if (cause == null) {
            if (e instanceof Script.InterpreterException) {
                Script.InterpreterException interpreterException = (Script.InterpreterException)e;
                out.append(interpreterException.getShortMessage());
            } else {
                out.append(e.toString());
            }
            out.append("\n");
        } else {
            out.append(ScriptExceptionHandler.prettyPrintScriptException(cause, false));
        }
        return out.toString();
    }
}

