/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.neoforge;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minescript.common.Minescript;
import net.minescript.neoforge.Constants;
import net.minescript.neoforge.NeoForgePlatform;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MinescriptNeoForgeClientMod {
    private static final Logger LOGGER = LogManager.getLogger();

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onKeyboardKeyPressedEvent(ScreenEvent.KeyPressed.Pre event) {
            if (Minescript.onKeyboardKeyPressed(event.getScreen(), event.getKeyCode())) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onKeyInputEvent(InputEvent.Key event) {
            int key = event.getKey();
            int action = event.getAction();
            Screen screen = Minecraft.getInstance().screen;
            if (screen == null) {
                Minescript.onKeyInput(key);
            } else if (Minescript.config == null || key != Minescript.ENTER_KEY && key != Minescript.config.secondaryEnterKeyCode() || action != Constants.KEY_ACTION_DOWN || Minescript.onKeyboardKeyPressed(screen, key)) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onChunkLoadEvent(ChunkEvent.Load event) {
            if (event.getLevel() instanceof ClientLevel) {
                Minescript.onChunkLoad(event.getLevel(), event.getChunk());
            }
        }

        @SubscribeEvent
        public static void onChunkUnloadEvent(ChunkEvent.Unload event) {
            if (event.getLevel() instanceof ClientLevel) {
                Minescript.onChunkUnload(event.getLevel(), event.getChunk());
            }
        }

        @SubscribeEvent
        public static void onWorldTick(LevelTickEvent.Pre event) {
            if (event.getLevel().isClientSide()) {
                Minescript.onClientWorldTick();
            }
        }
    }

    @EventBusSubscriber(modid="minescript", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("(minescript) Minescript mod starting...");
            Minescript.init(new NeoForgePlatform());
        }
    }
}

