/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class CommandSyntax {
    public static String quoteString(String value) {
        return CommandSyntax.quoteString(value, false);
    }

    public static String quoteString(String value, boolean alwaysQuote) {
        if (value.isEmpty()) {
            return "\"\"";
        }
        long numWhitespace = value.chars().filter(ch -> ch == 32 || ch == 10).count();
        long numBackslashes = value.chars().filter(ch -> ch == 92).count();
        long numSingleQuotes = value.chars().filter(ch -> ch == 39).count();
        long numDoubleQuotes = value.chars().filter(ch -> ch == 34).count();
        if (numWhitespace == 0L && numBackslashes == 0L && numSingleQuotes == 0L && numDoubleQuotes == 0L) {
            if (alwaysQuote) {
                return "\"" + value + "\"";
            }
            return value;
        }
        StringBuilder buffer = new StringBuilder();
        if (numDoubleQuotes > numSingleQuotes) {
            buffer.append('\'');
            buffer.append(value.replace("\\", "\\\\").replace("\n", "\\n").replace("'", "\\'"));
            buffer.append('\'');
        } else {
            buffer.append('\"');
            buffer.append(value.replace("\\", "\\\\").replace("\n", "\\n").replace("\"", "\\\""));
            buffer.append('\"');
        }
        return buffer.toString();
    }

    public static String quoteCommand(String[] command) {
        StringBuilder buffer = new StringBuilder();
        for (String value : command) {
            if (buffer.length() == 0) {
                buffer.append(value);
                continue;
            }
            buffer.append(' ');
            buffer.append(CommandSyntax.quoteString(value));
        }
        return buffer.toString();
    }

    private static String consumeStringBuilder(StringBuilder builder) {
        String s = builder.toString();
        builder.setLength(0);
        return s;
    }

    public static List<Token> parseCommand(String command) {
        command = (String)command + " ";
        ArrayList<Token> args = new ArrayList<Token>();
        ParseState state = ParseState.START;
        StringBuilder argBuilder = new StringBuilder();
        StringBuilder literalArgBuilder = new StringBuilder();
        char prevCh = '\u0000';
        for (int i = 0; i < ((String)command).length(); ++i) {
            char ch = ((String)command).charAt(i);
            block0 : switch (state.ordinal()) {
                case 0: {
                    switch (ch) {
                        case '\'': {
                            state = ParseState.INSIDE_SINGLE_QUOTES;
                            break;
                        }
                        case '\"': {
                            state = ParseState.INSIDE_DOUBLE_QUOTES;
                            break;
                        }
                        case ' ': {
                            state = ParseState.SPACES_OUTSIDE_QUOTES;
                            break;
                        }
                        default: {
                            state = ParseState.WORD_OUTSIDE_QUOTES;
                            argBuilder.append(ch);
                        }
                    }
                    literalArgBuilder.append(ch);
                    break;
                }
                case 1: {
                    switch (ch) {
                        case '\'': {
                            if (prevCh == '\\') {
                                argBuilder.setLength(argBuilder.length() - 1);
                                argBuilder.append(ch);
                            } else {
                                state = ParseState.INSIDE_SINGLE_QUOTES;
                            }
                            literalArgBuilder.append(ch);
                            break block0;
                        }
                        case '\"': {
                            if (prevCh == '\\') {
                                argBuilder.setLength(argBuilder.length() - 1);
                                argBuilder.append(ch);
                            } else {
                                state = ParseState.INSIDE_DOUBLE_QUOTES;
                            }
                            literalArgBuilder.append(ch);
                            break block0;
                        }
                        case ' ': {
                            String arg = CommandSyntax.consumeStringBuilder(argBuilder);
                            String literalArg = CommandSyntax.consumeStringBuilder(literalArgBuilder);
                            if (literalArg.equals("&&")) {
                                args.add(Token.and());
                            } else if (literalArg.equals("||")) {
                                args.add(Token.or());
                            } else if (literalArg.endsWith(";")) {
                                String argPrefix = arg.substring(0, arg.length() - 1);
                                if (!argPrefix.isEmpty()) {
                                    args.add(Token.string(argPrefix));
                                }
                                args.add(Token.semicolon());
                            } else if (literalArg.startsWith(">")) {
                                args.add(Token.redirectStdout());
                                argSuffix = arg.substring(1);
                                if (!argSuffix.isEmpty()) {
                                    args.add(Token.string(argSuffix));
                                }
                            } else if (literalArg.startsWith("2>")) {
                                args.add(Token.redirectStderr());
                                argSuffix = arg.substring(2);
                                if (!argSuffix.isEmpty()) {
                                    args.add(Token.string(argSuffix));
                                }
                            } else {
                                args.add(Token.string(arg));
                            }
                            state = ParseState.SPACES_OUTSIDE_QUOTES;
                            break block0;
                        }
                    }
                    argBuilder.append(ch);
                    literalArgBuilder.append(ch);
                    break;
                }
                case 2: {
                    switch (ch) {
                        case '\'': {
                            state = ParseState.INSIDE_SINGLE_QUOTES;
                            literalArgBuilder.append(ch);
                            break block0;
                        }
                        case '\"': {
                            state = ParseState.INSIDE_DOUBLE_QUOTES;
                            literalArgBuilder.append(ch);
                            break block0;
                        }
                        case ' ': {
                            break block0;
                        }
                    }
                    argBuilder.append(ch);
                    literalArgBuilder.append(ch);
                    state = ParseState.WORD_OUTSIDE_QUOTES;
                    break;
                }
                case 3: {
                    switch (ch) {
                        case '\'': {
                            if (prevCh == '\\') {
                                argBuilder.setLength(argBuilder.length() - 1);
                                argBuilder.append(ch);
                                break;
                            }
                            state = ParseState.WORD_OUTSIDE_QUOTES;
                            break;
                        }
                        case 'n': {
                            if (prevCh == '\\') {
                                argBuilder.setLength(argBuilder.length() - 1);
                                argBuilder.append('\n');
                                break;
                            }
                        }
                        default: {
                            argBuilder.append(ch);
                        }
                    }
                    literalArgBuilder.append(ch);
                    break;
                }
                case 4: {
                    switch (ch) {
                        case '\"': {
                            if (prevCh == '\\') {
                                argBuilder.setLength(argBuilder.length() - 1);
                                argBuilder.append(ch);
                                break;
                            }
                            state = ParseState.WORD_OUTSIDE_QUOTES;
                            break;
                        }
                        case 'n': {
                            if (prevCh == '\\') {
                                argBuilder.setLength(argBuilder.length() - 1);
                                argBuilder.append('\n');
                                break;
                            }
                        }
                        default: {
                            argBuilder.append(ch);
                        }
                    }
                    literalArgBuilder.append(ch);
                }
            }
            prevCh = ch;
        }
        if (argBuilder.length() > 0) {
            throw new IllegalStateException("Unexpected trailing characters when parsing command `" + ((String)command).substring(0, ((String)command).length() - 1) + "`: `" + argBuilder.toString() + "`");
        }
        return args;
    }

    private static enum ParseState {
        START,
        WORD_OUTSIDE_QUOTES,
        SPACES_OUTSIDE_QUOTES,
        INSIDE_SINGLE_QUOTES,
        INSIDE_DOUBLE_QUOTES;

    }

    public static class Token {
        private static final Token AND_TOKEN = new Token(Type.AND);
        private static final Token OR_TOKEN = new Token(Type.OR);
        private static final Token SEMICOLON_TOKEN = new Token(Type.SEMICOLON);
        private static final Token REDIRECT_STDOUT_TOKEN = new Token(Type.REDIRECT_STDOUT);
        private static final Token REDIRECT_STDERR_TOKEN = new Token(Type.REDIRECT_STDERR);
        private final Optional<String> string;
        private final Type type;

        public static Token string(String string) {
            return new Token(string);
        }

        public static Token and() {
            return AND_TOKEN;
        }

        public static Token or() {
            return OR_TOKEN;
        }

        public static Token semicolon() {
            return SEMICOLON_TOKEN;
        }

        public static Token redirectStdout() {
            return REDIRECT_STDOUT_TOKEN;
        }

        public static Token redirectStderr() {
            return REDIRECT_STDERR_TOKEN;
        }

        public Type type() {
            return this.type;
        }

        public String toString() {
            switch (this.type.ordinal()) {
                case 0: {
                    return this.string.get();
                }
                case 1: {
                    return "&&";
                }
                case 2: {
                    return "||";
                }
                case 3: {
                    return ";";
                }
                case 4: {
                    return ">";
                }
                case 5: {
                    return "2>";
                }
            }
            throw new IllegalStateException("Unsupported Token type: `" + this.type.toString() + "`");
        }

        private Token(String string) {
            this.type = Type.STRING;
            this.string = Optional.of(string);
        }

        private Token(Type type) {
            this.type = type;
            this.string = Optional.empty();
        }

        public static enum Type {
            STRING,
            AND,
            OR,
            SEMICOLON,
            REDIRECT_STDOUT,
            REDIRECT_STDERR;

        }
    }
}

