/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minescript.common.dataclasses.EntityData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityExporter {
    private static final Logger LOGGER = LogManager.getLogger();
    private final double positionInterpolation;
    private final boolean includeNbt;
    private final Set<String> exportedEntityUuids = new HashSet<String>();
    private final Map<String, Entity> entitiesToExport = new HashMap<String, Entity>();

    public EntityExporter(double positionInterpolation, boolean includeNbt) {
        this.positionInterpolation = positionInterpolation;
        this.includeNbt = includeNbt;
    }

    public EntityData[] export(Iterable<? extends Entity> entities) {
        EntityData[] result = this.exportEntities(entities);
        this.clear();
        return result;
    }

    public EntityData export(Entity entity) {
        EntityData result = this.exportEntity(entity);
        this.clear();
        return result;
    }

    private void clear() {
        this.exportedEntityUuids.clear();
        this.entitiesToExport.clear();
    }

    private EntityData[] exportEntities(Iterable<? extends Entity> entities) {
        ArrayList<EntityData> jsonEntities = new ArrayList<EntityData>();
        for (Entity entity : entities) {
            try {
                jsonEntities.add(this.exportEntity(entity));
            }
            catch (DuplicateEntityException e) {
                LOGGER.error("Ignoring duplicate entity while exporting to JSON: {}", (Object)e.getMessage());
            }
        }
        for (Entity entity : this.entitiesToExport.values()) {
            try {
                jsonEntities.add(this.exportEntity(entity));
            }
            catch (DuplicateEntityException e) {
                LOGGER.error("Ignoring duplicate entity while exporting to JSON: {}", (Object)e.getMessage());
            }
        }
        return (EntityData[])jsonEntities.toArray(EntityData[]::new);
    }

    private EntityData exportEntity(Entity entity) {
        String uuid = entity.getUUID().toString();
        if (this.exportedEntityUuids.contains(uuid)) {
            throw new DuplicateEntityException(uuid);
        }
        this.exportedEntityUuids.add(uuid);
        if (this.entitiesToExport.containsKey(uuid)) {
            this.entitiesToExport.remove(uuid);
        }
        Minecraft minecraft = Minecraft.getInstance();
        EntityData entityData = new EntityData();
        entityData.name = entity.getName().getString();
        entityData.type = entity.getType().toString();
        entityData.uuid = uuid;
        entityData.id = entity.getId();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            entityData.health = Float.valueOf(livingEntity.getHealth());
        }
        if (entity == minecraft.player) {
            entityData.local = true;
        }
        Vec3 v = entity.getDeltaMovement();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        entityData.position[0] = x;
        entityData.position[1] = y;
        entityData.position[2] = z;
        double epsilon = 1.0E-4;
        if (this.positionInterpolation > 1.0E-4 && (Math.abs(v.x) > 1.0E-4 || Math.abs(v.y) > 1.0E-4 || Math.abs(v.z) > 1.0E-4)) {
            entityData.lerp_position = new double[]{x + v.x * this.positionInterpolation, y + v.y * this.positionInterpolation, z + v.z * this.positionInterpolation};
        }
        entityData.yaw = entity.getYRot();
        entityData.pitch = entity.getXRot();
        entityData.velocity[0] = v.x;
        entityData.velocity[1] = v.y;
        entityData.velocity[2] = v.z;
        if (!entity.getPassengers().isEmpty()) {
            ArrayList<String> jsonPassengers = new ArrayList<String>();
            for (Entity passenger : entity.getPassengers()) {
                jsonPassengers.add(passenger.getUUID().toString());
            }
            entityData.passengers = (String[])jsonPassengers.toArray(String[]::new);
        }
        if (this.includeNbt) {
            CompoundTag nbt = new CompoundTag();
            entityData.nbt = entity.saveWithoutId(nbt).toString();
        }
        return entityData;
    }

    private static class DuplicateEntityException
    extends RuntimeException {
        public DuplicateEntityException(String message) {
            super(message);
        }
    }
}

