/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common.mappings;

import java.util.Optional;
import net.minescript.common.mappings.NameMappings;
import net.minescript.common.mappings.NoNameMappings;
import net.minescript.common.mappings.ObfuscatedNameMappings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MappingsLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String modLoaderName;
    private final String mcVersion;
    private final boolean isMinecraftClassObfuscated;
    private NameMappings nameMappings;

    public MappingsLoader(String mcVersion, String modLoaderName, boolean isMinecraftClassObfuscated) {
        this.mcVersion = mcVersion;
        this.modLoaderName = modLoaderName;
        this.isMinecraftClassObfuscated = isMinecraftClassObfuscated;
    }

    public void load() throws Exception {
        NameMappings nameMappings;
        if (this.isMinecraftClassObfuscated) {
            long loadStartTime = System.currentTimeMillis();
            Optional<ObfuscatedNameMappings> obfuscatedMappings = ObfuscatedNameMappings.loadFromFiles(this.modLoaderName, this.mcVersion);
            if (obfuscatedMappings.isPresent()) {
                long loadEndTime = System.currentTimeMillis();
                LOGGER.info("Loaded mappings for deobfuscation in {}ms", (Object)(loadEndTime - loadStartTime));
                nameMappings = obfuscatedMappings.get();
            } else {
                LOGGER.warn("Unable to load mappings for runtime that's not using the official mappings");
                nameMappings = new NoNameMappings();
            }
        } else {
            LOGGER.info("No mappings needed for runtime that's using the official mappings");
            nameMappings = new NoNameMappings();
        }
        this.nameMappings = nameMappings;
    }

    public NameMappings get() {
        return this.nameMappings;
    }
}

