/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common;

import java.util.Optional;
import java.util.Queue;
import net.minescript.common.JobState;
import net.minescript.common.Message;
import net.minescript.common.ScriptConfig;
import net.minescript.common.ScriptValue;
import org.apache.logging.log4j.message.ParameterizedMessage;

public interface JobControl {
    public int jobId();

    public Optional<Integer> parentJobId();

    public ScriptConfig.BoundCommand boundCommand();

    public JobState state();

    public String jobSummary();

    public void yield();

    public boolean suspend();

    public boolean resume();

    public void requestKill();

    public Queue<Message> renderQueue();

    public Queue<Message> tickQueue();

    public boolean respond(long var1, ScriptValue var3, boolean var4);

    public boolean raiseException(long var1, Exception var3);

    public void processStdout(String var1);

    public void processStderr(String var1);

    public void addOperation(long var1, Operation var3);

    public boolean cancelOperation(long var1);

    default public void log(String messagePattern, Object ... arguments) {
        String logMessage = arguments.length == 0 ? messagePattern : ParameterizedMessage.format((String)messagePattern, (Object[])arguments);
        this.processStderr(logMessage);
    }

    public void logJobException(Exception var1);

    public static interface Operation {
        public String name();

        public void suspend();

        public boolean resumeAndCheckDone();

        public void cancel();
    }
}

