/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minescript.common.Message;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class SystemMessageQueue {
    private static final Logger LOGGER = LogManager.getLogger();
    private Queue<Message> queue = new ConcurrentLinkedQueue<Message>();

    public void add(Message message) {
        this.queue.add(message);
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public Message poll() {
        return this.queue.poll();
    }

    public void clear() {
        this.queue.clear();
    }

    public void logUserInfo(String messagePattern, Object ... arguments) {
        String logMessage = ParameterizedMessage.format((String)messagePattern, (Object[])arguments);
        LOGGER.info("{}", (Object)logMessage);
        this.queue.add(Message.formatAsJsonColoredText(logMessage, "yellow"));
    }

    public void logUserError(String messagePattern, Object ... arguments) {
        String logMessage = ParameterizedMessage.format((String)messagePattern, (Object[])arguments);
        LOGGER.error("{}", (Object)logMessage);
        this.queue.add(Message.formatAsJsonColoredText(logMessage, "red"));
    }

    public void logException(Exception e) {
        this.logException(e, String.format("Minescript internal error: %s (see logs/latest.log for details; to browse or report issues see https://minescript.net/issues)", e.toString()));
    }

    public void logException(Exception e, String chatMessage) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        this.logUserError(chatMessage, new Object[0]);
        LOGGER.error(sw.toString());
    }
}

