/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common.blocks;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minescript.common.blocks.BlockPositionReader;

public record BlockRegionReader(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, boolean safetyLimit) {
    public static BlockRegionReader withBounds(int x1, int y1, int z1, int x2, int y2, int z2, boolean safetyLimit) {
        int numChunks;
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            throw new IllegalStateException("Unable to read blocks because player is null.");
        }
        ClientLevel level = minecraft.level;
        int xMin = Math.min(x1, x2);
        int yMin = Math.max(Math.min(y1, y2), level.getMinY());
        int zMin = Math.min(z1, z2);
        int xMax = Math.max(x1, x2);
        int yMax = Math.min(Math.max(y1, y2), level.getMaxY());
        int zMax = Math.max(z1, z2);
        if (safetyLimit && (numChunks = ((xMax - xMin) / 16 + 1) * ((zMax - zMin) / 16 + 1)) > 1600) {
            throw new IllegalArgumentException("`blockpack_read_world` exceeded soft limit of 1600 chunks (region covers " + numChunks + " chunks; override this safety check by passing `no_limit` to `copy` command or `safety_limit=False` to `blockpack_read_world` function).");
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = xMin; x <= xMax; x += 16) {
            for (int z = zMin; z <= zMax; z += 16) {
                String block = BlockPositionReader.getBlockStateString((Level)level, (BlockPos)pos.set(x, 0, z));
                if (block != null && !block.equals("minecraft:void_air")) continue;
                throw new IllegalStateException("Not all chunks are loaded within the requested `copy` volume.");
            }
        }
        return new BlockRegionReader(xMin, yMin, zMin, xMax, yMax, zMax, safetyLimit);
    }

    public void readBlocks(BlockConsumer blockConsumer) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int y = this.yMin; y <= this.yMax; ++y) {
            for (int z = this.zMin; z <= this.zMax; ++z) {
                for (int x = this.xMin; x <= this.xMax; ++x) {
                    BlockState blockState = level.getBlockState((BlockPos)pos.set(x, y, z));
                    if (blockState.isAir()) {
                        blockConsumer.setAir(x, y, z);
                        continue;
                    }
                    String block = BlockPositionReader.blockStateToString(blockState);
                    if (block != null) {
                        blockConsumer.setblock(x, y, z, block);
                        continue;
                    }
                    blockConsumer.reportBlockError(x, y, z, "Unexpected BlockState format at (%d, %d, %d): %s".formatted(x, y, z, blockState.toString()));
                }
            }
        }
    }

    public static interface BlockConsumer {
        public void setblock(int var1, int var2, int var3, String var4);

        public void setAir(int var1, int var2, int var3);

        public void reportBlockError(int var1, int var2, int var3, String var4);
    }
}

