/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common.mappings;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minescript.common.mappings.NameMappings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ObfuscatedNameMappings
implements NameMappings {
    private static final Logger LOGGER = LogManager.getLogger();
    private final BiMap<String, String> officialToObfuscatedClassMap = HashBiMap.create();
    private final Map<ClassMemberKey, String> officialFieldMap = new HashMap<ClassMemberKey, String>();
    private final HashMultimap<ClassMemberKey, MethodSignature> obficialMethodNameToObfuscatedSigMethodMap = HashMultimap.create();
    private final BiMap<String, String> obfuscatedToFabricClassMap = HashBiMap.create();
    private final BiMap<String, String> fabricToObfuscatedClassMap = this.obfuscatedToFabricClassMap.inverse();
    private final BiMap<String, String> obfuscatedToOfficialClassMap = this.officialToObfuscatedClassMap.inverse();
    private final Map<ClassMemberKey, String> fabricFieldMap = new ConcurrentHashMap<ClassMemberKey, String>();
    private final HashMultimap<ObfuscatedMethodKey, String> fabricMethodMap = HashMultimap.create();
    private final Map<String, String> officialToFabricClassCache = new ConcurrentHashMap<String, String>();
    private final Map<String, String> fabricToOfficialClassCache = new ConcurrentHashMap<String, String>();
    private final Map<ClassMemberKey, String> runtimeFieldCache = new ConcurrentHashMap<ClassMemberKey, String>();
    private final Map<ClassMemberKey, ImmutableSet<String>> runtimeMethodCache = new ConcurrentHashMap<ClassMemberKey, ImmutableSet<String>>();
    private static boolean debugLogging = false;
    private static final Pattern OFFICIAL_MAPPINGS_CLASS_RE = Pattern.compile("^([^ ]+) -> ([a-z0-9A-Z_.$]+):$");
    private static final Pattern OFFICIAL_MAPPINGS_MEMBER_RE = Pattern.compile(" ([a-z0-9A-Z_$]+)(\\([^\\)]*\\))? -> ([a-z0-9A-Z_$]+)$");
    private static final Pattern FABRIC_MAPPINGS_CLASS_RE = Pattern.compile("^CLASS\t([a-z0-9A-Z_/$]+)\t([a-z0-9A-Z_/$]+)$");
    private static final Pattern FABRIC_MAPPINGS_FIELD_RE = Pattern.compile("^FIELD\t([a-z0-9A-Z_/$]+)\t[^\t]+\t([^\t]+)\t([^\t]+)$");
    private static final Pattern FABRIC_MAPPINGS_METHOD_RE = Pattern.compile("^METHOD\t([a-z0-9A-Z_/$]+)\t\\(([^)]*)\\)[^\t]+\t([^\t]+)\t([^\t]+)$");

    private ObfuscatedNameMappings() {
    }

    @Override
    public String getRuntimeClassName(String prettyClassName) {
        return this.officialToFabricClassCache.computeIfAbsent(prettyClassName, this::computeRuntimeClassName);
    }

    private String computeRuntimeClassName(String prettyClassName) {
        String obfuscatedName = (String)this.officialToObfuscatedClassMap.get((Object)prettyClassName);
        if (obfuscatedName == null) {
            return prettyClassName;
        }
        String fabricName = (String)this.obfuscatedToFabricClassMap.get((Object)obfuscatedName);
        if (fabricName == null) {
            return prettyClassName;
        }
        LOGGER.info("Mapped official class name '{}' to Fabric name '{}'", (Object)prettyClassName, (Object)fabricName);
        return fabricName;
    }

    @Override
    public String getPrettyClassName(String runtimeClassName) {
        return this.fabricToOfficialClassCache.computeIfAbsent(runtimeClassName, this::computePrettyClassName);
    }

    private String computePrettyClassName(String runtimeClassName) {
        String obfuscatedName = (String)this.fabricToObfuscatedClassMap.get((Object)runtimeClassName);
        if (obfuscatedName == null) {
            return runtimeClassName;
        }
        String officialName = (String)this.obfuscatedToOfficialClassMap.get((Object)obfuscatedName);
        if (officialName == null) {
            return runtimeClassName;
        }
        LOGGER.info("Mapped Fabric class name '{}' to official name '{}'", (Object)runtimeClassName, (Object)officialName);
        return officialName;
    }

    @Override
    public String getRuntimeFieldName(Class<?> clazz, String prettyFieldName) {
        ClassMemberKey cacheKey = new ClassMemberKey(clazz.getName(), prettyFieldName);
        return this.runtimeFieldCache.computeIfAbsent(cacheKey, ignoreKey -> {
            String fabricFieldName;
            Optional<String> optFabricFieldName = this.getFabricFieldNameUncached(clazz, prettyFieldName, "");
            if (optFabricFieldName.isEmpty()) {
                fabricFieldName = prettyFieldName;
                LOGGER.info("No mapping for field name '{}/{}.{}', falling back to '{}'", this.obfuscatedToOfficialClassMap.getOrDefault(this.fabricToObfuscatedClassMap.get((Object)clazz.getName()), (Object)"?"), (Object)clazz.getName(), (Object)prettyFieldName, (Object)fabricFieldName);
            } else {
                fabricFieldName = optFabricFieldName.get();
                LOGGER.info("Mapped Fabric.official field name '{}/{}.{}' to '{}'", this.obfuscatedToOfficialClassMap.getOrDefault(this.fabricToObfuscatedClassMap.get((Object)clazz.getName()), (Object)"?"), (Object)clazz.getName(), (Object)prettyFieldName, (Object)fabricFieldName);
            }
            return fabricFieldName;
        });
    }

    @Override
    public Set<String> getPrettyFieldNames(Class<?> clazz) {
        HashSet<String> fieldNames = new HashSet<String>();
        this.getPrettyFieldNamesRecurse(clazz, fieldNames);
        return fieldNames;
    }

    private void getPrettyFieldNamesRecurse(Class<?> clazz, HashSet<String> fieldNames) {
        String obfuscatedClassName = (String)this.fabricToObfuscatedClassMap.get((Object)clazz.getName());
        if (obfuscatedClassName == null) {
            Arrays.stream(clazz.getFields()).map(Field::getName).forEach(fieldNames::add);
            return;
        }
        this.officialFieldMap.keySet().stream().filter(key -> key.className().equals(obfuscatedClassName)).map(key -> key.memberName()).forEach(fieldNames::add);
        if (clazz.getSuperclass() != null) {
            this.getPrettyFieldNamesRecurse(clazz.getSuperclass(), fieldNames);
        }
        Arrays.stream(clazz.getInterfaces()).forEach(i -> this.getPrettyFieldNamesRecurse((Class<?>)i, fieldNames));
    }

    @Override
    public Set<String> getRuntimeMethodNames(Class<?> clazz, String prettyMethodName) {
        ClassMemberKey cacheKey = new ClassMemberKey(clazz.getName(), prettyMethodName);
        return (Set)this.runtimeMethodCache.computeIfAbsent(cacheKey, ignoreKey -> {
            Set<String> fabricMethodNames = this.getFabricMethodNamesUncached(clazz, prettyMethodName, "");
            if (fabricMethodNames.isEmpty()) {
                fabricMethodNames = Set.of(prettyMethodName);
                LOGGER.info("No mapping for method name '{}/{}.{}', falling back to {}", this.obfuscatedToOfficialClassMap.getOrDefault(this.fabricToObfuscatedClassMap.get((Object)clazz.getName()), (Object)"?"), (Object)clazz.getName(), (Object)prettyMethodName, fabricMethodNames);
            } else {
                LOGGER.info("Mapped method name '{}/{}.{}' to {}", this.obfuscatedToOfficialClassMap.getOrDefault(this.fabricToObfuscatedClassMap.get((Object)clazz.getName()), (Object)"?"), (Object)clazz.getName(), (Object)prettyMethodName, fabricMethodNames);
            }
            return ImmutableSet.copyOf(fabricMethodNames);
        });
    }

    @Override
    public Set<String> getPrettyMethodNames(Class<?> clazz) {
        HashSet<String> methodNames = new HashSet<String>();
        this.getPrettyMethodNamesRecurse(clazz, methodNames);
        return methodNames;
    }

    private void getPrettyMethodNamesRecurse(Class<?> clazz, HashSet<String> methodNames) {
        String obfuscatedClassName = (String)this.fabricToObfuscatedClassMap.get((Object)clazz.getName());
        if (obfuscatedClassName == null) {
            Arrays.stream(clazz.getMethods()).map(Method::getName).forEach(methodNames::add);
            return;
        }
        this.obficialMethodNameToObfuscatedSigMethodMap.keySet().stream().filter(key -> key.className().equals(obfuscatedClassName)).map(key -> key.memberName()).forEach(methodNames::add);
        if (clazz.getSuperclass() != null) {
            this.getPrettyMethodNamesRecurse(clazz.getSuperclass(), methodNames);
        }
        Arrays.stream(clazz.getInterfaces()).forEach(i -> this.getPrettyMethodNamesRecurse((Class<?>)i, methodNames));
    }

    private Optional<String> getFabricFieldNameUncached(Class<?> clazz, String officialFieldName, String indent) {
        String obfuscatedClassName = (String)this.fabricToObfuscatedClassMap.get((Object)clazz.getName());
        if (obfuscatedClassName == null) {
            return Optional.empty();
        }
        ClassMemberKey officialFieldKey = new ClassMemberKey(obfuscatedClassName, officialFieldName);
        String obfuscatedFieldName = this.officialFieldMap.get(officialFieldKey);
        ClassMemberKey fabricFieldKey = new ClassMemberKey(obfuscatedClassName, obfuscatedFieldName);
        String fabricFieldName = this.fabricFieldMap.get(fabricFieldKey);
        if (fabricFieldName == null) {
            LOGGER.info("{}Could not find mapping in {}/{} for field {}; trying superclass and interfaces...", (Object)indent, this.obfuscatedToOfficialClassMap.getOrDefault(this.fabricToObfuscatedClassMap.get((Object)clazz.getName()), (Object)"?"), (Object)clazz.getName(), (Object)officialFieldName);
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null) {
                LOGGER.info("{}Looking for field {} in superclass {}/{}", (Object)indent, (Object)officialFieldName, this.obfuscatedToOfficialClassMap.getOrDefault(this.fabricToObfuscatedClassMap.get((Object)superclass.getName()), (Object)"?"), (Object)superclass.getName());
                Optional<String> name = this.getFabricFieldNameUncached(superclass, officialFieldName, indent + "  ");
                if (!name.isEmpty()) {
                    return name;
                }
            }
            Class<?>[] interfaces = clazz.getInterfaces();
            LOGGER.info("{}Checking {}/{} for {} interfaces...", (Object)indent, this.obfuscatedToOfficialClassMap.getOrDefault(this.fabricToObfuscatedClassMap.get((Object)clazz.getName()), (Object)"?"), (Object)clazz.getName(), (Object)interfaces.length);
            for (Class<?> iface : interfaces) {
                LOGGER.info("{}Looking for field {} in interface {}/{}", (Object)indent, (Object)officialFieldName, this.obfuscatedToOfficialClassMap.getOrDefault(this.fabricToObfuscatedClassMap.get((Object)iface.getName()), (Object)"?"), (Object)iface.getName());
                Optional<String> name = this.getFabricFieldNameUncached(iface, officialFieldName, indent + "  ");
                if (name.isEmpty()) continue;
                return name;
            }
            return Optional.empty();
        }
        LOGGER.info("{}Found mappings in {}/{} for field {}: {}", (Object)indent, this.obfuscatedToOfficialClassMap.getOrDefault(this.fabricToObfuscatedClassMap.get((Object)clazz.getName()), (Object)"?"), (Object)clazz.getName(), (Object)officialFieldName, (Object)fabricFieldName);
        return Optional.of(fabricFieldName);
    }

    private Set<String> getFabricMethodNamesUncached(Class<?> clazz, String officialMethodName, String indent) {
        String obfuscatedClassName = (String)this.fabricToObfuscatedClassMap.get((Object)clazz.getName());
        if (obfuscatedClassName == null) {
            return Set.of();
        }
        ClassMemberKey obficialMethodKey = new ClassMemberKey(obfuscatedClassName, officialMethodName);
        Set obfuscatedMethodSignatures = this.obficialMethodNameToObfuscatedSigMethodMap.get((Object)obficialMethodKey);
        HashSet<String> fabricMethodNames = new HashSet<String>();
        for (MethodSignature obfuscatedMethodSignature : obfuscatedMethodSignatures) {
            ObfuscatedMethodKey fabricMemberKey = new ObfuscatedMethodKey(obfuscatedClassName, obfuscatedMethodSignature);
            fabricMethodNames.addAll(this.fabricMethodMap.get((Object)fabricMemberKey));
        }
        if (fabricMethodNames.isEmpty()) {
            LOGGER.info("{}Could not find mapping in {}/{} for member {}; trying superclass and interfaces...", (Object)indent, this.obfuscatedToOfficialClassMap.getOrDefault(this.fabricToObfuscatedClassMap.get((Object)clazz.getName()), (Object)"?"), (Object)clazz.getName(), (Object)officialMethodName);
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null) {
                LOGGER.info("{}Looking for member {} in superclass {}/{}", (Object)indent, (Object)officialMethodName, this.obfuscatedToOfficialClassMap.getOrDefault(this.fabricToObfuscatedClassMap.get((Object)superclass.getName()), (Object)"?"), (Object)superclass.getName());
                Set<String> names = this.getFabricMethodNamesUncached(superclass, officialMethodName, indent + "  ");
                if (!names.isEmpty()) {
                    return names;
                }
            }
            Class<?>[] interfaces = clazz.getInterfaces();
            LOGGER.info("{}Checking {}/{} for {} interfaces...", (Object)indent, this.obfuscatedToOfficialClassMap.getOrDefault(this.fabricToObfuscatedClassMap.get((Object)clazz.getName()), (Object)"?"), (Object)clazz.getName(), (Object)interfaces.length);
            for (Class<?> iface : interfaces) {
                LOGGER.info("{}Looking for member {} in interface {}/{}", (Object)indent, (Object)officialMethodName, this.obfuscatedToOfficialClassMap.getOrDefault(this.fabricToObfuscatedClassMap.get((Object)iface.getName()), (Object)"?"), (Object)iface.getName());
                Set<String> names = this.getFabricMethodNamesUncached(iface, officialMethodName, indent + "  ");
                if (names.isEmpty()) continue;
                return names;
            }
            return Set.of();
        }
        LOGGER.info("{}Found mappings in {}/{} for member {}: {}", (Object)indent, this.obfuscatedToOfficialClassMap.getOrDefault(this.fabricToObfuscatedClassMap.get((Object)clazz.getName()), (Object)"?"), (Object)clazz.getName(), (Object)officialMethodName, fabricMethodNames);
        return fabricMethodNames;
    }

    public static void enableDebugLogging(boolean enable) {
        debugLogging = enable;
    }

    public static Optional<ObfuscatedNameMappings> loadFromFiles(String modLoaderName, String mcVersion) throws IOException {
        Path mappingsVersionPath = Paths.get("minescript", "system", "mappings", mcVersion);
        Files.createDirectories(mappingsVersionPath, new FileAttribute[0]);
        Path officialMappingsPath = mappingsVersionPath.resolve("client.txt");
        if (!Files.exists(officialMappingsPath, new LinkOption[0])) {
            LOGGER.warn("Unable to find official mappings at {}", (Object)officialMappingsPath);
            return Optional.empty();
        }
        ObfuscatedNameMappings mappings = new ObfuscatedNameMappings();
        mappings.loadOfficalMappings(officialMappingsPath);
        Path fabricMappingsPath = mappingsVersionPath.resolve(mcVersion + ".tiny");
        if (modLoaderName.equals("Fabric")) {
            if (!Files.exists(fabricMappingsPath, new LinkOption[0])) {
                LOGGER.warn("Unable to find Fabric mappings at {}", (Object)fabricMappingsPath);
                return Optional.empty();
            }
            mappings.loadFabricMappings(fabricMappingsPath);
        }
        return Optional.of(mappings);
    }

    private void loadOfficalMappings(Path officialMappingsPath) throws IOException {
        long startTimeMillis = System.currentTimeMillis();
        HashMultimap obficialMethodNameToObficialSigMethodMap = HashMultimap.create();
        try (BufferedReader reader = new BufferedReader(new FileReader(officialMappingsPath.toFile()));){
            String line;
            Object obfuscatedClassName = null;
            while ((line = reader.readLine()) != null) {
                Matcher match = OFFICIAL_MAPPINGS_CLASS_RE.matcher(line);
                if (match.find()) {
                    String officialClassName = match.group(1);
                    obfuscatedClassName = match.group(2);
                    this.officialToObfuscatedClassMap.put((Object)officialClassName, obfuscatedClassName);
                    if (debugLogging) {
                        LOGGER.info("(debug) Mapped official class name '{}' to obfuscated name '{}'", (Object)officialClassName, obfuscatedClassName);
                    }
                }
                match = OFFICIAL_MAPPINGS_MEMBER_RE.matcher(line);
                if (obfuscatedClassName == null || !match.find()) continue;
                String officialMemberName = match.group(1);
                String methodParams = match.group(2);
                String obfuscatedMemberName = match.group(3);
                if (methodParams == null || methodParams.isEmpty()) {
                    this.officialFieldMap.put(new ClassMemberKey((String)obfuscatedClassName, officialMemberName), obfuscatedMemberName);
                    if (!debugLogging) continue;
                    LOGGER.info("(debug) Mapped class '{}' official field name '{}' to obfuscated name '{}'", obfuscatedClassName, (Object)officialMemberName, (Object)obfuscatedMemberName);
                    continue;
                }
                String methodParamsWithoutParens = methodParams.substring(1, methodParams.length() - 1);
                obficialMethodNameToObficialSigMethodMap.put((Object)new ClassMemberKey((String)obfuscatedClassName, officialMemberName), (Object)new MethodSignature(obfuscatedMemberName, methodParamsWithoutParens));
                if (!debugLogging) continue;
                LOGGER.info("(debug) Mapped class '{}' official method '{}' to obfuscated name '{}' with signature '{}'", obfuscatedClassName, (Object)officialMemberName, (Object)obfuscatedMemberName, (Object)methodParamsWithoutParens);
            }
        }
        long mapSignaturesStartTimeMillis = System.currentTimeMillis();
        for (Map.Entry entry : obficialMethodNameToObficialSigMethodMap.entries()) {
            ClassMemberKey obficialMethodKey = (ClassMemberKey)entry.getKey();
            MethodSignature obficialMethodSig = (MethodSignature)entry.getValue();
            MethodSignature obfuscatedMethodSig = new MethodSignature(obficialMethodSig.methodName, ObfuscatedNameMappings.obfuscateOfficialMethodSignature(arg_0 -> this.officialToObfuscatedClassMap.get(arg_0), obficialMethodSig.signature));
            if (debugLogging) {
                LOGGER.info("(debug) Obfuscated class '{}' method '{}' sig '{}' as '{}'", (Object)obficialMethodKey.className, (Object)obficialMethodKey.memberName, (Object)obficialMethodSig.signature, (Object)obfuscatedMethodSig.signature);
            }
            this.obficialMethodNameToObfuscatedSigMethodMap.put((Object)obficialMethodKey, (Object)obfuscatedMethodSig);
        }
        long mapSignaturesEndTimeMillis = System.currentTimeMillis();
        LOGGER.info("Mapped {} method signatures from official names to obfuscated JNI method format in {}ms", (Object)obficialMethodNameToObficialSigMethodMap.size(), (Object)(mapSignaturesEndTimeMillis - mapSignaturesStartTimeMillis));
        long endTimeMillis = System.currentTimeMillis();
        LOGGER.info("Loaded {} classes, {} fields, and {} methods from official mappings file in {}ms", (Object)this.officialToObfuscatedClassMap.size(), (Object)this.officialFieldMap.size(), (Object)this.obficialMethodNameToObfuscatedSigMethodMap.size(), (Object)(endTimeMillis - startTimeMillis));
    }

    private static String obfuscateOfficialMethodSignature(Function<String, String> toObfuscatedClassName, String officialSignature) {
        if (officialSignature.isEmpty()) {
            return "";
        }
        String[] officialArgs = officialSignature.split(",");
        StringBuilder obfuscatedArgs = new StringBuilder();
        block20: for (String officialArg : officialArgs) {
            while (officialArg.endsWith("[]")) {
                officialArg = officialArg.substring(0, officialArg.length() - 2);
                obfuscatedArgs.append("[");
            }
            switch (officialArg) {
                case "boolean": {
                    obfuscatedArgs.append("Z");
                    continue block20;
                }
                case "byte": {
                    obfuscatedArgs.append("B");
                    continue block20;
                }
                case "char": {
                    obfuscatedArgs.append("C");
                    continue block20;
                }
                case "double": {
                    obfuscatedArgs.append("D");
                    continue block20;
                }
                case "float": {
                    obfuscatedArgs.append("F");
                    continue block20;
                }
                case "int": {
                    obfuscatedArgs.append("I");
                    continue block20;
                }
                case "long": {
                    obfuscatedArgs.append("J");
                    continue block20;
                }
                case "short": {
                    obfuscatedArgs.append("S");
                    continue block20;
                }
                default: {
                    String obfuscatedName = toObfuscatedClassName.apply(officialArg);
                    if (obfuscatedName == null) {
                        obfuscatedName = officialArg;
                    }
                    obfuscatedArgs.append("L").append(obfuscatedName.replace('.', '/')).append(";");
                }
            }
        }
        return obfuscatedArgs.toString();
    }

    private void loadFabricMappings(Path fabricMappingsPath) throws IOException {
        long startTimeMillis = System.currentTimeMillis();
        try (BufferedReader reader = new BufferedReader(new FileReader(fabricMappingsPath.toFile()));){
            String line;
            while ((line = reader.readLine()) != null) {
                String obfuscatedClassName;
                Matcher match = FABRIC_MAPPINGS_CLASS_RE.matcher(line);
                if (match.find()) {
                    obfuscatedClassName = match.group(1).replace('/', '.');
                    String fabricClassName = match.group(2).replace('/', '.');
                    this.obfuscatedToFabricClassMap.put((Object)obfuscatedClassName, (Object)fabricClassName);
                    if (!debugLogging) continue;
                    LOGGER.info("(debug) Mapped obfuscated class name '{}' to Fabric name '{}'", (Object)obfuscatedClassName, (Object)fabricClassName);
                    continue;
                }
                match = FABRIC_MAPPINGS_FIELD_RE.matcher(line);
                if (match.find()) {
                    obfuscatedClassName = match.group(1).replace('/', '.');
                    String obfuscatedMemberName = match.group(2).replace('/', '.');
                    String fabricFieldName = match.group(3);
                    this.fabricFieldMap.put(new ClassMemberKey(obfuscatedClassName, obfuscatedMemberName), fabricFieldName);
                    if (!debugLogging) continue;
                    LOGGER.info("(debug) Mapped obfuscated field name '{}' of class '{}' to Fabric name '{}'", (Object)obfuscatedMemberName, (Object)obfuscatedClassName, (Object)fabricFieldName);
                    continue;
                }
                match = FABRIC_MAPPINGS_METHOD_RE.matcher(line);
                if (!match.find()) continue;
                obfuscatedClassName = match.group(1).replace('/', '.');
                String obfuscatedMethodSignature = match.group(2);
                String obfuscatedMethodName = match.group(3).replace('/', '.');
                String fabricMethodName = match.group(4);
                this.fabricMethodMap.put((Object)new ObfuscatedMethodKey(obfuscatedClassName, new MethodSignature(obfuscatedMethodName, obfuscatedMethodSignature)), (Object)fabricMethodName);
                if (!debugLogging) continue;
                LOGGER.info("(debug) Mapped class '{}' method '{}' with signature '{}' to Fabric name '{}'", (Object)obfuscatedClassName, (Object)obfuscatedMethodName, (Object)obfuscatedMethodSignature, (Object)fabricMethodName);
            }
        }
        long endTimeMillis = System.currentTimeMillis();
        LOGGER.info("Loaded {} classes, {} fields, and {} methods from Fabric mappings file in {}ms", (Object)this.obfuscatedToFabricClassMap.size(), (Object)this.fabricFieldMap.size(), (Object)this.fabricMethodMap.size(), (Object)(endTimeMillis - startTimeMillis));
    }

    private record ClassMemberKey(String className, String memberName) {
    }

    private record MethodSignature(String methodName, String signature) {
    }

    private record ObfuscatedMethodKey(String obfuscatedClassName, MethodSignature obfuscatedMethodSig) {
    }
}

