/*
 * Decompiled with CFR 0.152.
 */
package net.minescript.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.concurrent.TimeUnit;
import net.minescript.common.Config;
import net.minescript.common.ExceptionInfo;
import net.minescript.common.JobControl;
import net.minescript.common.JobState;
import net.minescript.common.ScriptConfig;
import net.minescript.common.ScriptValue;
import net.minescript.common.Task;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SubprocessTask
implements Task {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().serializeNulls().create();
    private final Config config;
    private JobControl jobControl;
    private Process process;
    private BufferedWriter stdinWriter;

    public SubprocessTask(Config config) {
        this.config = config;
    }

    @Override
    public int run(ScriptConfig.BoundCommand command, JobControl jobControl) {
        if (this.jobControl != null) {
            throw new IllegalStateException("SubprocessTask can be run only once: " + String.valueOf(jobControl));
        }
        this.jobControl = jobControl;
        ScriptConfig.ExecutableCommand exec = this.config.scriptConfig().getExecutableCommand(command);
        if (exec == null) {
            jobControl.log("Cannot run \"{}\" because execution is not configured for \"{}\" files.", command.scriptPath(), command.fileExtension());
            return -1;
        }
        try {
            this.process = Runtime.getRuntime().exec(exec.command(), exec.environment());
        }
        catch (IOException e) {
            jobControl.logJobException(e);
            return -2;
        }
        this.stdinWriter = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream()));
        Thread stdoutThread = new Thread(this::processStdout, Thread.currentThread().getName() + "-stdout");
        stdoutThread.start();
        Thread stderrThread = new Thread(this::processStderr, Thread.currentThread().getName() + "-stderr");
        stderrThread.start();
        try {
            while (!this.process.waitFor(100L, TimeUnit.MILLISECONDS)) {
                if (jobControl.state() != JobState.KILLED) continue;
                LOGGER.info("Killing script process for job `{}`", (Object)jobControl);
                this.process.destroy();
                stdoutThread.interrupt();
                stderrThread.interrupt();
                return -5;
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("Task thread interrupted while awaiting subprocess for job `{}`", (Object)jobControl);
        }
        int result = this.process.exitValue();
        LOGGER.info("Script process exited with {} for job `{}`", (Object)result, (Object)jobControl);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStdout() {
        try (BufferedReader stdoutReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));){
            String line;
            while ((line = stdoutReader.readLine()) != null) {
                this.jobControl.yield();
                this.jobControl.processStdout(line);
            }
        }
        catch (IOException e) {
            LOGGER.error("IOException while reading subprocess stdout for job `{}`: {}", (Object)this.jobControl, (Object)e.getMessage());
        }
        finally {
            if (Thread.interrupted()) {
                LOGGER.warn("Thread interrupted while reading subprocess stdout for job `{}`", (Object)this.jobControl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStderr() {
        try (BufferedReader stderrReader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));){
            String line;
            while ((line = stderrReader.readLine()) != null) {
                this.jobControl.yield();
                this.jobControl.log(line, new Object[0]);
            }
        }
        catch (IOException e) {
            LOGGER.error("IOException while reading subprocess stderr for job `{}`: {}", (Object)this.jobControl, (Object)e.getMessage());
        }
        finally {
            if (Thread.interrupted()) {
                LOGGER.warn("Thread interrupted while reading subprocess stderr for job `{}`", (Object)this.jobControl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendResponse(long functionCallId, ScriptValue returnValue, boolean finalReply) {
        if (!this.canRespond()) {
            LOGGER.warn("Subprocess unresponsive to response from funcCallId {} for job {}: {}", (Object)functionCallId, (Object)this.jobControl, returnValue.get());
            return false;
        }
        try {
            JsonObject response = new JsonObject();
            response.addProperty("fcid", (Number)functionCallId);
            response.add("retval", returnValue.toJson());
            if (finalReply) {
                response.addProperty("conn", "close");
            }
            String responseString = GSON.toJson((JsonElement)response);
            SubprocessTask subprocessTask = this;
            synchronized (subprocessTask) {
                this.stdinWriter.write(responseString);
                this.stdinWriter.newLine();
                this.stdinWriter.flush();
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("IOException in SubprocessTask sendResponse for job {}: {}", (Object)this.jobControl, (Object)e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendException(long functionCallId, Exception exception) {
        if (!this.canRespond()) {
            LOGGER.warn("Subprocess unresponsive to exception from funcCallId {} for job {}: {}", (Object)functionCallId, (Object)this.jobControl, (Object)exception);
            return false;
        }
        try {
            JsonObject response = new JsonObject();
            Gson gson = new GsonBuilder().serializeNulls().setPrettyPrinting().create();
            response.addProperty("fcid", (Number)functionCallId);
            response.addProperty("conn", "close");
            JsonElement json = gson.toJsonTree((Object)ExceptionInfo.fromException(exception));
            LOGGER.warn("Translating Java exception as JSON: {}", (Object)gson.toJson(json));
            response.add("except", json);
            String responseString = GSON.toJson((JsonElement)response);
            SubprocessTask subprocessTask = this;
            synchronized (subprocessTask) {
                this.stdinWriter.write(responseString);
                this.stdinWriter.newLine();
                this.stdinWriter.flush();
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("IOException in SubprocessTask sendException for job {}: {}", (Object)this.jobControl, (Object)e.getMessage());
            return false;
        }
    }

    private boolean canRespond() {
        return this.process != null && this.process.isAlive() && this.stdinWriter != null;
    }
}

