/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.enchantmentdisabler.mixson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import me.pajic.enchantmentdisabler.ED;
import me.pajic.enchantmentdisabler.util.ModUtil;
import net.ramixin.mixson.debug.DebugMode;
import net.ramixin.mixson.inline.EventContext;
import net.ramixin.mixson.inline.Mixson;
import net.ramixin.mixson.inline.ResourceReference;

public class ResourceModifications {
    private static final List<String> TRADE_TAGS = List.of("minecraft:on_traded_equipment", "minecraft:tradeable");
    private static final List<String> LOOT_TAGS = List.of("minecraft:on_random_loot", "minecraft:on_mob_spawn_equipment");
    private static final List<String> REMOVE_NON_TREASURE = new ArrayList<String>();
    private static final List<String> ADD_LOOT = new ArrayList<String>();
    private static final List<String> ADD_TABLE = new ArrayList<String>();
    private static final List<String> ADD_TRADE = new ArrayList<String>();
    private static final List<String> REMOVE_LOOT = new ArrayList<String>();
    private static final List<String> REMOVE_TABLE = new ArrayList<String>();
    private static final List<String> REMOVE_TRADE = new ArrayList<String>();
    private static boolean initialized = false;

    public static void init() {
        if (initialized) {
            return;
        }
        if (ED.xplat().isDebug()) {
            Mixson.setDebugMode((DebugMode)DebugMode.EXPORT);
        }
        ED.CONFIG.disabler.disabledEnchantmentsV2.forEach((id, sources) -> {
            String s = id.toString();
            if (ModUtil.anySourceDisabled(sources)) {
                REMOVE_NON_TREASURE.add(s);
                if (!((Boolean)sources.loot.get()).booleanValue()) {
                    REMOVE_LOOT.add(s);
                } else {
                    ADD_LOOT.add(s);
                }
                if (!((Boolean)sources.table.get()).booleanValue()) {
                    REMOVE_TABLE.add(s);
                } else {
                    ADD_TABLE.add(s);
                }
                if (!((Boolean)sources.trade.get()).booleanValue()) {
                    REMOVE_TRADE.add(s);
                } else {
                    ADD_TRADE.add(s);
                }
            }
        });
        Mixson.registerEvent((int)1000, rl -> rl.toString().equals("minecraft:tags/enchantment/non_treasure"), (String)"Modify non-treasure tag", context -> ResourceModifications.runEventOnTag((EventContext<JsonElement>)context, "minecraft:non_treasure", List.of(), REMOVE_NON_TREASURE), (boolean)false, (ResourceReference[])new ResourceReference[0]);
        Mixson.registerEvent((int)1000, rl -> rl.toString().equals("minecraft:tags/enchantment/in_enchanting_table"), (String)"Modify enchanting table tags", context -> ResourceModifications.runEventOnTag((EventContext<JsonElement>)context, "minecraft:in_enchanting_table", ADD_TABLE, REMOVE_TABLE), (boolean)false, (ResourceReference[])new ResourceReference[0]);
        LOOT_TAGS.forEach(s -> Mixson.registerEvent((int)1000, rl -> rl.toString().equals(s.replace(":", ":tags/enchantment/")), (String)"Modify random loot tags", context -> ResourceModifications.runEventOnTag((EventContext<JsonElement>)context, s, ADD_LOOT, REMOVE_LOOT), (boolean)false, (ResourceReference[])new ResourceReference[0]));
        TRADE_TAGS.forEach(s -> Mixson.registerEvent((int)1000, rl -> rl.toString().equals(s.replace(":", ":tags/enchantment/")), (String)"Modify trade tags", context -> ResourceModifications.runEventOnTag((EventContext<JsonElement>)context, s, ADD_TRADE, REMOVE_TRADE), (boolean)false, (ResourceReference[])new ResourceReference[0]));
        int globalMaxLevel = (Integer)ED.CONFIG.maxLevel.globalMaxLevel.get();
        if (globalMaxLevel > 0) {
            Mixson.registerEvent((int)1000, rl -> rl.method_12832().startsWith("enchantment/"), (String)("Set global max level " + globalMaxLevel), context -> ((JsonElement)context.getFile()).getAsJsonObject().addProperty("max_level", (Number)globalMaxLevel), (boolean)false, (ResourceReference[])new ResourceReference[0]);
        }
        ED.CONFIG.maxLevel.maxLevels.forEach((key, value) -> {
            String namespace = key.method_12836();
            String path = key.method_12832();
            Mixson.registerEvent((int)1000, rl -> rl.toString().equals(namespace + ":enchantment/" + path), (String)("Modify max level for enchantment " + String.valueOf(key)), context -> ((JsonElement)context.getFile()).getAsJsonObject().addProperty("max_level", (Number)value), (boolean)false, (ResourceReference[])new ResourceReference[0]);
        });
        initialized = true;
    }

    private static void runEventOnTag(EventContext<JsonElement> context, String tag, List<String> addList, List<String> removeList) {
        context.registerRuntimeEvent(1000, rl -> rl.toString().equals(tag.replace(":", ":tags/enchantment/")), "Modify tag " + tag, context1 -> {
            List values = ((JsonElement)context1.getFile()).getAsJsonObject().getAsJsonArray("values").asList();
            addList.forEach(s -> values.add(new JsonPrimitive(s)));
            values.removeIf(value -> {
                String entry = value.isJsonPrimitive() ? value.getAsString() : value.getAsJsonObject().get("id").getAsString();
                if (entry.startsWith("#")) {
                    ResourceModifications.runEventOnTag((EventContext<JsonElement>)context1, entry.replace("#", ""), List.of(), removeList);
                    return false;
                }
                return removeList.contains(entry);
            });
            JsonArray newValues = new JsonArray();
            values.forEach(arg_0 -> ((JsonArray)newValues).add(arg_0));
            ((JsonElement)context1.getFile()).getAsJsonObject().add("values", (JsonElement)newValues);
        }, false, new ResourceReference[0]);
    }
}

