/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm;

import baguchan.frostrealm.api.recipe.AttachableCrystal;
import baguchan.frostrealm.capability.FrostLivingCapability;
import baguchan.frostrealm.capability.FrostWeatherSavedData;
import baguchan.frostrealm.data.resource.FrostDimensions;
import baguchan.frostrealm.data.resource.registries.AttachableCrystals;
import baguchan.frostrealm.entity.FrostPart;
import baguchan.frostrealm.entity.animal.Seal;
import baguchan.frostrealm.message.ChangeAuroraMessage;
import baguchan.frostrealm.message.ChangeWeatherMessage;
import baguchan.frostrealm.registry.AuroraPowers;
import baguchan.frostrealm.registry.FrostAttachs;
import baguchan.frostrealm.registry.FrostBlocks;
import baguchan.frostrealm.registry.FrostCriterions;
import baguchan.frostrealm.registry.FrostDataCompnents;
import baguchan.frostrealm.registry.FrostItems;
import baguchan.frostrealm.utils.AttackUtils;
import baguchan.frostrealm.utils.aurorapower.AuroraCombatRules;
import baguchan.frostrealm.utils.aurorapower.AuroraPowerUtils;
import baguchan.frostrealm.world.FrostLevelData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.ItemStackedOnOtherEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.SweepAttackEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="frostrealm")
public class CommonEvents {
    @SubscribeEvent
    public static void onStackOther(ItemStackedOnOtherEvent event) {
        Holder crystal;
        ItemStack stack = event.getStackedOnItem();
        ItemStack carriedStack = event.getCarriedItem();
        if (event.getClickAction() == ClickAction.PRIMARY) {
            ServerPlayer serverPlayer;
            Player player;
            Holder optional1;
            if (!stack.has((DataComponentType)FrostDataCompnents.ATTACH_CRYSTAL.get()) && stack.is(FrostItems.COATING_FUR) && (optional1 = AttachableCrystals.getFromIngredient((HolderLookup.Provider)event.getPlayer().registryAccess(), carriedStack)).isPresent() && carriedStack.getCount() == 1) {
                stack.set((DataComponentType)FrostDataCompnents.ATTACH_CRYSTAL.get(), (Object)((Holder)optional1.get()));
                event.getPlayer().playSound(SoundEvents.BUNDLE_INSERT);
                player = event.getPlayer();
                if (player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    FrostCriterions.PUT_CRYSTAL.get().trigger(serverPlayer);
                }
                carriedStack.shrink(1);
                event.getCarriedSlotAccess().set(stack.split(1));
                CommonEvents.broadcastChangesOnContainerMenu(event.getPlayer());
                event.setCanceled(true);
            }
            if (!stack.has((DataComponentType)FrostDataCompnents.ATTACH_CRYSTAL.get()) && (stack.has(DataComponents.WEAPON) || stack.getItem() instanceof ArrowItem) && carriedStack.has((DataComponentType)FrostDataCompnents.ATTACH_CRYSTAL.get()) && carriedStack.is(FrostItems.COATING_FUR)) {
                optional1 = (Holder)carriedStack.get((DataComponentType)FrostDataCompnents.ATTACH_CRYSTAL.get());
                stack.set((DataComponentType)FrostDataCompnents.ATTACH_CRYSTAL.get(), (Object)optional1);
                event.getPlayer().playSound(SoundEvents.HONEYCOMB_WAX_ON);
                player = event.getPlayer();
                if (player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    FrostCriterions.PUT_CRYSTAL.get().trigger(serverPlayer);
                }
                carriedStack.shrink(1);
                event.getCarriedSlotAccess().set(stack.copyAndClear());
                CommonEvents.broadcastChangesOnContainerMenu(event.getPlayer());
                event.setCanceled(true);
            }
        }
        if (event.getClickAction() == ClickAction.SECONDARY && carriedStack.isEmpty() && stack.has((DataComponentType)FrostDataCompnents.ATTACH_CRYSTAL.get()) && stack.is(FrostItems.COATING_FUR) && (crystal = (Holder)stack.copy().get((DataComponentType)FrostDataCompnents.ATTACH_CRYSTAL.get())) != null) {
            event.getPlayer().playSound(SoundEvents.HONEYCOMB_WAX_ON);
            ItemStack stack1 = new ItemStack((ItemLike)((AttachableCrystal)crystal.value()).getItem().value(), stack.getCount());
            if (!event.getPlayer().addItem(stack1)) {
                event.getPlayer().drop(stack1, true);
            }
            stack.remove((DataComponentType)FrostDataCompnents.ATTACH_CRYSTAL.get());
            event.getCarriedSlotAccess().set(stack.copyAndClear());
            CommonEvents.broadcastChangesOnContainerMenu(event.getPlayer());
            event.setCanceled(true);
        }
    }

    private static void broadcastChangesOnContainerMenu(Player p_376384_) {
        AbstractContainerMenu abstractcontainermenu = p_376384_.containerMenu;
        if (abstractcontainermenu != null) {
            abstractcontainermenu.slotsChanged((Container)p_376384_.getInventory());
        }
    }

    @SubscribeEvent
    public static void onSweep(SweepAttackEvent event) {
        Player player = event.getEntity();
        Entity target = event.getTarget();
        ItemStack itemstack = player.getWeaponItem();
        AttackUtils.sickleAttack(player, target, itemstack);
        AttackUtils.spearAttack(player, target, itemstack);
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() != null && event.getEntity().level() instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)event.getEntity().level();
            MinecraftServer server = world.getServer();
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                for (ServerLevel serverworld : server.getAllLevels()) {
                    if (serverworld.dimension() != FrostDimensions.FROSTREALM_LEVEL) continue;
                    FrostWeatherSavedData cap = FrostWeatherSavedData.get((Level)serverworld);
                    ChangeWeatherMessage message = new ChangeWeatherMessage(cap.getFrostWeather());
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
                    ChangeAuroraMessage message2 = new ChangeAuroraMessage(cap.getAuroraLevel());
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)message2, (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        Entity entity;
        if (event.getEntity().isMultipartEntity()) {
            for (PartEntity partEntity : event.getEntity().getParts()) {
                if (!(partEntity instanceof FrostPart)) continue;
                FrostPart part = (FrostPart)partEntity;
                part.snapTo(event.getEntity().position());
            }
        }
        if ((entity = event.getEntity()) instanceof PolarBear) {
            PolarBear bear = (PolarBear)entity;
            bear.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)bear, Seal.class, 45, true, true, null));
        }
    }

    @SubscribeEvent
    public static void onLevelUpdate(LevelTickEvent.Pre event) {
        if (FrostWeatherSavedData.get(event.getLevel()) != null) {
            FrostWeatherSavedData.get(event.getLevel()).tick(event.getLevel());
        }
    }

    @SubscribeEvent
    public static void onDimensionChangeEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getEntity() != null && event.getEntity().level() instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)event.getEntity().level();
            MinecraftServer server = world.getServer();
            for (ServerLevel serverworld : server.getAllLevels()) {
                if (serverworld.dimension() != FrostDimensions.FROSTREALM_LEVEL) continue;
                FrostWeatherSavedData cap = FrostWeatherSavedData.get((Level)serverworld);
                ChangeWeatherMessage message = new ChangeWeatherMessage(cap.getFrostWeather());
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onUpdate(EntityTickEvent.Post event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            FrostLivingCapability capability = (FrostLivingCapability)livingEntity.getData(FrostAttachs.FROST_LIVING);
            capability.tick(livingEntity);
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        ServerLevel level;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (level = (ServerLevel)levelAccessor).dimension().location().equals((Object)FrostDimensions.FROSTREALM_LEVEL.location())) {
            FrostLevelData levelData = new FrostLevelData(level.getServer().getWorldData(), level.getServer().getWorldData().overworldData());
            level.serverLevelData = levelData;
            level.levelData = levelData;
        }
    }

    public static void makeParticles(Level p_51252_, BlockPos p_51253_) {
        p_51252_.levelEvent(1501, p_51253_, 0);
    }

    public static boolean canPlaceSnowLayer(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        BlockState stateDown = world.getBlockState(pos.below());
        return world.isEmptyBlock(pos.above()) && world.isEmptyBlock(pos) && Block.canSupportRigidBlock((BlockGetter)world, (BlockPos)pos.below()) && !(stateDown.getBlock() instanceof SnowLayerBlock) && !(state.getBlock() instanceof SnowLayerBlock) && Blocks.SNOW.defaultBlockState().canSurvive((LevelReader)world, pos);
    }

    @SubscribeEvent
    public static void blockToolInteractions(BlockEvent.BlockToolModificationEvent event) {
        ItemAbility action = event.getItemAbility();
        BlockState state = event.getState();
        UseOnContext context = event.getContext();
        if (!event.isSimulated()) {
            if (action == ItemAbilities.AXE_STRIP) {
                if (state.is((Block)FrostBlocks.FROSTROOT_LOG.get())) {
                    event.setFinalState(((RotatedPillarBlock)FrostBlocks.STRIPPED_FROSTROOT_LOG.get()).withPropertiesOf(state));
                }
                if (state.is((Block)FrostBlocks.FROSTBITE_LOG.get())) {
                    event.setFinalState(((RotatedPillarBlock)FrostBlocks.STRIPPED_FROSTBITE_LOG.get()).withPropertiesOf(state));
                }
            }
            if (action == ItemAbilities.HOE_TILL && context.getClickedFace() != Direction.DOWN && context.getLevel().getBlockState(context.getClickedPos().above()).isAir() && (state.is((Block)FrostBlocks.FROZEN_DIRT.get()) || state.is((Block)FrostBlocks.FROZEN_GRASS_BLOCK.get()))) {
                event.setFinalState(((Block)FrostBlocks.FROZEN_FARMLAND.get()).defaultBlockState());
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurtPost(LivingDamageEvent.Post event) {
        Entity stack;
        LivingEntity livingEntity = event.getEntity();
        Entity entity = event.getSource().getDirectEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (event.getSource().isDirect() && (stack = event.getSource().getWeaponItem()) != null) {
                int damage = (Integer)stack.getOrDefault(FrostDataCompnents.CRYSTAL_USED, (Object)0);
                @Nullable Holder attachableCrystal = (Holder)stack.get(FrostDataCompnents.ATTACH_CRYSTAL);
                if (attachableCrystal != null) {
                    Player player;
                    if (((AttachableCrystal)attachableCrystal.value()).getMobEffectInstance().isPresent()) {
                        livingEntity.addEffect(new MobEffectInstance(((AttachableCrystal)attachableCrystal.value()).getMobEffectInstance().get()));
                    }
                    if (!(attacker instanceof Player) || !(player = (Player)attacker).isCreative()) {
                        if (damage - 1 >= ((AttachableCrystal)attachableCrystal.value()).getUse()) {
                            stack.remove(FrostDataCompnents.ATTACH_CRYSTAL);
                            stack.remove(FrostDataCompnents.CRYSTAL_USED);
                            attacker.playSound(SoundEvents.SLIME_BLOCK_BREAK, 1.0f, 0.4f / (attacker.getRandom().nextFloat() * 0.4f + 0.8f));
                        } else {
                            stack.set(FrostDataCompnents.CRYSTAL_USED, (Object)(damage + 1));
                        }
                    }
                }
            }
        }
        if ((stack = event.getSource().getDirectEntity()) instanceof AbstractArrow) {
            Holder attachableCrystal;
            AbstractArrow arrow = (AbstractArrow)stack;
            ItemStack stack2 = arrow.getPickupItemStackOrigin();
            if (event.getBlockedDamage() <= 0.0f && stack2 != null && (attachableCrystal = (Holder)stack2.get(FrostDataCompnents.ATTACH_CRYSTAL)) != null && ((AttachableCrystal)attachableCrystal.value()).getMobEffectInstance().isPresent()) {
                livingEntity.addEffect(new MobEffectInstance(((AttachableCrystal)attachableCrystal.value()).getMobEffectInstance().get()));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingIncomingDamageEvent event) {
        Holder attachableCrystal;
        AbstractArrow arrow;
        ItemStack stack2;
        Entity stack;
        Entity crystalSlasher2;
        LivingEntity livingEntity = event.getEntity();
        if (event.getSource().getEntity() instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)event.getSource().getEntity();
            int auroraShaper = AuroraPowerUtils.getAuroraPowerLevel(AuroraPowers.AURORA_SHAPER.get(), attacker);
            if (event.getAmount() > 0.0f && auroraShaper > 0) {
                event.setAmount(AuroraCombatRules.getDamageAddition(event.getAmount(), auroraShaper));
            }
            int crystalSlasher2 = AuroraPowerUtils.getAuroraPowerLevel(AuroraPowers.CRYSTAL_SLASHER.get(), attacker);
            float armor = livingEntity.getArmorValue();
            if (event.getAmount() > 0.0f && armor > 0.0f && crystalSlasher2 > 0) {
                event.setAmount(AuroraCombatRules.getDamageAdditionWithExtra(event.getAmount(), crystalSlasher2, armor));
            }
        }
        int auroraProtection = AuroraPowerUtils.getAuroraPowerLevel(AuroraPowers.AURORA_PROTECTION.get(), livingEntity);
        if (event.getAmount() > 0.0f) {
            event.setAmount(AuroraCombatRules.getDamageReduction(event.getAmount(), auroraProtection));
        }
        if ((crystalSlasher2 = event.getSource().getDirectEntity()) instanceof LivingEntity) {
            Holder attachableCrystal2;
            LivingEntity attacker = (LivingEntity)crystalSlasher2;
            if (event.getSource().isDirect() && (stack = event.getSource().getWeaponItem()) != null && event.getAmount() > 0.0f && (attachableCrystal2 = (Holder)stack.get(FrostDataCompnents.ATTACH_CRYSTAL)) != null) {
                event.setAmount(event.getAmount() + ((AttachableCrystal)attachableCrystal2.value()).getDamage());
            }
        }
        if ((stack = event.getSource().getDirectEntity()) instanceof AbstractArrow && (stack2 = (arrow = (AbstractArrow)stack).getPickupItemStackOrigin()) != null && event.getAmount() > 0.0f && (attachableCrystal = (Holder)stack2.get(FrostDataCompnents.ATTACH_CRYSTAL)) != null) {
            event.setAmount(event.getAmount() + ((AttachableCrystal)attachableCrystal.value()).getDamage());
        }
    }
}

