/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm;

import baguchan.frostrealm.api.entity.WolfflueVariant;
import baguchan.frostrealm.api.recipe.AttachableCrystal;
import baguchan.frostrealm.client.ClientRegistrar;
import baguchan.frostrealm.command.FrostWeatherCommand;
import baguchan.frostrealm.command.TemperatureCommand;
import baguchan.frostrealm.data.resource.registries.AttachableCrystals;
import baguchan.frostrealm.data.resource.registries.WolfflueVariants;
import baguchan.frostrealm.message.ChangeAuroraMessage;
import baguchan.frostrealm.message.ChangeWeatherMessage;
import baguchan.frostrealm.message.ChangedColdMessage;
import baguchan.frostrealm.message.UpdateMultipartPacket;
import baguchan.frostrealm.registry.AuroraPowers;
import baguchan.frostrealm.registry.FrostActivity;
import baguchan.frostrealm.registry.FrostAttachs;
import baguchan.frostrealm.registry.FrostBiomeSources;
import baguchan.frostrealm.registry.FrostBiomes;
import baguchan.frostrealm.registry.FrostBlockEntitys;
import baguchan.frostrealm.registry.FrostBlockSetTypes;
import baguchan.frostrealm.registry.FrostBlocks;
import baguchan.frostrealm.registry.FrostChunkGenerators;
import baguchan.frostrealm.registry.FrostCreativeTabs;
import baguchan.frostrealm.registry.FrostCriterions;
import baguchan.frostrealm.registry.FrostDataCompnents;
import baguchan.frostrealm.registry.FrostEffects;
import baguchan.frostrealm.registry.FrostEntities;
import baguchan.frostrealm.registry.FrostEntityDatas;
import baguchan.frostrealm.registry.FrostFeatures;
import baguchan.frostrealm.registry.FrostFluidTypes;
import baguchan.frostrealm.registry.FrostFluids;
import baguchan.frostrealm.registry.FrostInteractionInformations;
import baguchan.frostrealm.registry.FrostItems;
import baguchan.frostrealm.registry.FrostLootFunctions;
import baguchan.frostrealm.registry.FrostMemoryModuleType;
import baguchan.frostrealm.registry.FrostMenuTypes;
import baguchan.frostrealm.registry.FrostParticleTypes;
import baguchan.frostrealm.registry.FrostPoiTypes;
import baguchan.frostrealm.registry.FrostRecipes;
import baguchan.frostrealm.registry.FrostSensors;
import baguchan.frostrealm.registry.FrostSounds;
import baguchan.frostrealm.registry.FrostTrunkPlacerTypes;
import baguchan.frostrealm.registry.FrostWeathers;
import baguchan.frostrealm.registry.FrostWoodTypes;
import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.util.thread.EffectiveSide;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="frostrealm")
public class FrostRealm {
    public static final Logger LOGGER = LogManager.getLogger((String)"frostrealm");
    public static final String MODID = "frostrealm";
    public static final String NETWORK_PROTOCOL = "2";

    public FrostRealm(ModContainer modContainer, IEventBus modBus) {
        IEventBus forgeBus = NeoForge.EVENT_BUS;
        modBus.addListener(DataPackRegistryEvent.NewRegistry.class, event -> event.dataPackRegistry(WolfflueVariants.WOLFFLUE_VARIANT_REGISTRY_KEY, WolfflueVariant.DIRECT_CODEC, WolfflueVariant.DIRECT_CODEC));
        modBus.addListener(DataPackRegistryEvent.NewRegistry.class, event -> event.dataPackRegistry(AttachableCrystals.ATTACHABLE_CRYSTAL_REGISTRY_KEY, AttachableCrystal.DIRECT_CODEC, AttachableCrystal.DIRECT_CODEC));
        FrostFeatures.FEATURES.register(modBus);
        FrostSounds.SOUND_EVENTS.register(modBus);
        FrostMenuTypes.MENU_TYPES.register(modBus);
        FrostFluidTypes.FLUID_TYPES.register(modBus);
        FrostFluids.FLUIDS.register(modBus);
        FrostBlocks.BLOCKS.register(modBus);
        FrostSensors.SENSOR_TYPES.register(modBus);
        FrostMemoryModuleType.MEMORY_MODULE_TYPES.register(modBus);
        FrostEntityDatas.ENTITIE_DATAS.register(modBus);
        FrostEntities.ENTITIES.register(modBus);
        FrostCreativeTabs.CREATIVE_MODE_TABS.register(modBus);
        FrostItems.ITEMS.register(modBus);
        FrostLootFunctions.LOOT_REIGSTER.register(modBus);
        FrostParticleTypes.PARTICLE_TYPES.register(modBus);
        FrostEffects.MOB_EFFECTS.register(modBus);
        FrostEffects.POTION.register(modBus);
        FrostRecipes.RECIPE_SERIALIZERS.register(modBus);
        FrostBlockEntitys.BLOCK_ENTITIES.register(modBus);
        FrostAttachs.ATTACHMENT_TYPES.register(modBus);
        FrostPoiTypes.POI_TYPES.register(modBus);
        FrostActivity.ACTIVITY.register(modBus);
        FrostChunkGenerators.CHUNK_GENERATOR.register(modBus);
        FrostWeathers.FROST_WEATHER.register(modBus);
        AuroraPowers.AURORA_POWER.register(modBus);
        FrostTrunkPlacerTypes.TRUNK_TYPES.register(modBus);
        FrostDataCompnents.DATA_COMPONENT_TYPES.register(modBus);
        FrostCriterions.CRITERIONS_REGISTER.register(modBus);
        modBus.addListener(this::setup);
        modBus.addListener(this::dataSetup);
        modBus.addListener(this::setupPackets);
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        modBus.addListener(this::setupBlockEntity);
        if (FMLEnvironment.getDist() == Dist.CLIENT) {
            modBus.addListener(ClientRegistrar::setup);
        }
    }

    private void dataSetup(DataPackRegistryEvent.NewRegistry event) {
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            FrostBlockSetTypes.init();
            FrostWoodTypes.init();
            FrostInteractionInformations.init();
            FrostBlocks.burnables();
            FrostBiomes.addBiomeTypes();
            HashMap map = Maps.newHashMap();
            map.putAll(Map.copyOf(MultiNoiseBiomeSourceParameterList.Preset.BY_NAME));
            map.put(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)MODID), FrostBiomeSources.FROSTREALM_PRESET);
            MultiNoiseBiomeSourceParameterList.Preset.BY_NAME = map;
        });
    }

    public void setupBlockEntity(BlockEntityTypeAddBlocksEvent event) {
        event.modify(BlockEntityType.CAMPFIRE, new Block[]{(Block)FrostBlocks.FROST_CAMPFIRE.get()});
    }

    public static void sendMSGToAll(CustomPacketPayload message) {
        for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers()) {
            FrostRealm.sendNonLocal(message, player);
        }
    }

    public static void sendNonLocal(CustomPacketPayload msg, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void setupPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID).versioned("1.0.0").optional();
        registrar.playToClient(ChangedColdMessage.TYPE, ChangedColdMessage.STREAM_CODEC, (handler, payload) -> ChangedColdMessage.handle(handler, payload));
        registrar.playToClient(ChangeWeatherMessage.TYPE, ChangeWeatherMessage.STREAM_CODEC, (handler, payload) -> ChangeWeatherMessage.handle(handler, payload));
        registrar.playToClient(ChangeAuroraMessage.TYPE, ChangeAuroraMessage.STREAM_CODEC, (handler, payload) -> ChangeAuroraMessage.handle(handler, payload));
        registrar.playToClient(UpdateMultipartPacket.TYPE, UpdateMultipartPacket.STREAM_CODEC, (handler, payload) -> UpdateMultipartPacket.handle(handler, payload));
    }

    public static ResourceLocation prefix(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name.toLowerCase(Locale.ROOT));
    }

    public static String prefixOnString(String name) {
        return "frostrealm:" + name.toLowerCase(Locale.ROOT);
    }

    private void registerCommands(RegisterCommandsEvent evt) {
        FrostWeatherCommand.register((CommandDispatcher<CommandSourceStack>)evt.getDispatcher());
        TemperatureCommand.register((CommandDispatcher<CommandSourceStack>)evt.getDispatcher());
    }

    public static RegistryAccess registryAccess() {
        if (EffectiveSide.get().isServer()) {
            return ServerLifecycleHooks.getCurrentServer().registryAccess();
        }
        return Minecraft.getInstance().getConnection().registryAccess();
    }
}

