/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.api.recipe;

import baguchan.frostrealm.data.resource.registries.AttachableCrystals;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;

public class AttachableCrystal {
    public static final Codec<AttachableCrystal> DIRECT_CODEC = RecordCodecBuilder.create(p_332779_ -> p_332779_.group((App)Item.CODEC.fieldOf("items").forGetter(AttachableCrystal::getItem), (App)Codec.FLOAT.fieldOf("damage").forGetter(AttachableCrystal::getDamage), (App)ExtraCodecs.POSITIVE_INT.fieldOf("usage").forGetter(AttachableCrystal::getUse), (App)MobEffectInstance.CODEC.optionalFieldOf("mob_effects").forGetter(AttachableCrystal::getMobEffectInstance)).apply((Applicative)p_332779_, AttachableCrystal::new));
    public static final Codec<Holder<AttachableCrystal>> CODEC = RegistryFileCodec.create(AttachableCrystals.ATTACHABLE_CRYSTAL_REGISTRY_KEY, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<AttachableCrystal>> STREAM_CODEC = ByteBufCodecs.holderRegistry(AttachableCrystals.ATTACHABLE_CRYSTAL_REGISTRY_KEY);
    private final Holder<Item> item;
    private final float damage;
    private final int use;
    private final Optional<MobEffectInstance> mobEffectInstance;

    public AttachableCrystal(Holder<Item> item, float damage, int use, Optional<MobEffectInstance> mobEffectInstance) {
        this.item = item;
        this.damage = damage;
        this.use = use;
        this.mobEffectInstance = mobEffectInstance;
    }

    public Holder<Item> getItem() {
        return this.item;
    }

    public float getDamage() {
        return this.damage;
    }

    public int getUse() {
        return this.use;
    }

    public Optional<MobEffectInstance> getMobEffectInstance() {
        return this.mobEffectInstance;
    }

    public boolean equals(Object p_332811_) {
        boolean bl;
        if (p_332811_ == this) {
            return true;
        }
        if (!(p_332811_ instanceof AttachableCrystal)) {
            bl = false;
        } else {
            AttachableCrystal attachableCrystal = (AttachableCrystal)p_332811_;
            bl = Objects.equals(this.getItem(), attachableCrystal.getItem()) && Objects.equals(Float.valueOf(this.damage), Float.valueOf(attachableCrystal.damage)) && Objects.equals(this.use, attachableCrystal.use);
        }
        return bl;
    }
}

