/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.aurorapower;

import baguchan.frostrealm.registry.AuroraPowers;
import baguchan.frostrealm.utils.aurorapower.AuroraPowerUtils;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class AuroraPower {
    @Nullable
    protected String descriptionId;
    @Nullable
    protected String rawDescription;
    protected final Rarity rarity;
    private final EquipmentSlot[] slots;
    private final int level;
    private int minlevel = 1;

    public AuroraPower(Properties properties, EquipmentSlot[] equipmentSlots) {
        this.rarity = properties.rarity;
        this.level = properties.level;
        this.slots = equipmentSlots;
    }

    public EquipmentSlot[] getSlots() {
        return this.slots;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public AuroraPower setMinLevel(int level) {
        this.minlevel = level;
        return this;
    }

    public int getMinLevel() {
        return this.minlevel;
    }

    public int getMaxLevel() {
        return this.level;
    }

    public int getMinCost(int auroraPowerLevel) {
        return 1 + (auroraPowerLevel - 1) * 10;
    }

    public int getMaxCost(int auroraPowerLevel) {
        return this.getMinCost(auroraPowerLevel) + 5;
    }

    public Map<EquipmentSlot, ItemStack> getSlotItems(LivingEntity p_44685_) {
        EnumMap map = Maps.newEnumMap(EquipmentSlot.class);
        for (EquipmentSlot equipmentslot : this.slots) {
            ItemStack itemstack = p_44685_.getItemBySlot(equipmentslot);
            if (itemstack.isEmpty()) continue;
            map.put(equipmentslot, itemstack);
        }
        return map;
    }

    public void tick(LivingEntity entity, int level) {
    }

    public final boolean isCompatibleWith(ItemStack itemStack, AuroraPower auroraPower) {
        return this.canApplyTogether(auroraPower) && auroraPower.canApplyTogether(this);
    }

    public final boolean isCompatibleWith(ItemStack itemStack) {
        for (Holder<AuroraPower> auroraPower : AuroraPowerUtils.getAuroraPowers(itemStack).keySet()) {
            if (this.canApplyTogether((AuroraPower)auroraPower.value()) && ((AuroraPower)auroraPower.value()).canApplyTogether(this)) continue;
            return false;
        }
        return true;
    }

    public boolean isTresureEnchant() {
        return false;
    }

    public boolean isOnlyChest() {
        return false;
    }

    protected boolean canApplyTogether(AuroraPower ench) {
        return this != ench;
    }

    public boolean canApplyItem(ItemStack stack) {
        return true;
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.makeDescriptionId((String)"aurora_power", (ResourceLocation)AuroraPowers.getRegistry().getKey((Object)this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public Component getFullname(int p_44701_) {
        MutableComponent mutablecomponent = Component.translatable((String)this.getDescriptionId());
        mutablecomponent.withStyle(ChatFormatting.GREEN);
        if (p_44701_ != 1 || this.getMaxLevel() != 1) {
            mutablecomponent.append(CommonComponents.SPACE).append((Component)Component.translatable((String)("enchantment.level." + p_44701_)));
        }
        return mutablecomponent;
    }

    public Component getFullnameWithEnglish(int p_44701_) {
        MutableComponent mutablecomponent = Component.translatable((String)this.getOrCreateDescriptionId());
        mutablecomponent.withStyle(ChatFormatting.GREEN);
        if (p_44701_ != 1 || this.getMaxLevel() != 1) {
            mutablecomponent.append(CommonComponents.SPACE).append((Component)Component.translatable((String)("enchantment.level." + p_44701_)));
        }
        return mutablecomponent;
    }

    public static class Properties {
        private final Rarity rarity;
        private final int level;

        public Properties(Rarity rarity, int level) {
            this.rarity = rarity;
            this.level = level;
        }
    }

    public static enum Rarity {
        COMMON(10),
        UNCOMMON(5),
        RARE(2),
        VERY_RARE(1);

        private final int weight;

        private Rarity(int rarityWeight) {
            this.weight = rarityWeight;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

