/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.block;

import baguchan.frostrealm.menu.AuroraInfuserMenu;
import baguchan.frostrealm.registry.FrostBlocks;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;

public class AuroraInfuserBlock
extends Block {
    private static final Component CONTAINER_TITLE = Component.translatable((String)"container.frostrealm.aurora_infuser");
    public static final List<BlockPos> OFFSETS = BlockPos.betweenClosedStream((int)-2, (int)0, (int)-2, (int)2, (int)1, (int)2).filter(p_207914_ -> Math.abs(p_207914_.getX()) == 2 || Math.abs(p_207914_.getZ()) == 2).map(BlockPos::immutable).toList();

    public AuroraInfuserBlock(BlockBehaviour.Properties p_52953_) {
        super(p_52953_);
    }

    public static boolean isValidWarpedCrystal(Level p_207910_, BlockPos p_207911_, BlockPos p_207912_) {
        return p_207910_.getBlockState(p_207911_.offset((Vec3i)p_207912_)).getBlock() == FrostBlocks.WARPED_CRYSTAL_BLOCK.get() && p_207910_.isEmptyBlock(p_207911_.offset(p_207912_.getX() / 2, p_207912_.getY(), p_207912_.getZ() / 2));
    }

    public boolean useShapeForLightOcclusion(BlockState p_52997_) {
        return true;
    }

    public void animateTick(BlockState p_221092_, Level p_221093_, BlockPos p_221094_, RandomSource p_221095_) {
        super.animateTick(p_221092_, p_221093_, p_221094_, p_221095_);
        for (BlockPos blockpos : OFFSETS) {
            if (p_221095_.nextInt(16) != 0 || !AuroraInfuserBlock.isValidWarpedCrystal(p_221093_, p_221094_, blockpos)) continue;
            p_221093_.addParticle((ParticleOptions)ParticleTypes.ENCHANT, (double)p_221094_.getX() + 0.5, (double)p_221094_.getY() + 2.0, (double)p_221094_.getZ() + 0.5, (double)((float)blockpos.getX() + p_221095_.nextFloat()) - 0.5, (double)((float)blockpos.getY() - p_221095_.nextFloat() - 1.0f), (double)((float)blockpos.getZ() + p_221095_.nextFloat()) - 0.5);
        }
    }

    public RenderShape getRenderShape(BlockState p_52986_) {
        return RenderShape.MODEL;
    }

    protected InteractionResult useWithoutItem(BlockState p_60503_, Level p_60504_, BlockPos p_60505_, Player p_60506_, BlockHitResult p_60508_) {
        if (p_60504_.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        p_60506_.openMenu(p_60503_.getMenuProvider(p_60504_, p_60505_));
        return InteractionResult.CONSUME;
    }

    public MenuProvider getMenuProvider(BlockState p_52240_, Level p_52241_, BlockPos p_52242_) {
        return new SimpleMenuProvider((p_52229_, p_52230_, p_52231_) -> new AuroraInfuserMenu(p_52229_, p_52230_, ContainerLevelAccess.create((Level)p_52241_, (BlockPos)p_52242_)), CONTAINER_TITLE);
    }

    public boolean isPathfindable(BlockState p_52969_, BlockGetter p_52970_, BlockPos p_52971_, PathComputationType p_52972_) {
        return false;
    }
}

