/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.block;

import baguchan.frostrealm.registry.FrostBlocks;
import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PointedIceBlock
extends Block
implements Fallable,
SimpleWaterloggedBlock {
    public static final EnumProperty<Direction> TIP_DIRECTION = BlockStateProperties.VERTICAL_DIRECTION;
    public static final EnumProperty<DripstoneThickness> THICKNESS = BlockStateProperties.DRIPSTONE_THICKNESS;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape TIP_MERGE_SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_UP = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_DOWN = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape BASE_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final float MAX_HORIZONTAL_OFFSET = 0.125f;

    public PointedIceBlock(BlockBehaviour.Properties p_154025_) {
        super(p_154025_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(TIP_DIRECTION, (Comparable)Direction.UP)).setValue(THICKNESS, (Comparable)DripstoneThickness.TIP)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_154157_) {
        p_154157_.add(new Property[]{TIP_DIRECTION, THICKNESS, WATERLOGGED});
    }

    public boolean canSurvive(BlockState p_154137_, LevelReader p_154138_, BlockPos p_154139_) {
        return PointedIceBlock.isValidPointedDripstonePlacement(p_154138_, p_154139_, (Direction)p_154137_.getValue(TIP_DIRECTION));
    }

    protected BlockState updateShape(BlockState p_154147_, LevelReader p_374104_, ScheduledTickAccess p_374078_, BlockPos p_154151_, Direction p_154148_, BlockPos p_154152_, BlockState p_154149_, RandomSource p_374393_) {
        if (((Boolean)p_154147_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_374078_.scheduleTick(p_154151_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(p_374104_));
        }
        if (p_154148_ != Direction.UP && p_154148_ != Direction.DOWN) {
            return p_154147_;
        }
        Direction direction = (Direction)p_154147_.getValue(TIP_DIRECTION);
        if (direction == Direction.DOWN && p_374078_.getBlockTicks().hasScheduledTick(p_154151_, (Object)this)) {
            return p_154147_;
        }
        if (p_154148_ == direction.getOpposite() && !this.canSurvive(p_154147_, p_374104_, p_154151_)) {
            if (direction == Direction.DOWN) {
                p_374078_.scheduleTick(p_154151_, (Block)this, 2);
            } else {
                p_374078_.scheduleTick(p_154151_, (Block)this, 1);
            }
            return p_154147_;
        }
        boolean flag = p_154147_.getValue(THICKNESS) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness dripstonethickness = PointedIceBlock.calculateDripstoneThickness(p_374104_, p_154151_, direction, flag);
        return (BlockState)p_154147_.setValue(THICKNESS, (Comparable)dripstonethickness);
    }

    protected void onProjectileHit(Level p_60453_, BlockState p_60454_, BlockHitResult p_60455_, Projectile p_60456_) {
        super.onProjectileHit(p_60453_, p_60454_, p_60455_, p_60456_);
        BlockPos blockpos = p_60455_.getBlockPos();
        if (p_60453_ instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)p_60453_;
            if (!p_60453_.isClientSide() && p_60456_.mayInteract(serverLevel, blockpos) && p_60456_ instanceof ThrownTrident && p_60456_.getDeltaMovement().length() > 0.6) {
                p_60453_.destroyBlock(blockpos, true);
            }
        }
    }

    public void fallOn(Level p_152426_, BlockState p_152427_, BlockPos p_152428_, Entity p_152429_, double p_397222_) {
        if (p_152427_.getValue(TIP_DIRECTION) == Direction.UP && p_152427_.getValue(THICKNESS) == DripstoneThickness.TIP) {
            p_152429_.causeFallDamage(p_397222_ + 2.0, 2.0f, p_152426_.damageSources().stalagmite());
            if (p_152429_.fallDistance > 1.0) {
                p_152426_.destroyBlock(p_152428_, false);
            }
        } else {
            super.fallOn(p_152426_, p_152427_, p_152428_, p_152429_, p_397222_);
        }
    }

    public void animateTick(BlockState p_154122_, Level p_154123_, BlockPos p_154124_, RandomSource p_154125_) {
        float f;
        if (PointedIceBlock.canDrip(p_154122_) && !((f = p_154125_.nextFloat()) > 0.12f)) {
            PointedIceBlock.getFluidAboveStalactite(p_154123_, p_154124_, p_154122_).filter(p_154031_ -> f < 0.02f || PointedIceBlock.canFillCauldron(p_154031_)).ifPresent(p_154220_ -> PointedIceBlock.spawnDripParticle(p_154123_, p_154124_, p_154122_, p_154220_));
        }
    }

    public void tick(BlockState p_154107_, ServerLevel p_154108_, BlockPos p_154109_, RandomSource p_154110_) {
        if (PointedIceBlock.isStalagmite(p_154107_) && !this.canSurvive(p_154107_, (LevelReader)p_154108_, p_154109_)) {
            p_154108_.destroyBlock(p_154109_, true);
        } else {
            PointedIceBlock.spawnFallingStalactite(p_154107_, p_154108_, p_154109_);
        }
    }

    public void randomTick(BlockState p_154199_, ServerLevel p_154200_, BlockPos p_154201_, RandomSource p_154202_) {
        if (p_154202_.nextFloat() < 0.011377778f && PointedIceBlock.isStalactiteStartPos(p_154199_, (LevelReader)p_154200_, p_154201_)) {
            PointedIceBlock.growStalactiteOrStalagmiteIfPossible(p_154199_, p_154200_, p_154201_, p_154202_);
        }
    }

    public PushReaction getPistonPushReaction(BlockState p_154237_) {
        return PushReaction.DESTROY;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_154040_) {
        Direction direction;
        BlockPos blockpos;
        Level levelaccessor = p_154040_.getLevel();
        Direction direction1 = PointedIceBlock.calculateTipDirection((LevelReader)levelaccessor, blockpos = p_154040_.getClickedPos(), direction = p_154040_.getNearestLookingVerticalDirection().getOpposite());
        if (direction1 == null) {
            return null;
        }
        boolean flag = !p_154040_.isSecondaryUseActive();
        DripstoneThickness dripstonethickness = PointedIceBlock.calculateDripstoneThickness((LevelReader)levelaccessor, blockpos, direction1, flag);
        return dripstonethickness == null ? null : (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(TIP_DIRECTION, (Comparable)direction1)).setValue(THICKNESS, (Comparable)dripstonethickness)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.getFluidState(blockpos).getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState p_154235_) {
        return (Boolean)p_154235_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_154235_);
    }

    protected VoxelShape getOcclusionShape(BlockState p_60578_) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState p_154117_, BlockGetter p_154118_, BlockPos p_154119_, CollisionContext p_154120_) {
        DripstoneThickness dripstonethickness = (DripstoneThickness)p_154117_.getValue(THICKNESS);
        VoxelShape voxelshape = dripstonethickness == DripstoneThickness.TIP_MERGE ? TIP_MERGE_SHAPE : (dripstonethickness == DripstoneThickness.TIP ? (p_154117_.getValue(TIP_DIRECTION) == Direction.DOWN ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (dripstonethickness == DripstoneThickness.FRUSTUM ? FRUSTUM_SHAPE : (dripstonethickness == DripstoneThickness.MIDDLE ? MIDDLE_SHAPE : BASE_SHAPE)));
        Vec3 vec3 = p_154117_.getOffset(p_154119_);
        return voxelshape.move(vec3.x, 0.0, vec3.z);
    }

    public boolean isCollisionShapeFullBlock(BlockState p_181235_, BlockGetter p_181236_, BlockPos p_181237_) {
        return false;
    }

    public float getMaxHorizontalOffset() {
        return 0.125f;
    }

    public DamageSource getFallDamageSource(Entity p_253907_) {
        return p_253907_.damageSources().stalagmite();
    }

    public Predicate<Entity> getHurtsEntitySelector() {
        return EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(EntitySelector.LIVING_ENTITY_STILL_ALIVE);
    }

    private void scheduleStalactiteFallTicks(BlockState p_154127_, LevelAccessor p_154128_, BlockPos p_154129_) {
        BlockPos blockpos = PointedIceBlock.findTip(p_154127_, p_154128_, p_154129_, Integer.MAX_VALUE, true);
        if (blockpos != null) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = blockpos.mutable();
            while (PointedIceBlock.isStalactite(p_154128_.getBlockState((BlockPos)blockpos$mutableblockpos))) {
                p_154128_.scheduleTick((BlockPos)blockpos$mutableblockpos, (Block)this, 2);
                blockpos$mutableblockpos.move(Direction.UP);
            }
        }
    }

    private static void spawnFallingStalactite(BlockState p_154098_, ServerLevel p_154099_, BlockPos p_154100_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_154100_.mutable();
        BlockState blockstate = p_154098_;
        while (PointedIceBlock.isStalactite(blockstate)) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.fall((Level)p_154099_, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate);
            if (PointedIceBlock.isTip(blockstate, true)) {
                int i = Math.max(1 + p_154100_.getY() - blockpos$mutableblockpos.getY(), 6);
                float f = 1.0f * (float)i;
                fallingblockentity.setHurtsEntities(f, 40);
                break;
            }
            blockpos$mutableblockpos.move(Direction.DOWN);
            blockstate = p_154099_.getBlockState((BlockPos)blockpos$mutableblockpos);
        }
    }

    @VisibleForTesting
    public static void growStalactiteOrStalagmiteIfPossible(BlockState p_154226_, ServerLevel p_154227_, BlockPos p_154228_, RandomSource p_154229_) {
        BlockState blockstate2;
        BlockPos blockpos;
        BlockState blockstate1;
        BlockState blockstate = p_154227_.getBlockState(p_154228_.above(1));
        if (PointedIceBlock.canGrow(blockstate, blockstate1 = p_154227_.getBlockState(p_154228_.above(2))) && (blockpos = PointedIceBlock.findTip(p_154226_, (LevelAccessor)p_154227_, p_154228_, 7, false)) != null && PointedIceBlock.canDrip(blockstate2 = p_154227_.getBlockState(blockpos)) && PointedIceBlock.canTipGrow(blockstate2, p_154227_, blockpos)) {
            if (p_154229_.nextBoolean()) {
                PointedIceBlock.grow(p_154227_, blockpos, Direction.DOWN);
            } else {
                PointedIceBlock.growStalagmiteBelow(p_154227_, blockpos);
            }
        }
    }

    private static void growStalagmiteBelow(ServerLevel p_154033_, BlockPos p_154034_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_154034_.mutable();
        for (int i = 0; i < 10; ++i) {
            blockpos$mutableblockpos.move(Direction.DOWN);
            BlockState blockstate = p_154033_.getBlockState((BlockPos)blockpos$mutableblockpos);
            if (!blockstate.getFluidState().isEmpty()) {
                return;
            }
            if (PointedIceBlock.isUnmergedTipWithDirection(blockstate, Direction.UP) && PointedIceBlock.canTipGrow(blockstate, p_154033_, (BlockPos)blockpos$mutableblockpos)) {
                PointedIceBlock.grow(p_154033_, (BlockPos)blockpos$mutableblockpos, Direction.UP);
                return;
            }
            if (!PointedIceBlock.isValidPointedDripstonePlacement((LevelReader)p_154033_, (BlockPos)blockpos$mutableblockpos, Direction.UP) || p_154033_.isWaterAt(blockpos$mutableblockpos.below())) continue;
            PointedIceBlock.grow(p_154033_, blockpos$mutableblockpos.below(), Direction.UP);
            return;
        }
    }

    private static void grow(ServerLevel p_154036_, BlockPos p_154037_, Direction p_154038_) {
        BlockPos blockpos = p_154037_.relative(p_154038_);
        BlockState blockstate = p_154036_.getBlockState(blockpos);
        if (PointedIceBlock.isUnmergedTipWithDirection(blockstate, p_154038_.getOpposite())) {
            PointedIceBlock.createMergedTips(blockstate, (LevelAccessor)p_154036_, blockpos);
        } else if (blockstate.isAir() || blockstate.is(Blocks.WATER)) {
            PointedIceBlock.createDripstone((LevelAccessor)p_154036_, blockpos, p_154038_, DripstoneThickness.TIP);
        }
    }

    private static void createDripstone(LevelAccessor p_154088_, BlockPos p_154089_, Direction p_154090_, DripstoneThickness p_154091_) {
        BlockState blockstate = (BlockState)((BlockState)((BlockState)((Block)FrostBlocks.POINTED_ICE.get()).defaultBlockState().setValue(TIP_DIRECTION, (Comparable)p_154090_)).setValue(THICKNESS, (Comparable)p_154091_)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(p_154088_.getFluidState(p_154089_).getType() == Fluids.WATER));
        p_154088_.setBlock(p_154089_, blockstate, 3);
    }

    private static void createMergedTips(BlockState p_154231_, LevelAccessor p_154232_, BlockPos p_154233_) {
        BlockPos blockpos;
        BlockPos blockpos1;
        if (p_154231_.getValue(TIP_DIRECTION) == Direction.UP) {
            blockpos1 = p_154233_;
            blockpos = p_154233_.above();
        } else {
            blockpos = p_154233_;
            blockpos1 = p_154233_.below();
        }
        PointedIceBlock.createDripstone(p_154232_, blockpos, Direction.DOWN, DripstoneThickness.TIP_MERGE);
        PointedIceBlock.createDripstone(p_154232_, blockpos1, Direction.UP, DripstoneThickness.TIP_MERGE);
    }

    private static void spawnDripParticle(Level p_154072_, BlockPos p_154073_, BlockState p_154074_, Fluid p_154075_) {
        Vec3 vec3 = p_154074_.getOffset(p_154073_);
        double d0 = 0.0625;
        double d1 = (double)p_154073_.getX() + 0.5 + vec3.x;
        double d2 = (double)((float)(p_154073_.getY() + 1) - 0.6875f) - 0.0625;
        double d3 = (double)p_154073_.getZ() + 0.5 + vec3.z;
        Fluid fluid = PointedIceBlock.getDripFluid(p_154072_, p_154075_);
        SimpleParticleType particleoptions = ParticleTypes.DRIPPING_DRIPSTONE_WATER;
        p_154072_.addParticle((ParticleOptions)particleoptions, d1, d2, d3, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static BlockPos findTip(BlockState p_154131_, LevelAccessor p_154132_, BlockPos p_154133_, int p_154134_, boolean p_154135_) {
        if (PointedIceBlock.isTip(p_154131_, p_154135_)) {
            return p_154133_;
        }
        Direction direction = (Direction)p_154131_.getValue(TIP_DIRECTION);
        Predicate<BlockState> predicate = p_154212_ -> p_154212_.is((Block)FrostBlocks.POINTED_ICE.get()) && p_154212_.getValue(TIP_DIRECTION) == direction;
        return PointedIceBlock.findBlockVertical(p_154132_, p_154133_, direction.getAxisDirection(), predicate, p_154168_ -> PointedIceBlock.isTip(p_154168_, p_154135_), p_154134_).orElse(null);
    }

    @Nullable
    private static Direction calculateTipDirection(LevelReader p_154191_, BlockPos p_154192_, Direction p_154193_) {
        Direction direction;
        if (PointedIceBlock.isValidPointedDripstonePlacement(p_154191_, p_154192_, p_154193_)) {
            direction = p_154193_;
        } else {
            if (!PointedIceBlock.isValidPointedDripstonePlacement(p_154191_, p_154192_, p_154193_.getOpposite())) {
                return null;
            }
            direction = p_154193_.getOpposite();
        }
        return direction;
    }

    private static DripstoneThickness calculateDripstoneThickness(LevelReader p_154093_, BlockPos p_154094_, Direction p_154095_, boolean p_154096_) {
        Direction direction = p_154095_.getOpposite();
        BlockState blockstate = p_154093_.getBlockState(p_154094_.relative(p_154095_));
        if (PointedIceBlock.isPointedDripstoneWithDirection(blockstate, direction)) {
            return !p_154096_ && blockstate.getValue(THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!PointedIceBlock.isPointedDripstoneWithDirection(blockstate, p_154095_)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)blockstate.getValue(THICKNESS);
        if (dripstonethickness != DripstoneThickness.TIP && dripstonethickness != DripstoneThickness.TIP_MERGE) {
            BlockState blockstate1 = p_154093_.getBlockState(p_154094_.relative(direction));
            return !PointedIceBlock.isPointedDripstoneWithDirection(blockstate1, p_154095_) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    public static boolean canDrip(BlockState p_154239_) {
        return PointedIceBlock.isStalactite(p_154239_) && p_154239_.getValue(THICKNESS) == DripstoneThickness.TIP && (Boolean)p_154239_.getValue((Property)WATERLOGGED) == false;
    }

    private static boolean canTipGrow(BlockState p_154195_, ServerLevel p_154196_, BlockPos p_154197_) {
        Direction direction = (Direction)p_154195_.getValue(TIP_DIRECTION);
        BlockPos blockpos = p_154197_.relative(direction);
        BlockState blockstate = p_154196_.getBlockState(blockpos);
        if (!blockstate.getFluidState().isEmpty()) {
            return false;
        }
        return blockstate.isAir() || PointedIceBlock.isUnmergedTipWithDirection(blockstate, direction.getOpposite());
    }

    private static Optional<BlockPos> findRootBlock(Level p_154067_, BlockPos p_154068_, BlockState p_154069_, int p_154070_) {
        Direction direction = (Direction)p_154069_.getValue(TIP_DIRECTION);
        Predicate<BlockState> predicate = p_154165_ -> p_154165_.is((Block)FrostBlocks.POINTED_ICE.get()) && p_154165_.getValue(TIP_DIRECTION) == direction;
        return PointedIceBlock.findBlockVertical((LevelAccessor)p_154067_, p_154068_, direction.getOpposite().getAxisDirection(), predicate, p_154245_ -> !p_154245_.is((Block)FrostBlocks.POINTED_ICE.get()), p_154070_);
    }

    private static boolean isValidPointedDripstonePlacement(LevelReader p_154222_, BlockPos p_154223_, Direction p_154224_) {
        BlockPos blockpos = p_154223_.relative(p_154224_.getOpposite());
        BlockState blockstate = p_154222_.getBlockState(blockpos);
        return blockstate.isFaceSturdy((BlockGetter)p_154222_, blockpos, p_154224_) || PointedIceBlock.isPointedDripstoneWithDirection(blockstate, p_154224_);
    }

    private static boolean isTip(BlockState p_154154_, boolean p_154155_) {
        if (!p_154154_.is((Block)FrostBlocks.POINTED_ICE.get())) {
            return false;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)p_154154_.getValue(THICKNESS);
        return dripstonethickness == DripstoneThickness.TIP || p_154155_ && dripstonethickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean isUnmergedTipWithDirection(BlockState p_154144_, Direction p_154145_) {
        return PointedIceBlock.isTip(p_154144_, false) && p_154144_.getValue(TIP_DIRECTION) == p_154145_;
    }

    private static boolean isStalactite(BlockState p_154241_) {
        return PointedIceBlock.isPointedDripstoneWithDirection(p_154241_, Direction.DOWN);
    }

    private static boolean isStalagmite(BlockState p_154243_) {
        return PointedIceBlock.isPointedDripstoneWithDirection(p_154243_, Direction.UP);
    }

    private static boolean isStalactiteStartPos(BlockState p_154204_, LevelReader p_154205_, BlockPos p_154206_) {
        return PointedIceBlock.isStalactite(p_154204_) && !p_154205_.getBlockState(p_154206_.above()).is((Block)FrostBlocks.POINTED_ICE.get());
    }

    public boolean isPathfindable(BlockState p_154112_, BlockGetter p_154113_, BlockPos p_154114_, PathComputationType p_154115_) {
        return false;
    }

    private static boolean isPointedDripstoneWithDirection(BlockState p_154208_, Direction p_154209_) {
        return p_154208_.is((Block)FrostBlocks.POINTED_ICE.get()) && p_154208_.getValue(TIP_DIRECTION) == p_154209_;
    }

    private static Optional<Fluid> getFluidAboveStalactite(Level p_154182_, BlockPos p_154183_, BlockState p_154184_) {
        return !PointedIceBlock.isStalactite(p_154184_) ? Optional.empty() : PointedIceBlock.findRootBlock(p_154182_, p_154183_, p_154184_, 11).map(p_154215_ -> p_154182_.getFluidState(p_154215_.above()).getType());
    }

    private static boolean canFillCauldron(Fluid p_154159_) {
        return p_154159_ == Fluids.WATER;
    }

    private static boolean canGrow(BlockState p_154141_, BlockState p_154142_) {
        return p_154141_.is(Blocks.DRIPSTONE_BLOCK) && p_154142_.is(Blocks.WATER) && p_154142_.getFluidState().isSource();
    }

    private static Fluid getDripFluid(Level p_154053_, Fluid p_154054_) {
        if (p_154054_.isSame(Fluids.EMPTY)) {
            return Fluids.WATER;
        }
        return p_154054_;
    }

    private static Optional<BlockPos> findBlockVertical(LevelAccessor p_154081_, BlockPos p_154082_, Direction.AxisDirection p_154083_, Predicate<BlockState> p_154084_, Predicate<BlockState> p_154085_, int p_154086_) {
        Direction direction = Direction.get((Direction.AxisDirection)p_154083_, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_154082_.mutable();
        for (int i = 1; i < p_154086_; ++i) {
            blockpos$mutableblockpos.move(direction);
            BlockState blockstate = p_154081_.getBlockState((BlockPos)blockpos$mutableblockpos);
            if (p_154085_.test(blockstate)) {
                return Optional.of(blockpos$mutableblockpos.immutable());
            }
            if (!p_154081_.isOutsideBuildHeight(blockpos$mutableblockpos.getY()) && p_154084_.test(blockstate)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    public void onBrokenAfterFall(Level p_154059_, BlockPos p_154060_, FallingBlockEntity p_154061_) {
        if (!p_154061_.isSilent()) {
            p_154059_.levelEvent(2001, p_154060_, Block.getId((BlockState)((Block)FrostBlocks.POINTED_ICE.get()).defaultBlockState()));
        }
    }
}

