/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.capability;

import baguchan.frostrealm.api.IItemAnimation;
import baguchan.frostrealm.capability.FrostWeatherSavedData;
import baguchan.frostrealm.data.resource.FrostDimensions;
import baguchan.frostrealm.message.ChangedColdMessage;
import baguchan.frostrealm.registry.FrostAttachs;
import baguchan.frostrealm.registry.FrostEffects;
import baguchan.frostrealm.registry.FrostFluidTypes;
import baguchan.frostrealm.registry.FrostTags;
import baguchan.frostrealm.registry.FrostWeathers;
import baguchan.frostrealm.utils.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.network.PacketDistributor;

public class FrostLivingCapability
implements ValueIOSerializable {
    public boolean isInsidePortal = false;
    public int portalTimer = 0;
    public float portalAnimTime = 0.0f;
    public float prevPortalAnimTime = 0.0f;
    protected int temperature = 20;
    protected float temperatureSaturation = 1.0f;
    private int tickTimer;
    private float exhaustionLevel;
    private int lastTemperate = 20;
    private BlockPos hotSource;
    public ItemStack usingItem = ItemStack.EMPTY;

    public void addExhaustion(float exhaution) {
        this.exhaustionLevel = Math.min(this.exhaustionLevel + exhaution, 40.0f);
    }

    public void addHot(int temprature, float saturation) {
        this.temperature = Math.min(temprature + this.temperature, 20);
        this.temperatureSaturation = Math.min(this.temperatureSaturation + (float)temprature * saturation * 2.0f, (float)this.temperature);
    }

    public static FrostLivingCapability get(Entity entity) {
        return (FrostLivingCapability)entity.getData(FrostAttachs.FROST_LIVING);
    }

    public void tick(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.handlePortal(player);
            this.handleAnimations(player);
        }
        if (!(entity.level().dimension() != FrostDimensions.FROSTREALM_LEVEL || entity.getType().is(FrostTags.EntityTypes.COLD_WEATHER_IMMUNE) || entity instanceof Player && ((Player)entity).isCreative() || entity.isSpectator() || entity.hasEffect(FrostEffects.COLD_RESISTANCE))) {
            Holder biome;
            FrostWeatherSavedData cap;
            Difficulty difficulty = entity.level().getDifficulty();
            this.lastTemperate = this.temperature;
            this.hotSourceTick(entity);
            float tempAffect = this.tempModifier(entity, 2.0f);
            if (entity.isInFluidType(FrostFluidTypes.HOT_SPRING.get())) {
                tempAffect *= 0.1f;
                if (entity.tickCount % 80 == 0) {
                    this.temperatureSaturation = Math.min(this.temperatureSaturation + 0.05f, 1.0f);
                    this.temperature = Math.min(this.temperature + 1, 20);
                }
            }
            if (this.hotSource == null && (cap = FrostWeatherSavedData.get(entity.level())) != null && this.isAffectRain(entity) && cap.isWeatherActive() && cap.getFrostWeather() == FrostWeathers.BLIZZARD.get()) {
                this.addExhaustion(0.005f * tempAffect);
            }
            if (!(biome = entity.level().getBiome(entity.blockPosition())).is(FrostTags.Biomes.HOT_BIOME)) {
                if (this.hotSource == null) {
                    this.addExhaustion(tempAffect * 0.0025f);
                    if (this.exhaustionLevel > 4.0f) {
                        this.exhaustionLevel -= 4.0f;
                        if (this.temperatureSaturation > 0.0f) {
                            this.temperatureSaturation = Math.max(this.temperatureSaturation - 0.1f, 0.0f);
                        } else if (difficulty != Difficulty.PEACEFUL) {
                            this.temperature = Math.max(this.temperature - 1, 0);
                        }
                    }
                }
                if (entity.getType().is(EntityTypeTags.FREEZE_HURTS_EXTRA_TYPES)) {
                    this.temperature = Math.max(this.temperature - 1, 0);
                    this.temperatureSaturation = 0.0f;
                    entity.setTicksFrozen(Mth.clamp((int)(entity.getTicksFrozen() + 4), (int)0, (int)200));
                } else if (this.temperature <= 0) {
                    entity.setTicksFrozen(Mth.clamp((int)(entity.getTicksFrozen() + 4), (int)0, (int)200));
                    this.tickTimer = 0;
                } else {
                    this.tickTimer = 0;
                }
            } else {
                if (entity.tickCount % 80 == 0) {
                    this.temperatureSaturation = Math.min(this.temperatureSaturation + 0.05f, 1.0f);
                    this.temperature = Math.min(this.temperature + 1, 20);
                }
                this.exhaustionLevel = 0.0f;
            }
        } else {
            if (entity.tickCount % 20 == 0) {
                this.temperatureSaturation = Math.min(this.temperatureSaturation + 0.1f, 1.0f);
                this.temperature = Math.min(this.temperature + 1, 20);
            }
            this.exhaustionLevel = 0.0f;
        }
        if (entity.tickCount % 20 == 0 && !entity.level().isClientSide()) {
            ChangedColdMessage message = new ChangedColdMessage((Entity)entity, this.temperature, this.temperatureSaturation);
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private float tempModifier(LivingEntity entity, float tempAffect) {
        Difficulty difficulty = entity.level().getDifficulty();
        if (difficulty == Difficulty.HARD) {
            tempAffect *= 1.5f;
        }
        if (difficulty == Difficulty.EASY) {
            tempAffect *= 0.75f;
        }
        if (entity.isInWaterOrRain()) {
            tempAffect *= 4.0f;
        }
        if (!entity.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            tempAffect *= 0.85f;
        }
        if (!entity.getItemBySlot(EquipmentSlot.HEAD).is(ItemTags.FREEZE_IMMUNE_WEARABLES)) {
            tempAffect *= 0.65f;
        }
        if (!entity.getItemBySlot(EquipmentSlot.CHEST).isEmpty()) {
            tempAffect *= 0.75f;
        }
        if (entity.getItemBySlot(EquipmentSlot.CHEST).is(ItemTags.FREEZE_IMMUNE_WEARABLES)) {
            tempAffect *= 0.5f;
        }
        if (!entity.getItemBySlot(EquipmentSlot.LEGS).isEmpty()) {
            tempAffect *= 0.75f;
        }
        if (entity.getItemBySlot(EquipmentSlot.LEGS).is(ItemTags.FREEZE_IMMUNE_WEARABLES)) {
            tempAffect *= 0.55f;
        }
        if (!entity.getItemBySlot(EquipmentSlot.FEET).isEmpty()) {
            tempAffect *= 0.8f;
        }
        if (!entity.getItemBySlot(EquipmentSlot.FEET).is(ItemTags.FREEZE_IMMUNE_WEARABLES)) {
            tempAffect *= 0.6f;
        }
        return tempAffect;
    }

    private void handleAnimations(Player player) {
        IItemAnimation animation;
        Item item;
        if (this.usingItem != null && !this.usingItem.isEmpty() && player.isUsingItem() && this.usingItem.getItem() != player.getUseItem().getItem()) {
            item = this.usingItem.getItem();
            if (item instanceof IItemAnimation) {
                animation = (IItemAnimation)item;
                animation.onEntityStopAnimation((LivingEntity)player);
            }
            this.usingItem = null;
        }
        if (this.usingItem != null && !this.usingItem.isEmpty() && this.usingItem.getItem() != player.getItemBySlot(EquipmentSlot.MAINHAND).getItem()) {
            item = this.usingItem.getItem();
            if (item instanceof IItemAnimation) {
                animation = (IItemAnimation)item;
                animation.onEntityStopAnimation((LivingEntity)player);
            }
            this.usingItem = null;
        }
    }

    private void hotSourceTick(LivingEntity entity) {
        if (this.hotSource != null && (!this.hotSource.closerThan((Vec3i)entity.blockPosition(), 3.46) || !entity.level().getBlockState(this.hotSource).is(FrostTags.Blocks.HOT_SOURCE) || entity.level().getBlockState(this.hotSource).hasProperty((Property)BlockStateProperties.LIT) && ((Boolean)entity.level().getBlockState(this.hotSource).getValue((Property)BlockStateProperties.LIT)).booleanValue())) {
            this.hotSource = null;
        }
        if (this.hotSource == null) {
            int heatRange = 2;
            int entityPosX = (int)entity.getX();
            int entityPosY = (int)entity.getY();
            int entityPosZ = (int)entity.getZ();
            if (entity.tickCount % 20 == 0) {
                for (int hX = entityPosX - heatRange; hX <= entityPosX + heatRange; ++hX) {
                    for (int hY = entityPosY - 2; hY <= entityPosY; ++hY) {
                        for (int hZ = entityPosZ - heatRange; hZ <= entityPosZ + heatRange; ++hZ) {
                            if (!entity.level().getBlockState(new BlockPos(hX, hY, hZ)).is(FrostTags.Blocks.HOT_SOURCE)) continue;
                            this.hotSource = new BlockPos(hX, hY, hZ);
                        }
                    }
                }
            }
        }
        if (this.hotSource != null && this.hotSource.closerThan((Vec3i)entity.blockPosition(), 3.46) && entity.tickCount % 20 == 0) {
            this.temperatureSaturation = Math.min(this.temperatureSaturation + 0.1f, 1.0f);
            this.temperature = Math.min(this.temperature + 1, 20);
        }
    }

    private boolean isAffectRain(LivingEntity entity) {
        BlockPos blockpos = entity.blockPosition();
        return entity.level().canSeeSky(blockpos) && entity.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockpos).getY() <= blockpos.getY();
    }

    public int getTemperatureLevel() {
        return this.temperature;
    }

    public float getSaturationLevel() {
        return this.temperatureSaturation;
    }

    public void setTemperatureLevel(int temperature) {
        this.temperature = temperature;
    }

    public void setSaturation(float saturation) {
        this.temperatureSaturation = saturation;
    }

    private void playPortalSound(Minecraft mc) {
        if (mc.player != null) {
            mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forLocalAmbience((SoundEvent)SoundEvents.PORTAL_TRIGGER, (float)(mc.player.getRandom().nextFloat() * 0.4f + 0.8f), (float)0.25f));
        }
    }

    public void setInPortal(boolean inPortal) {
        this.isInsidePortal = inPortal;
    }

    public boolean isInsidePortal() {
        return this.isInsidePortal;
    }

    public void setPortalTimer(int timer) {
        this.portalTimer = timer;
    }

    public int getPortalTimer() {
        return this.portalTimer;
    }

    public float getPortalAnimTime() {
        return this.portalAnimTime;
    }

    public float getPrevPortalAnimTime() {
        return this.prevPortalAnimTime;
    }

    public void handlePortal(Player player) {
        if (player.level().isClientSide()) {
            this.prevPortalAnimTime = this.portalAnimTime;
            if (this.isInsidePortal()) {
                if (!(Minecraft.getInstance().screen == null || Minecraft.getInstance().screen.isPauseScreen() || Minecraft.getInstance().screen instanceof DeathScreen || Minecraft.getInstance().screen instanceof WinScreen)) {
                    if (Minecraft.getInstance().screen instanceof AbstractContainerScreen) {
                        player.closeContainer();
                    }
                    Minecraft.getInstance().setScreen(null);
                }
                if (this.portalAnimTime == 0.0f) {
                    ClientUtils.playPortalSound(player);
                }
            }
        }
        if (this.isInsidePortal()) {
            ++this.portalTimer;
            if (player.level().isClientSide()) {
                this.portalAnimTime += 0.0125f;
                if (this.getPortalAnimTime() > 1.0f) {
                    this.portalAnimTime = 1.0f;
                }
            }
            this.isInsidePortal = false;
        } else {
            if (player.level().isClientSide()) {
                if (this.getPortalAnimTime() > 0.0f) {
                    this.portalAnimTime -= 0.05f;
                }
                if (this.getPortalAnimTime() < 0.0f) {
                    this.portalAnimTime = 0.0f;
                }
            }
            if (this.getPortalTimer() > 0) {
                this.portalTimer -= 4;
            }
        }
    }

    public boolean isColdBody() {
        return this.temperature < 12;
    }

    public void serialize(ValueOutput valueOutput) {
        valueOutput.putInt("Temperature", this.temperature);
        valueOutput.putFloat("TemperatureSaturation", this.temperatureSaturation);
        valueOutput.putFloat("TemperatureExhaustion", this.exhaustionLevel);
    }

    public void deserialize(ValueInput nbt) {
        this.temperature = nbt.getIntOr("Temperature", 20);
        this.temperatureSaturation = nbt.getFloatOr("TemperatureSaturation", 1.0f);
        this.exhaustionLevel = nbt.getFloatOr("TemperatureExhaustion", 0.0f);
    }
}

