/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.capability;

import baguchan.frostrealm.capability.FrostWeatherSavedData;
import baguchan.frostrealm.data.resource.FrostDimensions;
import baguchan.frostrealm.message.ChangeWeatherMessage;
import baguchan.frostrealm.registry.FrostWeathers;
import baguchan.frostrealm.utils.BlizzardUtils;
import baguchan.frostrealm.weather.FrostWeather;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class FrostWeatherManager {
    private static float weatherLevel;
    private static float oWeatherLevel;
    private static float normalLevel;
    private static float oNormalLevel;
    private static float unstableLevel;
    private static float auroraLevel;
    private static FrostWeather frostWeather;
    private static FrostWeather prevFrostWeather;

    public static void tick(Level level) {
        if (!level.isClientSide() && level.dimension() == FrostDimensions.FROSTREALM_LEVEL) {
            FrostWeatherSavedData frostWeatherData = FrostWeatherSavedData.get(level);
            if (frostWeatherData.isWeatherActive()) {
                if (frostWeatherData.getFrostWeather() == FrostWeathers.PURPLE_FOG.get()) {
                    frostWeatherData.setUnstableLevel(0.0f);
                }
                frostWeatherData.setWetherTime(frostWeatherData.getWeatherTime() - 1);
            } else if (frostWeatherData.isWeatherCooldownActive()) {
                frostWeatherData.setFrostWeather(FrostWeathers.NOPE.get());
                if (frostWeatherData.getWeatherTime() <= 0) {
                    frostWeatherData.setUnstableLevel((float)((double)frostWeatherData.getUnstableLevel() + level.random.nextDouble() * (double)0.1f));
                    frostWeatherData.setAuroraLevel((float)((double)(frostWeatherData.getAuroraLevel() + 0.1f) + level.random.nextDouble() * (double)0.1f));
                    FrostWeather frostWeather = BlizzardUtils.makeRandomWeather(level.random, frostWeatherData.getUnstableLevel());
                    frostWeatherData.setFrostWeather(frostWeather);
                    ChangeWeatherMessage message = new ChangeWeatherMessage(frostWeather);
                    PacketDistributor.sendToPlayersInDimension((ServerLevel)((ServerLevel)level), (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
                    frostWeatherData.setWetherTime((level.random.nextInt(5) + 5) * 60 * 20);
                    frostWeatherData.setDirty();
                }
            } else {
                frostWeatherData.setWetherTime((level.random.nextInt(5) + 10) * 60 * 20);
                frostWeatherData.setFrostWeather(FrostWeathers.NOPE.get());
                ChangeWeatherMessage message = new ChangeWeatherMessage(FrostWeathers.NOPE.get());
                PacketDistributor.sendToPlayersInDimension((ServerLevel)((ServerLevel)level), (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
                frostWeatherData.setDirty();
            }
        }
    }

    public static void clientTick(ClientLevel level) {
        if (level.isClientSide()) {
            FrostWeatherManager.setoWeatherLevel(Mth.clamp((float)FrostWeatherManager.getWeatherLevel(), (float)0.0f, (float)1.0f));
            FrostWeatherManager.setWeatherLevel(FrostWeatherManager.getWeatherLevel() + 0.02f);
            if (FrostWeatherManager.getWeatherLevel() == 1.0f && prevFrostWeather != frostWeather) {
                prevFrostWeather = frostWeather;
            }
            oNormalLevel = normalLevel;
            normalLevel = !frostWeather.getBadWeather() ? Mth.clamp((float)(normalLevel + 0.02f), (float)0.0f, (float)1.0f) : Mth.clamp((float)(normalLevel - 0.02f), (float)0.0f, (float)1.0f);
        }
    }

    public static float getoWeatherLevel() {
        return oWeatherLevel;
    }

    public static float getUnstableLevel() {
        return unstableLevel;
    }

    public static float getWeatherLevel() {
        return weatherLevel;
    }

    public static void setAuroraLevel(float auroraLevel) {
        FrostWeatherManager.auroraLevel = auroraLevel;
    }

    public static float getAuroraLevel() {
        return auroraLevel;
    }

    public static void setUnstableLevel(float unstableLevel) {
        FrostWeatherManager.unstableLevel = unstableLevel;
    }

    public static float getWeatherLevel(float level) {
        return Mth.lerp((float)level, (float)oWeatherLevel, (float)weatherLevel);
    }

    public static float getNormalWeatherLevel(float level) {
        return Mth.lerp((float)level, (float)oNormalLevel, (float)normalLevel);
    }

    public static void setWeatherLevel(float level) {
        float f;
        weatherLevel = f = Mth.clamp((float)level, (float)0.0f, (float)1.0f);
    }

    public static void setoWeatherLevel(float oWeatherLevel) {
        float f;
        FrostWeatherManager.oWeatherLevel = f = Mth.clamp((float)oWeatherLevel, (float)0.0f, (float)1.0f);
    }

    public static boolean isBadWeatherActive(Level level) {
        FrostWeatherSavedData frostWeatherData = FrostWeatherSavedData.get(level);
        return frostWeatherData != null && frostWeatherData.isWeatherActive();
    }

    public static FrostWeather getFrostWeather() {
        return frostWeather;
    }

    public static void setFrostWeather(FrostWeather weather) {
        frostWeather = weather;
    }

    public static FrostWeather getPrevFrostWeather() {
        return prevFrostWeather;
    }

    static {
        frostWeather = FrostWeathers.NOPE.get();
        prevFrostWeather = FrostWeathers.NOPE.get();
    }
}

