/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.capability;

import baguchan.frostrealm.data.resource.FrostDimensions;
import baguchan.frostrealm.message.ChangeWeatherMessage;
import baguchan.frostrealm.registry.FrostWeathers;
import baguchan.frostrealm.utils.BlizzardUtils;
import baguchan.frostrealm.weather.FrostWeather;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.neoforge.network.PacketDistributor;

public class FrostWeatherSavedData
extends SavedData {
    public static final Codec<FrostWeatherSavedData> CODEC = RecordCodecBuilder.create(p_400930_ -> p_400930_.group((App)FrostWeathers.getRegistry().byNameCodec().fieldOf("frost_weather").forGetter(FrostWeatherSavedData::getFrostWeather), (App)Codec.INT.fieldOf("weather_time").forGetter(p_400933_ -> p_400933_.weatherTime), (App)Codec.INT.fieldOf("weather_cooldown").forGetter(p_400933_ -> p_400933_.weatherCooldown), (App)Codec.FLOAT.fieldOf("unstable_level").forGetter(p_400933_ -> Float.valueOf(p_400933_.unstableLevel)), (App)Codec.FLOAT.fieldOf("aurora_level").forGetter(p_400933_ -> Float.valueOf(p_400933_.auroraLevel))).apply((Applicative)p_400930_, FrostWeatherSavedData::new));
    private int weatherTime;
    private int weatherCooldown;
    private float unstableLevel;
    private float auroraLevel;
    private int tick;
    private static Map<Level, FrostWeatherSavedData> dataMap = new HashMap<Level, FrostWeatherSavedData>();
    public static final SavedDataType<FrostWeatherSavedData> TYPE = new SavedDataType("frost_weather_data", FrostWeatherSavedData::new, CODEC);
    private FrostWeather frostWeather;

    public FrostWeatherSavedData() {
        this(FrostWeathers.NOPE.get(), 0, 20000, 0.0f, 1.0f);
    }

    public FrostWeatherSavedData(FrostWeather frostWeather, int weatherTime, int weatherCooldown, float unstableLevel, float auroraLevel) {
        this.frostWeather = frostWeather;
        this.weatherTime = weatherTime;
        this.weatherCooldown = weatherCooldown;
        this.unstableLevel = unstableLevel;
        this.auroraLevel = auroraLevel;
    }

    public void setUnstableLevel(float unstableLevel) {
        this.unstableLevel = Mth.clamp((float)unstableLevel, (float)0.0f, (float)1.0f);
        if (this.unstableLevel != unstableLevel) {
            this.setDirty();
        }
    }

    public float getUnstableLevel() {
        return this.unstableLevel;
    }

    public void setAuroraLevel(float auroraLevel) {
        this.auroraLevel = Mth.clamp((float)auroraLevel, (float)0.0f, (float)1.0f);
        if (this.auroraLevel != auroraLevel) {
            this.setDirty();
        }
    }

    public float getAuroraLevel() {
        return this.auroraLevel;
    }

    public boolean isWeatherActive() {
        return this.weatherTime > 0;
    }

    public int getWeatherTime() {
        return this.weatherTime;
    }

    public void setWetherTime(int time) {
        this.weatherTime = time;
    }

    public void setFrostWeather(FrostWeather frostWeather) {
        this.frostWeather = frostWeather;
        this.setDirty();
    }

    public FrostWeather getFrostWeather() {
        return this.frostWeather;
    }

    public static FrostWeatherSavedData get(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            FrostWeatherSavedData fromMap = dataMap.get(serverLevel);
            if (fromMap == null) {
                DimensionDataStorage storage = serverLevel.getDataStorage();
                FrostWeatherSavedData data = (FrostWeatherSavedData)storage.computeIfAbsent(TYPE);
                if (data != null) {
                    data.setDirty();
                }
                dataMap.put(world, data);
                return data;
            }
            return fromMap;
        }
        return null;
    }

    public void tick(Level level) {
        if (!level.isClientSide() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ++this.tick;
            if (level.dimension() == FrostDimensions.FROSTREALM_LEVEL) {
                if (this.isWeatherActive()) {
                    if (this.frostWeather == FrostWeathers.PURPLE_FOG.get()) {
                        this.unstableLevel = 0.0f;
                        this.setDirty();
                    }
                    this.setWetherTime(this.getWeatherTime() - 1);
                } else if (this.isWeatherCooldownActive()) {
                    this.setWeatherCooldown(this.getWeatherCooldown() - 1);
                    if (this.getWeatherCooldown() <= 0) {
                        this.unstableLevel += (float)(level.random.nextDouble() * (double)0.1f);
                        FrostWeather frostWeather = BlizzardUtils.makeRandomWeather(level.random, this.unstableLevel);
                        this.setFrostWeather(frostWeather);
                        ChangeWeatherMessage message = new ChangeWeatherMessage(frostWeather);
                        PacketDistributor.sendToPlayersInDimension((ServerLevel)serverLevel, (CustomPacketPayload)message, (CustomPacketPayload[])new CustomPacketPayload[0]);
                        this.setWetherTime((level.random.nextInt(5) + 5) * 60 * 20);
                        this.setDirty();
                    }
                } else {
                    this.setWeatherCooldown((level.random.nextInt(5) + 10) * 60 * 20);
                    this.setFrostWeather(FrostWeathers.NOPE.get());
                    ChangeWeatherMessage message2 = new ChangeWeatherMessage(FrostWeathers.NOPE.get());
                    PacketDistributor.sendToPlayersInDimension((ServerLevel)serverLevel, (CustomPacketPayload)message2, (CustomPacketPayload[])new CustomPacketPayload[0]);
                    this.setDirty();
                }
            }
            if (this.tick % 200 == 0) {
                this.setDirty();
            }
        }
    }

    public void setWeatherCooldown(int weatherCooldown) {
        this.weatherCooldown = weatherCooldown;
    }

    public int getWeatherCooldown() {
        return this.weatherCooldown;
    }

    public boolean isWeatherCooldownActive() {
        return FrostWeathers.NOPE.get() == this.frostWeather;
    }
}

