/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client;

import baguchan.frostrealm.FrostRealm;
import baguchan.frostrealm.block.FrostPortalBlock;
import baguchan.frostrealm.capability.FrostLivingCapability;
import baguchan.frostrealm.client.FrostModelLayers;
import baguchan.frostrealm.client.FrostRealmRenderInfo;
import baguchan.frostrealm.client.FrostRenderPipelines;
import baguchan.frostrealm.client.FrostRenderType;
import baguchan.frostrealm.client.event.ClientFogEvent;
import baguchan.frostrealm.client.model.AstraBallModel;
import baguchan.frostrealm.client.model.CrystalFoxModel;
import baguchan.frostrealm.client.model.FerretModel;
import baguchan.frostrealm.client.model.FrostBoarModel;
import baguchan.frostrealm.client.model.FrostWraithModel;
import baguchan.frostrealm.client.model.GokkurModel;
import baguchan.frostrealm.client.model.LesserWarriorModel;
import baguchan.frostrealm.client.model.MarmotModel;
import baguchan.frostrealm.client.model.RootDeerModel;
import baguchan.frostrealm.client.model.SealModel;
import baguchan.frostrealm.client.model.SeekerModel;
import baguchan.frostrealm.client.model.SilkMoonModel;
import baguchan.frostrealm.client.model.SilkMoonWormModel;
import baguchan.frostrealm.client.model.SnowMoleModel;
import baguchan.frostrealm.client.model.SnowPileQuailModel;
import baguchan.frostrealm.client.model.VenochemModel;
import baguchan.frostrealm.client.model.VenomBallModel;
import baguchan.frostrealm.client.model.WolfflueModel;
import baguchan.frostrealm.client.model.YetiFurArmorModel;
import baguchan.frostrealm.client.model.YetiModel;
import baguchan.frostrealm.client.overlay.FrostOverlay;
import baguchan.frostrealm.client.render.AstraBallRenderer;
import baguchan.frostrealm.client.render.CrystalFoxRenderer;
import baguchan.frostrealm.client.render.FerretRenderer;
import baguchan.frostrealm.client.render.FlyingBlockRenderer;
import baguchan.frostrealm.client.render.FrostBoarRenderer;
import baguchan.frostrealm.client.render.FrostWraithRenderer;
import baguchan.frostrealm.client.render.GokkurRenderer;
import baguchan.frostrealm.client.render.LesserWarriorRenderer;
import baguchan.frostrealm.client.render.MarmotRenderer;
import baguchan.frostrealm.client.render.RootDeerRenderer;
import baguchan.frostrealm.client.render.SealRenderer;
import baguchan.frostrealm.client.render.SeekerRenderer;
import baguchan.frostrealm.client.render.SilkMoonRenderer;
import baguchan.frostrealm.client.render.SilkMoonWormRenderer;
import baguchan.frostrealm.client.render.SnowMoleRenderer;
import baguchan.frostrealm.client.render.SnowPileQuailRenderer;
import baguchan.frostrealm.client.render.UnderGokkurRenderer;
import baguchan.frostrealm.client.render.VenochemRenderer;
import baguchan.frostrealm.client.render.VenomBallRenderer;
import baguchan.frostrealm.client.render.WolfflueRenderer;
import baguchan.frostrealm.client.render.YetiRenderer;
import baguchan.frostrealm.client.screen.AuroraInfuserScreen;
import baguchan.frostrealm.item.GlimmerRockItem;
import baguchan.frostrealm.item.YetiFurArmorItem;
import baguchan.frostrealm.registry.FrostAttachs;
import baguchan.frostrealm.registry.FrostBlocks;
import baguchan.frostrealm.registry.FrostEntities;
import baguchan.frostrealm.registry.FrostFluidTypes;
import baguchan.frostrealm.registry.FrostItems;
import baguchan.frostrealm.registry.FrostMenuTypes;
import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterRenderBuffersEvent;
import net.neoforged.neoforge.client.event.RegisterRenderPipelinesEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.GuiLayer;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.client.renderstate.RegisterRenderStateModifiersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.FluidType;

@EventBusSubscriber(modid="frostrealm", value={Dist.CLIENT})
public class ClientRegistrar {
    public static final CubeDeformation OUTER_ARMOR_DEFORMATION = new CubeDeformation(1.0f);
    public static final CubeDeformation INNER_ARMOR_DEFORMATION = new CubeDeformation(0.5f);
    public static ContextKey<Boolean> HOLD_SPEAR_KEY = new ContextKey(ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"hold_spear_id"));

    @SubscribeEvent
    public static void registerLayer(RegisterRenderStateModifiersEvent event) {
    }

    @SubscribeEvent
    public static void registerClientExtend(RegisterClientExtensionsEvent event) {
        event.registerItem((IClientItemExtensions)new GlimmerRockItem.ItemRender(), new Item[]{(Item)FrostItems.GLIMMERROCK.get(), (Item)FrostItems.CRYONITE_CREAM.get()});
        event.registerItem((IClientItemExtensions)YetiFurArmorItem.ArmorRender.INSTANCE, new Item[]{(Item)FrostItems.YETI_FUR_BOOTS.get(), (Item)FrostItems.YETI_FUR_LEGGINGS.get(), (Item)FrostItems.YETI_FUR_CHESTPLATE.get(), (Item)FrostItems.YETI_FUR_HELMET.get()});
        event.registerItem((IClientItemExtensions)YetiFurArmorItem.ArmorRender.INSTANCE, new Item[]{(Item)FrostItems.FROST_BOAR_FUR_BOOTS.get(), (Item)FrostItems.FROST_BOAR_FUR_LEGGINGS.get(), (Item)FrostItems.FROST_BOAR_FUR_CHESTPLATE.get(), (Item)FrostItems.FROST_BOAR_FUR_HELMET.get()});
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private static final ResourceLocation TEXTURE_STILL = ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"block/hot_spring_still");
            private static final ResourceLocation TEXTURE_FLOW = ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"block/hot_spring_flow");
            private static final ResourceLocation TEXTURE_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"textures/block/hot_spring_still_overlay.png");

            public ResourceLocation getStillTexture() {
                return TEXTURE_STILL;
            }

            public ResourceLocation getFlowingTexture() {
                return TEXTURE_FLOW;
            }

            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return TEXTURE_OVERLAY;
            }
        }, new FluidType[]{FrostFluidTypes.HOT_SPRING.get()});
    }

    @SubscribeEvent
    public static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)FrostEntities.MARMOT.get(), MarmotRenderer::new);
        event.registerEntityRenderer((EntityType)FrostEntities.SNOWPILE_QUAIL.get(), SnowPileQuailRenderer::new);
        event.registerEntityRenderer((EntityType)FrostEntities.CRYSTAL_FOX.get(), CrystalFoxRenderer::new);
        event.registerEntityRenderer((EntityType)FrostEntities.SNOW_MOLE.get(), SnowMoleRenderer::new);
        event.registerEntityRenderer((EntityType)FrostEntities.WOLFFLUE.get(), WolfflueRenderer::new);
        event.registerEntityRenderer((EntityType)FrostEntities.FERRET.get(), FerretRenderer::new);
        event.registerEntityRenderer((EntityType)FrostEntities.YETI.get(), YetiRenderer::new);
        event.registerEntityRenderer((EntityType)FrostEntities.FROST_WRAITH.get(), FrostWraithRenderer::new);
        event.registerEntityRenderer((EntityType)FrostEntities.ASTRA_BALL.get(), AstraBallRenderer::new);
        event.registerEntityRenderer((EntityType)FrostEntities.FROST_BOAR.get(), FrostBoarRenderer::new);
        event.registerEntityRenderer((EntityType)FrostEntities.LESSER_WARRIOR.get(), LesserWarriorRenderer::new);
        event.registerEntityRenderer((EntityType)FrostEntities.SEAL.get(), SealRenderer::new);
        event.registerEntityRenderer((EntityType)FrostEntities.VENOM_BALL.get(), VenomBallRenderer::new);
        event.registerEntityRenderer((EntityType)FrostEntities.VENOCHEM.get(), VenochemRenderer::new);
        event.registerEntityRenderer((EntityType)FrostEntities.GOKKUR.get(), GokkurRenderer::new);
        event.registerEntityRenderer((EntityType)FrostEntities.UNDER_GOKKUR.get(), UnderGokkurRenderer::new);
        event.registerEntityRenderer((EntityType)FrostEntities.ROOT_DEER.get(), RootDeerRenderer::new);
        event.registerEntityRenderer((EntityType)FrostEntities.FLYING_BLOCK.get(), FlyingBlockRenderer::new);
        event.registerEntityRenderer((EntityType)FrostEntities.SILK_MOON_WORM.get(), SilkMoonWormRenderer::new);
        event.registerEntityRenderer((EntityType)FrostEntities.SILK_MOON.get(), SilkMoonRenderer::new);
        event.registerEntityRenderer((EntityType)FrostEntities.SEEKER.get(), SeekerRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayerDefinition(EntityRenderersEvent.RegisterLayerDefinitions event) {
        LayerDefinition layerdefinition1 = LayerDefinition.create((MeshDefinition)HumanoidModel.createMesh((CubeDeformation)OUTER_ARMOR_DEFORMATION, (float)0.0f), (int)64, (int)32);
        LayerDefinition layerdefinition3 = LayerDefinition.create((MeshDefinition)HumanoidModel.createMesh((CubeDeformation)INNER_ARMOR_DEFORMATION, (float)0.0f), (int)64, (int)32);
        event.registerLayerDefinition(FrostModelLayers.YETI, YetiModel::createBodyLayer);
        event.registerLayerDefinition(FrostModelLayers.FROST_WRAITH, FrostWraithModel::createBodyLayer);
        event.registerLayerDefinition(FrostModelLayers.MARMOT, MarmotModel::createBodyLayer);
        event.registerLayerDefinition(FrostModelLayers.SNOWPILE_QUAIL, SnowPileQuailModel::createBodyLayer);
        event.registerLayerDefinition(FrostModelLayers.WOLFFLUE, () -> WolfflueModel.createBodyLayer(new CubeDeformation(0.0f)));
        event.registerLayerDefinition(FrostModelLayers.WOLFFLUE_BABY, () -> WolfflueModel.createBodyLayer(new CubeDeformation(0.0f)).apply(WolfModel.BABY_TRANSFORMER));
        event.registerLayerDefinition(FrostModelLayers.WOLFFLUE_ARMOR, () -> WolfflueModel.createBodyLayer(new CubeDeformation(0.2f)));
        event.registerLayerDefinition(FrostModelLayers.WOLFFLUE_BABY_ARMOR, () -> WolfflueModel.createBodyLayer(new CubeDeformation(0.2f)).apply(WolfModel.BABY_TRANSFORMER));
        event.registerLayerDefinition(FrostModelLayers.WOLFFLUE_SADDLE, () -> WolfflueModel.createBodyLayer(new CubeDeformation(0.21f)));
        event.registerLayerDefinition(FrostModelLayers.WOLFFLUE_BABY_SADDLE, () -> WolfflueModel.createBodyLayer(new CubeDeformation(0.21f)).apply(WolfModel.BABY_TRANSFORMER));
        event.registerLayerDefinition(FrostModelLayers.FERRET, FerretModel::createBodyLayer);
        event.registerLayerDefinition(FrostModelLayers.CRYSTAL_FOX, CrystalFoxModel::createBodyLayer);
        event.registerLayerDefinition(FrostModelLayers.SNOW_MOLE, SnowMoleModel::createBodyLayer);
        event.registerLayerDefinition(FrostModelLayers.ASTRA_BALL, AstraBallModel::createBodyLayer);
        event.registerLayerDefinition(FrostModelLayers.FROST_BOAR, FrostBoarModel::createBodyLayer);
        event.registerLayerDefinition(FrostModelLayers.LESSER_WARRIOR, LesserWarriorModel::createBodyLayer);
        event.registerLayerDefinition(FrostModelLayers.SEAL, SealModel::createBodyLayer);
        event.registerLayerDefinition(FrostModelLayers.GOKKUR, GokkurModel::createBodyLayer);
        event.registerLayerDefinition(FrostModelLayers.VENOCHEM, VenochemModel::createBodyLayer);
        event.registerLayerDefinition(FrostModelLayers.VENOM_BALL, VenomBallModel::createBodyLayer);
        event.registerLayerDefinition(FrostModelLayers.ROOT_DEER, RootDeerModel::createBodyLayer);
        event.registerLayerDefinition(FrostModelLayers.SILK_MOON, SilkMoonModel::createBodyLayer);
        event.registerLayerDefinition(FrostModelLayers.SILK_MOON_WORM, SilkMoonWormModel::createBodyLayer);
        event.registerLayerDefinition(FrostModelLayers.SEEKER, SeekerModel::createBodyLayer);
        event.registerLayerDefinition(FrostModelLayers.YETI_FUR_ARMOR_INNER, () -> YetiFurArmorModel.createBodyLayer(INNER_ARMOR_DEFORMATION));
        event.registerLayerDefinition(FrostModelLayers.YETI_FUR_ARMOR_OUTER, () -> YetiFurArmorModel.createBodyLayer(OUTER_ARMOR_DEFORMATION));
        event.registerLayerDefinition(FrostModelLayers.FROST_BEASTER_INNER_ARMOR, () -> layerdefinition3);
        event.registerLayerDefinition(FrostModelLayers.FROST_BEASTER_OUTER_ARMOR, () -> layerdefinition1);
    }

    private static ModelLayerLocation createLocation(String p_171301_, String p_171302_) {
        return new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)p_171301_), p_171302_);
    }

    public static void renderTileEntity() {
    }

    public static void renderBlockColor() {
    }

    @SubscribeEvent
    public static void renderItemTint(RegisterColorHandlersEvent.Block event) {
        event.register((p_92621_, p_92622_, p_92623_, p_92624_) -> p_92622_ != null && p_92623_ != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)p_92622_, (BlockPos)p_92623_) : GrassColor.get((double)0.5, (double)1.0), new Block[]{(Block)FrostBlocks.FROZEN_GRASS_BLOCK.get()});
        event.register((p_92621_, p_92622_, p_92623_, p_92624_) -> p_92622_ != null && p_92623_ != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)p_92622_, (BlockPos)p_92623_) : GrassColor.get((double)0.5, (double)1.0), new Block[]{(Block)FrostBlocks.COLD_GRASS.get()});
        event.register((p_92621_, p_92622_, p_92623_, p_92624_) -> p_92622_ != null && p_92623_ != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)p_92622_, (BlockPos)p_92623_) : GrassColor.get((double)0.5, (double)1.0), new Block[]{(Block)FrostBlocks.COLD_TALL_GRASS.get()});
    }

    public static void setup(FMLCommonSetupEvent event) {
        NeoForge.EVENT_BUS.register((Object)new ClientFogEvent());
        ClientRegistrar.renderBlockColor();
    }

    @SubscribeEvent
    public static void renderHudEvent(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.FOOD_LEVEL, FrostRealm.prefix("frost_overlay"), (GuiLayer)new FrostOverlay());
        event.registerAboveAll(ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"frost_portal_overlay"), (guiGraphics, partialTicks) -> {
            Minecraft minecraft = Minecraft.getInstance();
            Window window = minecraft.getWindow();
            LocalPlayer player = minecraft.player;
            if (player != null) {
                ClientRegistrar.renderPortalOverlay(guiGraphics, minecraft, window, (FrostLivingCapability)player.getData(FrostAttachs.FROST_LIVING.get()), partialTicks);
            }
        });
    }

    private static void renderPortalOverlay(GuiGraphics guiGraphics, Minecraft minecraft, Window window, FrostLivingCapability handler, DeltaTracker partialTicks) {
        float timeInPortal = Mth.lerp((float)partialTicks.getGameTimeDeltaPartialTick(false), (float)handler.getPrevPortalAnimTime(), (float)handler.getPortalAnimTime());
        if (timeInPortal > 0.0f) {
            if (timeInPortal < 1.0f) {
                timeInPortal *= timeInPortal;
                timeInPortal *= timeInPortal;
                timeInPortal = timeInPortal * 0.8f + 0.2f;
            }
            int i = ARGB.white((float)timeInPortal);
            TextureAtlasSprite textureatlassprite = minecraft.getBlockRenderer().getBlockModelShaper().getParticleIcon(((FrostPortalBlock)((Object)FrostBlocks.FROST_PORTAL.get())).defaultBlockState());
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, textureatlassprite, 0, 0, guiGraphics.guiWidth(), guiGraphics.guiHeight(), i);
        }
    }

    @SubscribeEvent
    public static void registerDimensionEffect(RegisterDimensionSpecialEffectsEvent event) {
        FrostRealmRenderInfo renderInfo = new FrostRealmRenderInfo(DimensionSpecialEffects.SkyType.OVERWORLD, false, false);
        event.register(FrostRealm.prefix("renderer"), (DimensionSpecialEffects)renderInfo);
    }

    @SubscribeEvent
    public static void screenEvent(RegisterMenuScreensEvent event) {
        event.register(FrostMenuTypes.AURORA_INFUSER.get(), AuroraInfuserScreen::new);
    }

    @SubscribeEvent
    public static void registerRenderBuffers(RegisterRenderBuffersEvent event) {
        event.registerRenderBuffer(FrostRenderType.AURORA_GLINT);
        event.registerRenderBuffer(FrostRenderType.AURORA_GLINT_TRANSLUCENT);
        event.registerRenderBuffer(FrostRenderType.AURORA_ARMOR_ENTITY_GLINT);
        event.registerRenderBuffer(FrostRenderType.AURORA_ENTITY_GLINT);
        event.registerRenderBuffer(FrostRenderType.DARK_ITEM_RENDER_TYPE);
    }

    @SubscribeEvent
    public static void registerPipeline(RegisterRenderPipelinesEvent event) {
        event.registerPipeline(FrostRenderPipelines.DARK_OUTLINE_NO_CULL);
        event.registerPipeline(FrostRenderPipelines.DARK_OUTLINE_CULL);
        event.registerPipeline(FrostRenderPipelines.MYSTIC_NO_CULL);
        event.registerPipeline(FrostRenderPipelines.MYSTIC_CULL);
    }
}

