/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client;

import baguchan.frostrealm.capability.FrostWeatherManager;
import baguchan.frostrealm.client.sounds.FrostAmbientSoundsHandler;
import baguchan.frostrealm.registry.FrostParticleTypes;
import baguchan.frostrealm.registry.FrostWeathers;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.state.LevelRenderState;
import net.minecraft.client.renderer.state.SkyRenderState;
import net.minecraft.client.renderer.state.WeatherRenderState;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class FrostRealmRenderInfo
extends DimensionSpecialEffects {
    private static final ResourceLocation AURORA_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"textures/environment/aurora.png");
    public static final ResourceLocation ORB_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"textures/environment/frost_orb.png");
    private static final ResourceLocation END_SKY_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/environment/end_sky.png");
    private final FrostAmbientSoundsHandler soundsHandler;
    private final GpuBuffer auroraBuffer;
    private final GpuBuffer orbBuffer;
    private final RenderSystem.AutoStorageIndexBuffer quadIndices = RenderSystem.getSequentialBuffer((VertexFormat.Mode)VertexFormat.Mode.QUADS);
    @Nullable
    private AbstractTexture orbTexture;
    @Nullable
    private AbstractTexture auroraTexture;

    public FrostRealmRenderInfo(DimensionSpecialEffects.SkyType fogType, boolean brightenLightMap, boolean entityLightingBottomsLit) {
        super(fogType, brightenLightMap, entityLightingBottomsLit);
        this.soundsHandler = new FrostAmbientSoundsHandler(Minecraft.getInstance().getSoundManager());
        this.auroraBuffer = this.buildAurora();
        this.orbBuffer = this.buildOrbQuad();
    }

    protected void initTextures() {
        this.orbTexture = this.getTexture(ORB_LOCATION);
        this.auroraTexture = this.getTexture(AURORA_LOCATION);
    }

    private AbstractTexture getTexture(ResourceLocation p_449048_) {
        TextureManager texturemanager = Minecraft.getInstance().getTextureManager();
        AbstractTexture abstracttexture = texturemanager.getTexture(p_449048_);
        abstracttexture.setUseMipmaps(false);
        return abstracttexture;
    }

    public Vec3 getBrightnessDependentFogColor(Vec3 biomeFogColor, float daylight) {
        return biomeFogColor;
    }

    public boolean isFoggyAt(int p_108874_, int p_108875_) {
        return false;
    }

    public boolean renderClouds(LevelRenderState levelRenderState, Vec3 camPos, CloudStatus cloudStatus, int cloudColor, float cloudHeight, Matrix4f modelViewMatrix) {
        return true;
    }

    public boolean renderSky(LevelRenderState levelRenderState, SkyRenderState skyRenderState, Matrix4f modelViewMatrix, Runnable setupFog) {
        setupFog.run();
        return true;
    }

    private void renderOrb(float p_362331_, PoseStack p_361665_) {
        if (this.orbTexture != null) {
            Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
            matrix4fstack.pushMatrix();
            matrix4fstack.mul((Matrix4fc)p_361665_.last().pose());
            matrix4fstack.translate(0.0f, 100.0f, 0.0f);
            matrix4fstack.scale(30.0f, 1.0f, 30.0f);
            GpuBufferSlice gpubufferslice = RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)matrix4fstack, (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, p_362331_), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
            GpuTextureView gputextureview = Minecraft.getInstance().getMainRenderTarget().getColorTextureView();
            GpuTextureView gputextureview1 = Minecraft.getInstance().getMainRenderTarget().getDepthTextureView();
            GpuBuffer gpubuffer = this.quadIndices.getBuffer(6);
            try (RenderPass renderpass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Sky sun", gputextureview, OptionalInt.empty(), gputextureview1, OptionalDouble.empty());){
                renderpass.setPipeline(RenderPipelines.CELESTIAL);
                RenderSystem.bindDefaultUniforms((RenderPass)renderpass);
                renderpass.setUniform("DynamicTransforms", gpubufferslice);
                renderpass.bindSampler("Sampler0", this.orbTexture.getTextureView());
                renderpass.setVertexBuffer(0, this.orbBuffer);
                renderpass.setIndexBuffer(gpubuffer, this.quadIndices.type());
                renderpass.drawIndexed(0, 0, 6, 1);
            }
            matrix4fstack.popMatrix();
        }
    }

    public void renderAurora(PoseStack p_362809_, float weatherLevel) {
        if (this.auroraTexture != null && !(weatherLevel <= 0.001f)) {
            float f11 = weatherLevel;
            p_362809_.pushPose();
            Matrix4fStack matrix4fstack = RenderSystem.getModelViewStack();
            matrix4fstack.pushMatrix();
            matrix4fstack.mul((Matrix4fc)p_362809_.last().pose());
            GpuBufferSlice gpubufferslice = RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)matrix4fstack, (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, weatherLevel), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
            GpuTextureView gputextureview = Minecraft.getInstance().getMainRenderTarget().getColorTextureView();
            GpuTextureView gputextureview1 = Minecraft.getInstance().getMainRenderTarget().getDepthTextureView();
            GpuBuffer gpubuffer = this.quadIndices.getBuffer(6);
            try (RenderPass renderpass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Aurora", gputextureview, OptionalInt.empty(), gputextureview1, OptionalDouble.empty());){
                renderpass.setPipeline(RenderPipelines.CELESTIAL);
                RenderSystem.bindDefaultUniforms((RenderPass)renderpass);
                renderpass.setUniform("DynamicTransforms", gpubufferslice);
                renderpass.bindSampler("Sampler0", this.auroraTexture.getTextureView());
                renderpass.setVertexBuffer(0, this.auroraBuffer);
                renderpass.setIndexBuffer(gpubuffer, this.quadIndices.type());
                renderpass.draw(0, 18);
            }
            matrix4fstack.popMatrix();
            p_362809_.popPose();
        }
    }

    private GpuBuffer buildOrbQuad() {
        GpuBuffer gpubuffer;
        try (ByteBufferBuilder bytebufferbuilder = ByteBufferBuilder.exactlySized((int)(4 * DefaultVertexFormat.POSITION_TEX.getVertexSize()));){
            BufferBuilder bufferbuilder = new BufferBuilder(bytebufferbuilder, VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            Matrix4f matrix4f = new Matrix4f();
            bufferbuilder.addVertex(matrix4f, -1.0f, 0.0f, -1.0f).setUv(0.0f, 0.0f);
            bufferbuilder.addVertex(matrix4f, 1.0f, 0.0f, -1.0f).setUv(1.0f, 0.0f);
            bufferbuilder.addVertex(matrix4f, 1.0f, 0.0f, 1.0f).setUv(1.0f, 1.0f);
            bufferbuilder.addVertex(matrix4f, -1.0f, 0.0f, 1.0f).setUv(0.0f, 1.0f);
            try (MeshData meshdata = bufferbuilder.buildOrThrow();){
                gpubuffer = RenderSystem.getDevice().createBuffer(() -> "Orb quad", 40, meshdata.vertexBuffer());
            }
        }
        return gpubuffer;
    }

    private GpuBuffer buildAurora() {
        GpuBuffer gpubuffer;
        try (ByteBufferBuilder bytebufferbuilder = ByteBufferBuilder.exactlySized((int)(4 * DefaultVertexFormat.POSITION_TEX.getVertexSize()));){
            BufferBuilder bufferbuilder = new BufferBuilder(bytebufferbuilder, VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            Matrix4f matrix4f = new Matrix4f();
            float f12 = 160.0f;
            float f13 = 100.0f;
            bufferbuilder.addVertex(matrix4f, -f12, f13, -f12).setUv(0.0f, 0.0f);
            bufferbuilder.addVertex(matrix4f, f12, f13, -f12).setUv(1.0f, 0.0f);
            bufferbuilder.addVertex(matrix4f, f12, f13, f12).setUv(1.0f, 1.0f);
            bufferbuilder.addVertex(matrix4f, -f12, f13, f12).setUv(0.0f, 1.0f);
            try (MeshData meshdata = bufferbuilder.buildOrThrow();){
                gpubuffer = RenderSystem.getDevice().createBuffer(() -> "Sun quad", 40, meshdata.vertexBuffer());
            }
        }
        return gpubuffer;
    }

    public boolean renderSnowAndRain(LevelRenderState levelRenderState, WeatherRenderState weatherRenderState, MultiBufferSource bufferSource, Vec3 camPos) {
        return true;
    }

    public boolean tickRain(ClientLevel level, int ticks, Camera camera) {
        this.soundsHandler.tick();
        float f = FrostWeatherManager.getWeatherLevel(1.0f);
        if (!(f <= 0.0f) && FrostWeatherManager.getFrostWeather() == FrostWeathers.BLIZZARD.get()) {
            for (int i = 0; i < 2; ++i) {
                float z;
                float y;
                float x;
                if (level.random.nextInt(2) == 0 || !level.canSeeSky(BlockPos.containing((Position)new Vec3((double)((float)(camera.getPosition().x - (double)((x = level.getRandom().nextFloat() * 0.5f - level.getRandom().nextFloat()) * 36.0f))), (double)((float)(camera.getPosition().y + 8.0 + (double)((y = level.getRandom().nextFloat()) * 16.0f))), (double)((float)(camera.getPosition().z - (double)((z = level.getRandom().nextFloat() * 0.5f - level.getRandom().nextFloat()) * 36.0f))))))) continue;
                level.addParticle((ParticleOptions)FrostParticleTypes.SNOW.get(), camera.getPosition().x - (double)(x * 36.0f), camera.getPosition().y + 8.0 + (double)(y * 16.0f), camera.getPosition().z - (double)(z * 36.0f), (double)-0.2f, -0.5, (double)-0.2f);
            }
        }
        return true;
    }
}

