/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client;

import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class LivingEntityFlyingSoundInstance
extends AbstractTickableSoundInstance {
    protected final LivingEntity livingEntity;
    private static final WeakHashMap<Entity, SoundInstance> activeSounds = new WeakHashMap();

    public LivingEntityFlyingSoundInstance(LivingEntity livingEntity, SoundEvent soundEvent, SoundSource soundSource) {
        super(soundEvent, soundSource, SoundInstance.createUnseededRandom());
        this.livingEntity = livingEntity;
        this.x = (float)livingEntity.getX();
        this.y = (float)livingEntity.getY();
        this.z = (float)livingEntity.getZ();
        this.looping = true;
        this.delay = 0;
        this.volume = 0.0f;
    }

    public void tick() {
        if (!this.livingEntity.isRemoved()) {
            this.x = (float)this.livingEntity.getX();
            this.y = (float)this.livingEntity.getY();
            this.z = (float)this.livingEntity.getZ();
            if (!this.livingEntity.onGround()) {
                float speed = (float)this.livingEntity.getDeltaMovement().length() + 0.1f;
                this.pitch = Mth.lerp((float)Mth.clamp((float)speed, (float)this.getMinPitch(), (float)this.getMaxPitch()), (float)this.getMinPitch(), (float)this.getMaxPitch());
                this.volume = Mth.lerp((float)Mth.clamp((float)speed, (float)0.5f, (float)1.0f), (float)0.0f, (float)1.2f);
            } else {
                this.pitch = 0.0f;
                this.volume = 0.0f;
            }
        } else {
            this.stop();
            activeSounds.remove(this.livingEntity);
        }
    }

    private float getMinPitch() {
        return this.livingEntity.isBaby() ? 1.1f : 0.7f;
    }

    private float getMaxPitch() {
        return this.livingEntity.isBaby() ? 1.5f : 1.1f;
    }

    public boolean canStartSilent() {
        return true;
    }

    public boolean canPlaySound() {
        return !this.livingEntity.isSilent();
    }

    public static void playSound(LivingEntity livingEntity, SoundEvent soundEvent) {
        if (!activeSounds.containsKey(livingEntity)) {
            LivingEntityFlyingSoundInstance beesoundinstance = new LivingEntityFlyingSoundInstance(livingEntity, soundEvent, SoundSource.NEUTRAL);
            activeSounds.put((Entity)livingEntity, (SoundInstance)beesoundinstance);
            Minecraft.getInstance().getSoundManager().queueTickingSound((TickableSoundInstance)beesoundinstance);
        }
    }

    public static void stopSound(LivingEntity livingEntity, SoundEvent soundEvent) {
        if (activeSounds.containsKey(livingEntity)) {
            Minecraft.getInstance().getSoundManager().stop(activeSounds.get(livingEntity));
            activeSounds.remove(livingEntity);
        }
    }
}

