/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.event;

import baguchan.frostrealm.capability.FrostWeatherManager;
import baguchan.frostrealm.data.resource.FrostDimensions;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;

public class ClientFogEvent {
    @SubscribeEvent
    public void setFog(ViewportEvent.RenderFog event) {
        Entity entity = event.getCamera().getEntity();
        float partialTicks = (float)event.getPartialTick();
        if (entity.level().dimension() == FrostDimensions.FROSTREALM_LEVEL) {
            float weatherLevel = FrostWeatherManager.getWeatherLevel(partialTicks);
            if (FrostWeatherManager.getFrostWeather().isUseFog() || FrostWeatherManager.getPrevFrostWeather().isUseFog()) {
                float near = event.getNearPlaneDistance();
                float far = event.getFarPlaneDistance();
                float density = FrostWeatherManager.getPrevFrostWeather().getDensity();
                float densityNew = FrostWeatherManager.getFrostWeather().getDensity();
                float total = densityNew * weatherLevel + (1.0f - weatherLevel) * density;
                event.setNearPlaneDistance(near *= total);
                event.setFarPlaneDistance(far *= total);
            }
        }
    }

    @SubscribeEvent
    public void setFogColor(ViewportEvent.ComputeFogColor event) {
        float partialTicks;
        float weatherLevel;
        Entity entity = event.getCamera().getEntity();
        if (entity.level().dimension() == FrostDimensions.FROSTREALM_LEVEL && (weatherLevel = FrostWeatherManager.getWeatherLevel(partialTicks = (float)event.getPartialTick())) > 0.0f) {
            float fogRed = event.getRed();
            float fogGreen = event.getGreen();
            float fogBlue = event.getBlue();
            float red = FrostWeatherManager.getPrevFrostWeather().getRed();
            float green = FrostWeatherManager.getPrevFrostWeather().getGreen();
            float blue = FrostWeatherManager.getPrevFrostWeather().getBlue();
            float red2 = FrostWeatherManager.getFrostWeather().getRed();
            float green2 = FrostWeatherManager.getFrostWeather().getGreen();
            float blue2 = FrostWeatherManager.getFrostWeather().getBlue();
            float redTotal = red2 * weatherLevel + (1.0f - weatherLevel) * red;
            float greenTotal = green2 * weatherLevel + (1.0f - weatherLevel) * green;
            float blueTotal = blue2 * weatherLevel + (1.0f - weatherLevel) * blue;
            fogRed += (redTotal - fogRed) * 0.3f;
            fogGreen += (greenTotal - fogGreen) * 0.3f;
            fogBlue += (blueTotal - fogBlue) * 0.3f;
            event.setRed(fogRed);
            event.setGreen(fogGreen);
            event.setBlue(fogBlue);
        }
    }
}

