/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.model;

import baguchan.frostrealm.client.animation.BabyAnimations;
import baguchan.frostrealm.client.animation.FerretAnimations;
import baguchan.frostrealm.client.render.state.FerretRenderState;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class FerretModel<T extends FerretRenderState>
extends EntityModel<T> {
    private final ModelPart realroot;
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart body2;
    private final ModelPart back_leg_r;
    private final ModelPart back_leg_l;
    private final ModelPart tail;
    private final ModelPart front_leg_r;
    private final ModelPart front_leg_l;
    private final ModelPart head;
    private final ModelPart mouth;
    private final ModelPart ear_r;
    private final ModelPart ear_l;
    private final KeyframeAnimation sitAnimationState;
    private final KeyframeAnimation runAnimationState;
    private final KeyframeAnimation walkAnimationState;
    private final KeyframeAnimation babyAnimationState;

    public FerretModel(ModelPart root) {
        super(root);
        this.realroot = root;
        this.root = root.getChild("root");
        this.body = this.root.getChild("body");
        this.body2 = this.body.getChild("body2");
        this.back_leg_r = this.body2.getChild("back_leg_r");
        this.back_leg_l = this.body2.getChild("back_leg_l");
        this.tail = this.body2.getChild("tail");
        this.front_leg_r = this.body.getChild("front_leg_r");
        this.front_leg_l = this.body.getChild("front_leg_l");
        this.head = this.root.getChild("head");
        this.mouth = this.head.getChild("mouth");
        this.ear_r = this.head.getChild("ear_r");
        this.ear_l = this.head.getChild("ear_l");
        this.sitAnimationState = FerretAnimations.sit.bake(root);
        this.walkAnimationState = FerretAnimations.walk.bake(root);
        this.runAnimationState = FerretAnimations.run.bake(root);
        this.babyAnimationState = BabyAnimations.baby.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)22.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 8).addBox(-2.0f, -3.0f, 0.0f, 4.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)-7.0f));
        PartDefinition body2 = body.addOrReplaceChild("body2", CubeListBuilder.create().texOffs(0, 22).addBox(-2.0f, -3.0f, 0.0f, 4.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)9.0f));
        PartDefinition back_leg_r = body2.addOrReplaceChild("back_leg_r", CubeListBuilder.create().texOffs(18, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.5f, (float)2.0f, (float)6.0f));
        PartDefinition back_leg_l = body2.addOrReplaceChild("back_leg_l", CubeListBuilder.create().texOffs(18, 0).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)1.5f, (float)2.0f, (float)6.0f));
        PartDefinition tail = body2.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(24, 0).addBox(-1.5f, -1.0f, 0.0f, 3.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)10.0f));
        PartDefinition front_leg_r = body.addOrReplaceChild("front_leg_r", CubeListBuilder.create().texOffs(18, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.5f, (float)2.0f, (float)2.0f));
        PartDefinition front_leg_l = body.addOrReplaceChild("front_leg_l", CubeListBuilder.create().texOffs(18, 0).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)1.5f, (float)2.0f, (float)2.0f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -3.0f, -4.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)-7.0f));
        PartDefinition mouth = head.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(17, 11).addBox(-1.5f, -1.0f, -2.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-4.0f));
        PartDefinition ear_r = head.addOrReplaceChild("ear_r", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -2.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-2.0f, (float)-2.0f));
        PartDefinition ear_l = head.addOrReplaceChild("ear_l", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(0.0f, -2.0f, 0.0f, 2.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.0f, (float)-2.0f, (float)-2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity) {
        super.setupAnim(entity);
        this.head.yRot = ((FerretRenderState)((Object)entity)).yRot * ((float)Math.PI / 180);
        this.head.xRot = ((FerretRenderState)((Object)entity)).xRot * ((float)Math.PI / 180);
        float f = ((FerretRenderState)((Object)entity)).partialTick;
        if (((FerretRenderState)((Object)entity)).isSitting) {
            this.sitAnimationState.applyStatic();
        } else {
            this.runAnimationState.applyWalk(((FerretRenderState)((Object)entity)).walkAnimationPos, ((FerretRenderState)((Object)entity)).walkAnimationSpeed * ((FerretRenderState)((Object)entity)).running, 1.0f, 2.5f);
            this.walkAnimationState.applyWalk(((FerretRenderState)((Object)entity)).walkAnimationPos, ((FerretRenderState)((Object)entity)).walkAnimationSpeed * (1.0f - ((FerretRenderState)((Object)entity)).running), 1.0f, 5.0f);
        }
        if (((FerretRenderState)((Object)entity)).isBaby) {
            this.babyAnimationState.applyStatic();
        }
    }
}

