/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.model;

import baguchan.frostrealm.client.animation.FrostBoarAnimations;
import baguchan.frostrealm.client.render.state.FrostBoarRenderState;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class FrostBoarModel<T extends FrostBoarRenderState>
extends EntityModel<T> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart leg_R;
    private final ModelPart leg_L;
    private final ModelPart leg_back_R;
    private final ModelPart leg_back_L;
    private final ModelPart body;
    private final KeyframeAnimation runAnimationState;
    private final KeyframeAnimation walkAnimationState;
    private final KeyframeAnimation attackAnimationState;

    public FrostBoarModel(ModelPart root) {
        super(root);
        this.root = root.getChild("root");
        this.head = this.root.getChild("head");
        this.leg_R = this.root.getChild("leg_R");
        this.leg_L = this.root.getChild("leg_L");
        this.leg_back_R = this.root.getChild("leg_back_R");
        this.leg_back_L = this.root.getChild("leg_back_L");
        this.body = this.root.getChild("body");
        this.runAnimationState = FrostBoarAnimations.RUN.bake(root);
        this.walkAnimationState = FrostBoarAnimations.WALK.bake(root);
        this.attackAnimationState = FrostBoarAnimations.ATTACK.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)-0.5f, (float)0.5f, (float)-15.5f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-13.0f, -46.0f, -16.0f, 25.0f, 28.0f, 35.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)32.5f, (float)15.5f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 25).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(12, 25).addBox(-3.0f, 0.0f, 6.0f, 6.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)-38.0f, (float)19.0f));
        PartDefinition leg_back_L = root.addOrReplaceChild("leg_back_L", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, 1.0f, -3.5f, 7.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)13.5f, (float)28.0f));
        PartDefinition leg_back_R = root.addOrReplaceChild("leg_back_R", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, 1.0f, -3.5f, 7.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-8.0f, (float)13.5f, (float)28.0f));
        PartDefinition leg_L = root.addOrReplaceChild("leg_L", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, 1.0f, -3.5f, 7.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)13.5f, (float)7.0f));
        PartDefinition leg_R = root.addOrReplaceChild("leg_R", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, 1.0f, -3.5f, 7.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-8.0f, (float)13.5f, (float)7.0f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(52, 63).addBox(-10.0f, -11.0f, -5.5f, 20.0f, 22.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(53, 92).addBox(-6.0f, -2.0f, -11.25f, 12.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tusk = head.addOrReplaceChild("tusk", CubeListBuilder.create().texOffs(86, 0).addBox(6.0f, -1.0f, -6.0f, 3.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(86, 0).addBox(-9.0f, -1.0f, -6.0f, 3.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)-9.0f, (float)-0.9599f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity) {
        super.setupAnim(entity);
        this.head.yRot = ((FrostBoarRenderState)((Object)entity)).yRot * ((float)Math.PI / 180);
        this.head.xRot = ((FrostBoarRenderState)((Object)entity)).xRot * ((float)Math.PI / 180);
        this.runAnimationState.applyWalk(((FrostBoarRenderState)((Object)entity)).walkAnimationPos, ((FrostBoarRenderState)((Object)entity)).walkAnimationSpeed * ((FrostBoarRenderState)((Object)entity)).runningScale, 3.0f, 8.0f);
        this.walkAnimationState.applyWalk(((FrostBoarRenderState)((Object)entity)).walkAnimationPos, ((FrostBoarRenderState)((Object)entity)).walkAnimationSpeed * (1.0f - ((FrostBoarRenderState)((Object)entity)).runningScale), 1.0f, 2.0f);
        this.attackAnimationState.apply(((FrostBoarRenderState)((Object)entity)).attackAnimation, ((FrostBoarRenderState)((Object)entity)).ageInTicks);
    }
}

