/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.model;

import baguchan.frostrealm.client.render.state.FrostWraithRenderState;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class FrostWraithModel<T extends FrostWraithRenderState>
extends EntityModel<T>
implements HeadedModel {
    private final ModelPart head;
    public final ModelPart body;
    private final ModelPart arm_left;
    private final ModelPart arm_right;
    private final ModelPart leg_left_front;
    private final ModelPart leg_right_front;
    private final ModelPart leg_left_hind;
    private final ModelPart leg_right_hind;
    public final ModelPart main;

    public FrostWraithModel(ModelPart root) {
        super(root);
        this.main = root.getChild("main");
        this.body = this.main.getChild("body");
        this.head = this.body.getChild("head");
        this.arm_left = this.body.getChild("arm_left");
        this.arm_right = this.body.getChild("arm_right");
        this.leg_left_front = this.body.getChild("leg_left_front");
        this.leg_right_front = this.body.getChild("leg_right_front");
        this.leg_left_hind = this.body.getChild("leg_left_hind");
        this.leg_right_hind = this.body.getChild("leg_right_hind");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition main = partdefinition.addOrReplaceChild("main", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = main.addOrReplaceChild("body", CubeListBuilder.create().texOffs(40, 0).addBox(-3.0f, -16.0f, -3.0f, 6.0f, 16.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -10.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(64, 0).addBox(-8.0f, -14.0f, -2.0f, 3.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(64, 15).addBox(5.0f, -14.0f, -2.0f, 3.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-16.0f, (float)0.0f));
        PartDefinition arm_right = body.addOrReplaceChild("arm_right", CubeListBuilder.create().texOffs(0, 20).addBox(-17.0f, -2.0f, -2.0f, 17.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(42, 22).addBox(-21.0f, -1.0f, -1.0f, 4.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-13.0f, (float)0.0f));
        PartDefinition arm_left = body.addOrReplaceChild("arm_left", CubeListBuilder.create().texOffs(0, 29).addBox(0.0f, -2.0f, -2.0f, 17.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(42, 27).addBox(17.0f, -1.0f, -1.0f, 4.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-13.0f, (float)0.0f));
        PartDefinition leg_right_hind = body.addOrReplaceChild("leg_right_hind", CubeListBuilder.create().texOffs(78, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-4.0f, (float)2.0f));
        PartDefinition leg_left_hind2 = body.addOrReplaceChild("leg_left_hind", CubeListBuilder.create().texOffs(78, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-4.0f, (float)2.0f));
        PartDefinition leg_right_front = body.addOrReplaceChild("leg_right_front", CubeListBuilder.create().texOffs(78, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)-4.0f, (float)-2.0f));
        PartDefinition leg_left_front = body.addOrReplaceChild("leg_left_front", CubeListBuilder.create().texOffs(78, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-4.0f, (float)-2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)96, (int)48);
    }

    public void setupAnim(T entity) {
        super.setupAnim(entity);
        this.head.yRot = ((FrostWraithRenderState)((Object)entity)).yRot * ((float)Math.PI / 180);
        this.head.xRot = ((FrostWraithRenderState)((Object)entity)).xRot * ((float)Math.PI / 180);
        this.body.xRot = (float)(0.5235987755982988 * (double)((FrostWraithRenderState)((Object)entity)).walkAnimationSpeed);
        this.arm_right.xRot = Mth.cos((float)(((FrostWraithRenderState)((Object)entity)).ageInTicks * 0.05f)) * 0.2f;
        this.arm_left.xRot = Mth.cos((float)(((FrostWraithRenderState)((Object)entity)).ageInTicks * 0.05f)) * 0.2f;
        this.arm_right.zRot = -0.5235988f - Mth.cos((float)(((FrostWraithRenderState)((Object)entity)).ageInTicks * 0.05f)) * 0.2f;
        this.arm_left.zRot = 0.5235988f + Mth.cos((float)(((FrostWraithRenderState)((Object)entity)).ageInTicks * 0.05f)) * 0.2f;
        this.arm_right.xRot += 0.45f * ((FrostWraithRenderState)((Object)entity)).walkAnimationSpeed;
        this.arm_left.xRot += 0.45f * ((FrostWraithRenderState)((Object)entity)).walkAnimationSpeed;
        this.leg_right_front.xRot = Mth.clamp((float)(-0.45f + 0.45f * ((FrostWraithRenderState)((Object)entity)).walkAnimationSpeed), (float)-0.45f, (float)0.0f);
        this.leg_right_front.zRot = Mth.clamp((float)(0.45f - 0.45f * ((FrostWraithRenderState)((Object)entity)).walkAnimationSpeed), (float)0.0f, (float)0.45f);
        this.leg_left_front.xRot = Mth.clamp((float)(-0.45f + 0.45f * ((FrostWraithRenderState)((Object)entity)).walkAnimationSpeed), (float)-0.45f, (float)0.0f);
        this.leg_left_front.zRot = Mth.clamp((float)(-0.45f + 0.45f * ((FrostWraithRenderState)((Object)entity)).walkAnimationSpeed), (float)-0.45f, (float)0.0f);
        this.leg_right_hind.xRot = Mth.clamp((float)(0.45f - 0.45f * ((FrostWraithRenderState)((Object)entity)).walkAnimationSpeed), (float)0.0f, (float)0.45f);
        this.leg_right_hind.zRot = Mth.clamp((float)(0.45f - 0.45f * ((FrostWraithRenderState)((Object)entity)).walkAnimationSpeed), (float)0.0f, (float)0.45f);
        this.leg_left_hind.xRot = Mth.clamp((float)(0.45f - 0.45f * ((FrostWraithRenderState)((Object)entity)).walkAnimationSpeed), (float)0.0f, (float)0.45f);
        this.leg_left_hind.zRot = Mth.clamp((float)(-0.45f + 0.45f * ((FrostWraithRenderState)((Object)entity)).walkAnimationSpeed), (float)-0.45f, (float)0.0f);
        this.head.xRot -= (float)(0.5235987755982988 * (double)((FrostWraithRenderState)((Object)entity)).walkAnimationSpeed);
        this.leg_right_front.xRot += 0.45f * ((FrostWraithRenderState)((Object)entity)).walkAnimationSpeed;
        this.leg_left_front.xRot += 0.45f * ((FrostWraithRenderState)((Object)entity)).walkAnimationSpeed;
        this.leg_right_hind.xRot += 0.45f * ((FrostWraithRenderState)((Object)entity)).walkAnimationSpeed;
        this.leg_left_hind.xRot += 0.45f * ((FrostWraithRenderState)((Object)entity)).walkAnimationSpeed;
    }

    public ModelPart getHead() {
        return this.head;
    }
}

