/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.model;

import baguchan.frostrealm.client.animation.GokkurAnimations;
import baguchan.frostrealm.client.render.state.GokkurRenderState;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class GokkurModel<T extends GokkurRenderState>
extends EntityModel<T> {
    public final ModelPart root;
    public final ModelPart body_rotation;
    private final ModelPart left_leg;
    private final ModelPart right_leg;
    private final ModelPart body;
    private final KeyframeAnimation rollAnimationState;
    private final KeyframeAnimation startRollAnimationState;
    private final KeyframeAnimation walkAnimationState;

    public GokkurModel(ModelPart root) {
        super(root);
        this.root = root.getChild("root");
        this.body_rotation = this.root.getChild("body_rotation");
        this.left_leg = this.body_rotation.getChild("left_leg");
        this.right_leg = this.body_rotation.getChild("right_leg");
        this.body = this.body_rotation.getChild("body");
        this.rollAnimationState = GokkurAnimations.roll.bake(root);
        this.startRollAnimationState = GokkurAnimations.roll_start.bake(root);
        this.walkAnimationState = GokkurAnimations.walk.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body_rotation = root.addOrReplaceChild("body_rotation", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition left_leg = body_rotation.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 32).mirror().addBox(-3.0f, 0.0f, -3.0f, 6.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)4.0f, (float)8.0f, (float)0.0f));
        PartDefinition right_leg = body_rotation.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 32).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)8.0f, (float)0.0f));
        PartDefinition body = body_rotation.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -16.0f, -8.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity) {
        super.setupAnim(entity);
        if (((GokkurRenderState)((Object)entity)).rollAnimationState.isStarted() || ((GokkurRenderState)((Object)entity)).startRollAnimationState.isStarted()) {
            this.rollAnimationState.apply(((GokkurRenderState)((Object)entity)).rollAnimationState, ((GokkurRenderState)((Object)entity)).ageInTicks);
            this.startRollAnimationState.apply(((GokkurRenderState)((Object)entity)).startRollAnimationState, ((GokkurRenderState)((Object)entity)).ageInTicks);
        } else {
            this.walkAnimationState.applyWalk(((GokkurRenderState)((Object)entity)).walkAnimationPos, ((GokkurRenderState)((Object)entity)).walkAnimationSpeed, 1.0f, 4.0f);
        }
    }
}

