/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.model;

import baguchan.frostrealm.client.animation.SpearAttackAnimations;
import baguchan.frostrealm.client.render.state.LesserWarriorRenderState;
import baguchi.bagus_lib.client.layer.IArmor;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class LesserWarriorModel<T extends LesserWarriorRenderState>
extends EntityModel<T>
implements IArmor,
ArmedModel {
    public final ModelPart root;
    public final ModelPart body;
    public final ModelPart head;
    private final ModelPart right_arm;
    private final ModelPart left_arm;
    private final ModelPart right_item;
    private final ModelPart left_item;
    private final ModelPart right_leg;
    private final ModelPart left_leg;
    private final KeyframeAnimation idleRightAnimationState;
    private final KeyframeAnimation idleLeftAnimationState;
    private final KeyframeAnimation attackRightAnimationState;
    private final KeyframeAnimation attackLeftAnimationState;
    private final KeyframeAnimation counterRightAnimationState;
    private final KeyframeAnimation counterLeftAnimationState;
    private final KeyframeAnimation guardRightAnimationState;
    private final KeyframeAnimation guardLeftAnimationState;

    public LesserWarriorModel(ModelPart root) {
        super(root);
        this.root = root;
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.right_arm = root.getChild("right_arm");
        this.left_arm = root.getChild("left_arm");
        this.right_item = this.right_arm.getChild("right_item");
        this.left_item = this.left_arm.getChild("left_item");
        this.right_leg = root.getChild("right_leg");
        this.left_leg = root.getChild("left_leg");
        this.idleRightAnimationState = SpearAttackAnimations.idle_right.bake(root);
        this.idleLeftAnimationState = SpearAttackAnimations.idle_left.bake(root);
        this.attackRightAnimationState = SpearAttackAnimations.spear_attack_right.bake(root);
        this.attackLeftAnimationState = SpearAttackAnimations.spear_attack_left.bake(root);
        this.counterRightAnimationState = SpearAttackAnimations.counter_right.bake(root);
        this.counterLeftAnimationState = SpearAttackAnimations.counter_left.bake(root);
        this.guardRightAnimationState = SpearAttackAnimations.guard_right.bake(root);
        this.guardLeftAnimationState = SpearAttackAnimations.guard_left.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hat = head.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition right_item = right_arm.addOrReplaceChild("right_item", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)9.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition left_item = left_arm.addOrReplaceChild("left_item", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity) {
        super.setupAnim(entity);
        this.head.yRot = ((LesserWarriorRenderState)((Object)entity)).yRot * ((float)Math.PI / 180);
        this.head.xRot = ((LesserWarriorRenderState)((Object)entity)).xRot * ((float)Math.PI / 180);
        float f1 = ((LesserWarriorRenderState)((Object)entity)).walkAnimationPos;
        float f2 = ((LesserWarriorRenderState)((Object)entity)).walkAnimationSpeed;
        this.right_leg.xRot = Mth.cos((float)(f1 * 0.6662f)) * 1.4f * f2 / ((LesserWarriorRenderState)((Object)entity)).speedValue;
        this.left_leg.xRot = Mth.cos((float)(f1 * 0.6662f + (float)Math.PI)) * 1.4f * f2 / ((LesserWarriorRenderState)((Object)entity)).speedValue;
        this.right_leg.yRot = 0.0f;
        this.left_leg.yRot = 0.0f;
        this.right_leg.zRot = 0.0f;
        this.left_leg.zRot = 0.0f;
        float f = ((LesserWarriorRenderState)((Object)entity)).partialTick;
        if (((LesserWarriorRenderState)((Object)entity)).isHoldingBow && !((LesserWarriorRenderState)((Object)entity)).isAggressive) {
            this.right_arm.xRot = Mth.cos((float)(f1 * 0.6662f + (float)Math.PI)) * 2.0f * f2 * 0.5f / ((LesserWarriorRenderState)((Object)entity)).speedValue;
            this.left_arm.xRot = Mth.cos((float)(f1 * 0.6662f)) * 2.0f * f2 * 0.5f / ((LesserWarriorRenderState)((Object)entity)).speedValue;
        } else {
            if (!((LesserWarriorRenderState)((Object)entity)).attackAnimationState.isStarted() && !((LesserWarriorRenderState)((Object)entity)).counterAnimationState.isStarted() && ((LesserWarriorRenderState)((Object)entity)).guardAnimationScale.getAnimationScale(f) <= 0.0f) {
                if (((LesserWarriorRenderState)((Object)entity)).mainArm == HumanoidArm.RIGHT) {
                    this.idleRightAnimationState.applyStatic();
                } else {
                    this.idleLeftAnimationState.applyStatic();
                }
            }
            if (((LesserWarriorRenderState)((Object)entity)).mainArm == HumanoidArm.RIGHT) {
                this.attackRightAnimationState.apply(((LesserWarriorRenderState)((Object)entity)).attackAnimationState, ((LesserWarriorRenderState)((Object)entity)).ageInTicks);
            } else {
                this.attackLeftAnimationState.apply(((LesserWarriorRenderState)((Object)entity)).attackAnimationState, ((LesserWarriorRenderState)((Object)entity)).ageInTicks);
            }
            if (((LesserWarriorRenderState)((Object)entity)).mainArm == HumanoidArm.RIGHT) {
                this.counterRightAnimationState.apply(((LesserWarriorRenderState)((Object)entity)).counterAnimationState, ((LesserWarriorRenderState)((Object)entity)).ageInTicks);
            } else {
                this.counterLeftAnimationState.apply(((LesserWarriorRenderState)((Object)entity)).counterAnimationState, ((LesserWarriorRenderState)((Object)entity)).ageInTicks);
            }
            if (!((LesserWarriorRenderState)((Object)entity)).counterAnimationState.isStarted()) {
                if (((LesserWarriorRenderState)((Object)entity)).mainArm == HumanoidArm.RIGHT) {
                    this.guardRightAnimationState.applyWalk(0.0f, ((LesserWarriorRenderState)((Object)entity)).guardAnimationScale.getAnimationScale(f), 1.0f, 1.0f);
                } else {
                    this.guardLeftAnimationState.applyWalk(0.0f, ((LesserWarriorRenderState)((Object)entity)).guardAnimationScale.getAnimationScale(f), 1.0f, 1.0f);
                }
            }
        }
        if (((LesserWarriorRenderState)((Object)entity)).isHoldingBow && ((LesserWarriorRenderState)((Object)entity)).isAggressive) {
            this.right_arm.yRot = -0.1f + this.head.yRot;
            this.left_arm.yRot = 0.1f + this.head.yRot + 0.4f;
            this.right_arm.xRot = -1.5707964f + this.head.xRot;
            this.left_arm.xRot = -1.5707964f + this.head.xRot;
        }
    }

    public void translateToHead(ModelPart modelPart, PoseStack poseStack) {
        modelPart.translateAndRotate(poseStack);
    }

    public void translateToChest(ModelPart modelPart, PoseStack poseStack) {
        modelPart.translateAndRotate(poseStack);
    }

    public void translateToLeg(ModelPart modelPart, PoseStack poseStack) {
        modelPart.translateAndRotate(poseStack);
    }

    public void translateToChestPat(ModelPart modelPart, PoseStack poseStack) {
        modelPart.translateAndRotate(poseStack);
    }

    public Iterable<ModelPart> headPartArmors() {
        return ImmutableList.of((Object)this.head);
    }

    public Iterable<ModelPart> bodyPartArmors() {
        return ImmutableList.of((Object)this.body);
    }

    public Iterable<ModelPart> leftLegPartArmors() {
        return ImmutableList.of((Object)this.left_leg);
    }

    public Iterable<ModelPart> rightLegPartArmors() {
        return ImmutableList.of((Object)this.right_leg);
    }

    public Iterable<ModelPart> rightHandArmors() {
        return ImmutableList.of((Object)this.right_arm);
    }

    public Iterable<ModelPart> leftHandArmors() {
        return ImmutableList.of((Object)this.left_arm);
    }

    private ModelPart getArm(HumanoidArm p_102923_) {
        return p_102923_ == HumanoidArm.LEFT ? this.left_arm : this.right_arm;
    }

    private ModelPart getArmItem(HumanoidArm p_102923_) {
        return p_102923_ == HumanoidArm.LEFT ? this.left_item : this.right_item;
    }

    public void translateToHand(EntityRenderState entityRenderState, HumanoidArm humanoidArm, PoseStack poseStack) {
        this.getArm(humanoidArm).translateAndRotate(poseStack);
        this.getArmItem(humanoidArm).translateAndRotate(poseStack);
        poseStack.translate(0.0f, -0.5f, 0.0f);
    }
}

