/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.model;

import baguchan.frostrealm.client.animation.RootDeerAnimations;
import baguchan.frostrealm.client.render.state.RootDeerRenderState;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class RootDeerModel<T extends RootDeerRenderState>
extends EntityModel<T> {
    private final ModelPart all;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart above_teeth;
    private final ModelPart under_teeth;
    private final ModelPart joint;
    private final ModelPart corner;
    private final KeyframeAnimation attackAnimationState;
    private final KeyframeAnimation summonAnimationState;
    private final KeyframeAnimation deathAnimationState;

    public RootDeerModel(ModelPart root) {
        super(root);
        this.all = root.getChild("all");
        this.body = this.all.getChild("body");
        this.head = this.all.getChild("head");
        this.above_teeth = this.head.getChild("above_teeth");
        this.corner = this.above_teeth.getChild("corner");
        this.under_teeth = this.head.getChild("under_teeth");
        this.joint = this.under_teeth.getChild("joint");
        this.attackAnimationState = RootDeerAnimations.attack.bake(root);
        this.summonAnimationState = RootDeerAnimations.spawn.bake(root);
        this.deathAnimationState = RootDeerAnimations.death.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition all = partdefinition.addOrReplaceChild("all", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)14.0f));
        PartDefinition body = all.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 18).addBox(-5.0f, -12.0f, -1.0f, 10.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-4.0f, -11.0f, -11.0f, 8.0f, 8.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(32, 18).addBox(-3.0f, -10.0f, -20.0f, 6.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(36, 0).addBox(-2.0f, -9.0f, -28.0f, 4.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = all.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition above_teeth = head.addOrReplaceChild("above_teeth", CubeListBuilder.create().texOffs(36, 14).addBox(-3.0f, 0.0f, -11.0f, 6.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(44, 56).addBox(-3.0f, 0.0f, -11.0f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(34, 54).addBox(3.0f, 0.0f, -11.0f, 0.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 46).addBox(-3.0f, -6.0f, -6.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(24, 46).addBox(-3.0f, -3.0f, -11.0f, 6.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)-28.0f));
        PartDefinition corner = above_teeth.addOrReplaceChild("corner", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-6.0f, (float)-2.0f));
        PartDefinition corner_r1 = corner.addOrReplaceChild("corner_r1", CubeListBuilder.create().texOffs(32, 34).addBox(-8.0f, -12.0f, -1.0f, 16.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition under_teeth = head.addOrReplaceChild("under_teeth", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-6.0f, (float)-28.0f));
        PartDefinition head_r1 = under_teeth.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(0, 34).addBox(-3.0f, -2.0f, -8.0f, 6.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(56, 46).addBox(-3.0f, -4.0f, -8.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(56, 52).addBox(3.0f, -4.0f, -8.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(36, 16).addBox(-3.0f, -4.0f, -8.0f, 6.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition joint = under_teeth.addOrReplaceChild("joint", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition joint_r1 = joint.addOrReplaceChild("joint_r1", CubeListBuilder.create().texOffs(46, 46).addBox(3.0f, -7.0f, -3.0f, 0.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(24, 54).addBox(8.0f, -7.0f, -3.0f, 0.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.5f, (float)0.0f, (float)0.0f, (float)0.5236f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T p_364104_) {
        super.setupAnim(p_364104_);
        this.attackAnimationState.apply(((RootDeerRenderState)((Object)p_364104_)).attackAnimationState, ((RootDeerRenderState)((Object)p_364104_)).ageInTicks);
        this.summonAnimationState.apply(((RootDeerRenderState)((Object)p_364104_)).summonAnimationState, ((RootDeerRenderState)((Object)p_364104_)).ageInTicks);
        this.deathAnimationState.apply(((RootDeerRenderState)((Object)p_364104_)).deathAnimationState, ((RootDeerRenderState)((Object)p_364104_)).ageInTicks);
    }
}

