/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.model;

import baguchan.frostrealm.client.animation.SeekerAnimations;
import baguchan.frostrealm.client.render.state.SeekerRenderState;
import baguchan.frostrealm.entity.boss.Seeker;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.world.entity.HumanoidArm;

public class SeekerModel<T extends SeekerRenderState>
extends EntityModel<T>
implements ArmedModel {
    public final ModelPart all;
    public final ModelPart body;
    public final ModelPart neck;
    public final ModelPart head;
    private final ModelPart jaw;
    private final ModelPart head_upper;
    private final ModelPart hood;
    private final ModelPart bodyleggings;
    private final ModelPart necklace;
    private final ModelPart cloth;
    private final ModelPart leftArm;
    private final ModelPart leftArm2;
    private final ModelPart leftArmGlobe;
    private final ModelPart leftArmPat;
    private final ModelPart rightArm;
    private final ModelPart rightArm2;
    private final ModelPart rightArmGlobe;
    private final ModelPart righArmPat;
    private final ModelPart rightLeg;
    private final ModelPart rightLeg2;
    private final ModelPart leftLeg;
    private final ModelPart leftLeg2;
    private final KeyframeAnimation walkAnimationState;
    private final KeyframeAnimation preAttackAnimationState;
    private final KeyframeAnimation attackAnimationState;
    private final KeyframeAnimation stopAttackAnimationState;
    private final KeyframeAnimation deathAnimationState;
    private final KeyframeAnimation breathAnimationState;
    private final KeyframeAnimation breathPreAnimationState;
    private final KeyframeAnimation breathStopAnimationState;

    public SeekerModel(ModelPart root) {
        super(root);
        this.all = root.getChild("all");
        this.body = this.all.getChild("body");
        this.neck = this.body.getChild("neck");
        this.head = this.neck.getChild("head");
        this.jaw = this.head.getChild("jaw");
        this.head_upper = this.head.getChild("head_upper");
        this.hood = this.head_upper.getChild("hood");
        this.bodyleggings = this.body.getChild("bodyleggings");
        this.necklace = this.body.getChild("necklace");
        this.cloth = this.body.getChild("cloth");
        this.leftArm = this.body.getChild("leftArm");
        this.leftArm2 = this.leftArm.getChild("leftArm2");
        this.leftArmGlobe = this.leftArm2.getChild("leftArmGlobe");
        this.leftArmPat = this.leftArm.getChild("leftArmPat");
        this.rightArm = this.body.getChild("rightArm");
        this.rightArm2 = this.rightArm.getChild("rightArm2");
        this.rightArmGlobe = this.rightArm2.getChild("rightArmGlobe");
        this.righArmPat = this.rightArm.getChild("righArmPat");
        this.rightLeg = this.all.getChild("rightLeg");
        this.rightLeg2 = this.rightLeg.getChild("rightLeg2");
        this.leftLeg = this.all.getChild("leftLeg");
        this.leftLeg2 = this.leftLeg.getChild("leftLeg2");
        this.walkAnimationState = SeekerAnimations.walk.bake(root);
        this.preAttackAnimationState = SeekerAnimations.attack_pre.bake(root);
        this.attackAnimationState = SeekerAnimations.attack.bake(root);
        this.stopAttackAnimationState = SeekerAnimations.attack_stop.bake(root);
        this.deathAnimationState = SeekerAnimations.death.bake(root);
        this.breathAnimationState = SeekerAnimations.breath.bake(root);
        this.breathPreAnimationState = SeekerAnimations.breath_pre.bake(root);
        this.breathStopAnimationState = SeekerAnimations.breath_stop.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition all = partdefinition.addOrReplaceChild("all", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition body = all.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 46).addBox(-1.8039f, -34.2163f, 0.8921f, 4.0f, 16.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-5.6961f, -34.2163f, -4.2843f, 12.0f, 15.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(68, 12).addBox(-1.8039f, -11.2924f, -2.0177f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(42, 10).addBox(-3.8039f, -6.2924f, -3.0177f, 8.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)-3.7837f, (float)0.1961f));
        PartDefinition body_r1 = body.addOrReplaceChild("body_r1", CubeListBuilder.create().texOffs(40, 68).addBox(-3.0f, -1.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.1961f, (float)-18.2163f, (float)2.8921f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create(), PartPose.offset((float)0.1961f, (float)-34.1821f, (float)3.37f));
        PartDefinition neck_r1 = neck.addOrReplaceChild("neck_r1", CubeListBuilder.create().texOffs(70, 0).addBox(-2.0f, -8.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.0342f, (float)-0.4779f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)-0.1961f, (float)-6.0342f, (float)-4.0661f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create(), PartPose.offset((float)0.1079f, (float)-2.6279f, (float)3.3527f));
        PartDefinition teeth_r1 = jaw.addOrReplaceChild("teeth_r1", CubeListBuilder.create().texOffs(76, 31).addBox(-2.0f, -4.0f, -4.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(32, 38).addBox(-3.0f, -2.0f, -4.0f, 6.0f, 2.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.6279f, (float)-3.1027f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition head_upper = head.addOrReplaceChild("head_upper", CubeListBuilder.create().texOffs(32, 24).addBox(-4.0f, -10.0f, -8.3333f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(76, 27).addBox(-2.0f, -4.0f, -8.3333f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(42, 0).addBox(-4.0f, -4.0f, -6.3333f, 8.0f, 4.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.1079f, (float)-3.0f, (float)3.8333f));
        PartDefinition hood = head_upper.addOrReplaceChild("hood", CubeListBuilder.create().texOffs(0, 84).addBox(-4.0f, -10.0f, -8.3333f, 8.0f, 13.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition orb = head.addOrReplaceChild("orb", CubeListBuilder.create().texOffs(76, 35).addBox(-2.0f, -3.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition bodyleggings = body.addOrReplaceChild("bodyleggings", CubeListBuilder.create().texOffs(0, 24).addBox(-4.6079f, 0.0f, -2.6079f, 10.0f, 16.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.1961f, (float)-11.2163f, (float)-1.0f));
        PartDefinition necklace = body.addOrReplaceChild("necklace", CubeListBuilder.create(), PartPose.offset((float)0.1961f, (float)-31.2063f, (float)-3.9556f));
        PartDefinition necklace_r1 = necklace.addOrReplaceChild("necklace_r1", CubeListBuilder.create().texOffs(70, 74).addBox(-1.0f, -2.0f, -2.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(70, 74).addBox(6.0f, -2.0f, -2.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.5f, (float)-0.01f, (float)-0.1523f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition necklace_r2 = necklace.addOrReplaceChild("necklace_r2", CubeListBuilder.create().texOffs(56, 74).addBox(-1.0f, -3.0f, -2.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)3.49f, (float)-0.1523f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition cloth = body.addOrReplaceChild("cloth", CubeListBuilder.create().texOffs(32, 86).addBox(-5.6961f, 0.7837f, -4.2843f, 12.0f, 15.0f, 9.0f, new CubeDeformation(0.2f)), PartPose.offset((float)0.0f, (float)-35.0f, (float)0.0f));
        PartDefinition leftArm = body.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(16, 66).addBox(1.5f, -2.5f, -1.5f, 3.0f, 15.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-30.7163f, (float)0.3039f));
        PartDefinition leftArm2 = leftArm.addOrReplaceChild("leftArm2", CubeListBuilder.create().texOffs(16, 46).addBox(-1.5f, 0.5f, -0.5f, 3.0f, 17.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)12.0f, (float)-1.0f));
        PartDefinition leftArmGlobe = leftArm2.addOrReplaceChild("leftArmGlobe", CubeListBuilder.create().texOffs(64, 59).addBox(-2.0f, 0.5f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)7.0f, (float)1.0f));
        PartDefinition leftArmPat = leftArm.addOrReplaceChild("leftArmPat", CubeListBuilder.create().texOffs(65, 84).mirror().addBox(-4.0f, -4.0f, -3.0f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)6.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = body.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(28, 68).addBox(-2.5f, -2.5f, -1.5f, 3.0f, 15.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-6.0f, (float)-30.7163f, (float)0.3039f));
        PartDefinition rightArm2 = rightArm.addOrReplaceChild("rightArm2", CubeListBuilder.create().texOffs(28, 48).addBox(-1.5f, 0.5f, -0.5f, 3.0f, 17.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)12.0f, (float)-1.0f));
        PartDefinition rightArmGlobe = rightArm2.addOrReplaceChild("rightArmGlobe", CubeListBuilder.create().texOffs(0, 66).addBox(-2.0f, 0.5f, -2.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)7.0f, (float)1.0f));
        PartDefinition righArmPat = rightArm.addOrReplaceChild("righArmPat", CubeListBuilder.create().texOffs(65, 84).addBox(-4.0f, -4.0f, -3.0f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = all.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(64, 21).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 16.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.5f, (float)-4.0f, (float)-0.5f));
        PartDefinition rightLeg2 = rightLeg.addOrReplaceChild("rightLeg2", CubeListBuilder.create().texOffs(40, 48).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 17.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)16.5f, (float)-1.0f));
        PartDefinition leftLeg = all.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(64, 40).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 16.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.5f, (float)-4.0f, (float)-0.5f));
        PartDefinition leftLeg2 = leftLeg.addOrReplaceChild("leftLeg2", CubeListBuilder.create().texOffs(52, 48).addBox(-1.5f, -0.5f, -0.5f, 3.0f, 17.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)16.5f, (float)-1.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity) {
        super.setupAnim(entity);
        this.head.yRot = ((SeekerRenderState)((Object)entity)).yRot * ((float)Math.PI / 180) * 0.6666667f;
        this.head.xRot = ((SeekerRenderState)((Object)entity)).xRot * ((float)Math.PI / 180) * 0.6666667f;
        this.neck.yRot = ((SeekerRenderState)((Object)entity)).yRot * ((float)Math.PI / 180) * 0.33333334f;
        this.neck.xRot = ((SeekerRenderState)((Object)entity)).xRot * ((float)Math.PI / 180) * 0.33333334f;
        this.walkAnimationState.applyWalk(((SeekerRenderState)((Object)entity)).walkAnimationPos, ((SeekerRenderState)((Object)entity)).walkAnimationSpeed, 2.0f, 2.5f);
        if (((SeekerRenderState)((Object)entity)).state != Seeker.SeekerState.IDLE) {
            this.leftArm.resetPose();
            this.leftArm2.resetPose();
            this.leftArmGlobe.resetPose();
            this.rightArm.resetPose();
            this.rightArm2.resetPose();
            this.rightArmGlobe.resetPose();
        }
        this.preAttackAnimationState.apply(((SeekerRenderState)((Object)entity)).preAttackAnimationState, ((SeekerRenderState)((Object)entity)).ageInTicks);
        this.attackAnimationState.apply(((SeekerRenderState)((Object)entity)).attackAnimationState, ((SeekerRenderState)((Object)entity)).ageInTicks);
        this.stopAttackAnimationState.apply(((SeekerRenderState)((Object)entity)).stopAttackAnimationState, ((SeekerRenderState)((Object)entity)).ageInTicks);
        this.deathAnimationState.apply(((SeekerRenderState)((Object)entity)).deathAnimationState, ((SeekerRenderState)((Object)entity)).ageInTicks);
        this.breathAnimationState.apply(((SeekerRenderState)((Object)entity)).breathAnimationState, ((SeekerRenderState)((Object)entity)).ageInTicks);
        this.breathPreAnimationState.apply(((SeekerRenderState)((Object)entity)).breathPreAnimationState, ((SeekerRenderState)((Object)entity)).ageInTicks);
        this.breathStopAnimationState.apply(((SeekerRenderState)((Object)entity)).breathStopAnimationState, ((SeekerRenderState)((Object)entity)).ageInTicks);
    }

    private ModelPart getArm(HumanoidArm p_102923_) {
        return p_102923_ == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    private ModelPart getArm2(HumanoidArm p_102923_) {
        return p_102923_ == HumanoidArm.LEFT ? this.leftArm2 : this.rightArm2;
    }

    public void translateToHand(EntityRenderState entityRenderState, HumanoidArm p_102108_, PoseStack p_102109_) {
        this.all.translateAndRotate(p_102109_);
        this.body.translateAndRotate(p_102109_);
        this.getArm(p_102108_).translateAndRotate(p_102109_);
        this.getArm2(p_102108_).translateAndRotate(p_102109_);
        p_102109_.translate(0.0f, 0.25f, 0.0f);
    }
}

