/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.model;

import baguchan.frostrealm.client.animation.SilkMoonAnimations;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;

public class SilkMoonModel<T extends LivingEntityRenderState>
extends EntityModel<T> {
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart right_ear;
    private final ModelPart left_ear;
    private final ModelPart tail;
    private final ModelPart right_leg_front;
    private final ModelPart right_leg_mid;
    private final ModelPart right_leg_back;
    private final ModelPart left_leg_front;
    private final ModelPart left_leg_mid;
    private final ModelPart left_leg_back;
    private final ModelPart right_wing;
    private final ModelPart left_wing;
    private final KeyframeAnimation flyAnimationState;
    private final KeyframeAnimation flyLegAnimationState;

    public SilkMoonModel(ModelPart root) {
        super(root);
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
        this.right_ear = this.head.getChild("right_ear");
        this.left_ear = this.head.getChild("left_ear");
        this.tail = this.body.getChild("tail");
        this.right_leg_front = this.body.getChild("right_leg_front");
        this.right_leg_mid = this.body.getChild("right_leg_mid");
        this.right_leg_back = this.body.getChild("right_leg_back");
        this.left_leg_front = this.body.getChild("left_leg_front");
        this.left_leg_mid = this.body.getChild("left_leg_mid");
        this.left_leg_back = this.body.getChild("left_leg_back");
        this.right_wing = this.body.getChild("right_wing");
        this.left_wing = this.body.getChild("left_wing");
        this.flyAnimationState = SilkMoonAnimations.fly.bake(root);
        this.flyLegAnimationState = SilkMoonAnimations.fly_leg.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(18, 0).addBox(-3.0f, -2.5f, -5.0f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)20.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 8).addBox(-1.5f, -1.0f, -2.0f, 4.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)-1.0f, (float)-5.0f));
        PartDefinition right_ear = head.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(3, 2).addBox(-0.5f, -2.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.75f, (float)-0.75f, (float)-1.0f, (float)-0.4363f, (float)0.0f, (float)-0.1309f));
        PartDefinition left_ear = head.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(3, 2).addBox(-0.5f, -2.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.75f, (float)-0.75f, (float)-1.0f, (float)-0.4363f, (float)0.0f, (float)0.1309f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -1.5f, 0.0f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)-0.5f, (float)0.0f));
        PartDefinition right_leg_front = body.addOrReplaceChild("right_leg_front", CubeListBuilder.create().texOffs(3, 2).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)1.5f, (float)-4.0f));
        PartDefinition right_leg_mid = body.addOrReplaceChild("right_leg_mid", CubeListBuilder.create().texOffs(3, 2).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)1.5f, (float)-2.5f));
        PartDefinition right_leg_back = body.addOrReplaceChild("right_leg_back", CubeListBuilder.create().texOffs(3, 2).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)1.5f, (float)-1.0f));
        PartDefinition left_leg_front = body.addOrReplaceChild("left_leg_front", CubeListBuilder.create().texOffs(0, 2).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)1.5f, (float)-4.0f));
        PartDefinition left_leg_mid = body.addOrReplaceChild("left_leg_mid", CubeListBuilder.create().texOffs(0, 2).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)1.5f, (float)-2.5f));
        PartDefinition left_leg_back = body.addOrReplaceChild("left_leg_back", CubeListBuilder.create().texOffs(0, 2).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)1.5f, (float)-1.0f));
        PartDefinition right_wing = body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(19, 10).addBox(-7.0f, 0.0f, -5.0f, 8.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-2.0f, (float)-4.0f));
        PartDefinition left_wing = body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(1, 10).addBox(-1.0f, 0.0f, -4.0f, 8.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)-2.0f, (float)-5.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity) {
        super.setupAnim(entity);
        this.flyLegAnimationState.applyWalk(((LivingEntityRenderState)entity).walkAnimationPos, ((LivingEntityRenderState)entity).walkAnimationSpeed, 2.0f, 2.0f);
        this.flyAnimationState.applyWalk(((LivingEntityRenderState)entity).ageInTicks, 1.0f, 1.0f, 1.0f);
    }
}

