/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.model;

import baguchan.frostrealm.client.animation.SnowPileQuailAnimations;
import baguchan.frostrealm.client.render.state.SnowPileQuailRenderState;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class SnowPileQuailModel<T extends SnowPileQuailRenderState>
extends EntityModel<T>
implements HeadedModel {
    public final ModelPart body;
    private final ModelPart legR;
    private final ModelPart legL;
    private final ModelPart head;
    private final ModelPart wingR;
    private final ModelPart wingL;
    private final KeyframeAnimation popEggAnimationState;
    private final KeyframeAnimation shakeAnimationState;

    public SnowPileQuailModel(ModelPart root) {
        super(root);
        this.body = root.getChild("body");
        this.legR = this.body.getChild("legR");
        this.legL = this.body.getChild("legL");
        this.head = this.body.getChild("head");
        this.wingR = this.body.getChild("wingR");
        this.wingL = this.body.getChild("wingL");
        this.popEggAnimationState = SnowPileQuailAnimations.pop_egg.bake(root);
        this.shakeAnimationState = SnowPileQuailAnimations.shake.bake(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)21.0f, (float)1.5f));
        PartDefinition legR = body.addOrReplaceChild("legR", CubeListBuilder.create().texOffs(18, 16).addBox(-2.5f, 0.0f, -2.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.0f, (float)0.0f, (float)0.0f));
        PartDefinition legL = body.addOrReplaceChild("legL", CubeListBuilder.create().texOffs(18, 16).addBox(-2.5f, 0.0f, -2.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 16).addBox(-2.5f, -2.0f, -4.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(0, 24).addBox(-1.5f, 0.0f, -7.0f, 3.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-4.0f));
        PartDefinition wingR = body.addOrReplaceChild("wingR", CubeListBuilder.create().texOffs(32, 0).addBox(-1.0f, 0.0f, -4.0f, 1.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-6.0f, (float)0.0f));
        PartDefinition wingL = body.addOrReplaceChild("wingL", CubeListBuilder.create().texOffs(32, 0).addBox(0.0f, 0.0f, -4.0f, 1.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-6.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity) {
        super.setupAnim(entity);
        float f = (Mth.sin((float)((SnowPileQuailRenderState)((Object)entity)).flap) + 1.0f) * ((SnowPileQuailRenderState)((Object)entity)).flapSpeed;
        this.head.yRot = ((SnowPileQuailRenderState)((Object)entity)).yRot * ((float)Math.PI / 180);
        this.head.xRot = ((SnowPileQuailRenderState)((Object)entity)).xRot * ((float)Math.PI / 180);
        this.legR.xRot = Mth.cos((float)(((SnowPileQuailRenderState)((Object)entity)).walkAnimationPos * 0.6662f)) * 1.4f * ((SnowPileQuailRenderState)((Object)entity)).walkAnimationSpeed;
        this.legL.xRot = Mth.cos((float)(((SnowPileQuailRenderState)((Object)entity)).walkAnimationPos * 0.6662f + (float)Math.PI)) * 1.4f * ((SnowPileQuailRenderState)((Object)entity)).walkAnimationSpeed;
        this.wingR.zRot = f;
        this.wingL.zRot = -f;
        this.popEggAnimationState.apply(((SnowPileQuailRenderState)((Object)entity)).popEggAnimationState, ((SnowPileQuailRenderState)((Object)entity)).ageInTicks);
        this.shakeAnimationState.apply(((SnowPileQuailRenderState)((Object)entity)).shakeAnimationState, ((SnowPileQuailRenderState)((Object)entity)).ageInTicks);
    }

    public ModelPart getHead() {
        return this.head;
    }
}

