/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.model;

import baguchan.frostrealm.client.animation.WolfflueAnimations;
import baguchan.frostrealm.client.render.state.WolfflueRenderState;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class WolfflueModel<T extends WolfflueRenderState>
extends EntityModel<T> {
    public final ModelPart all;
    public final ModelPart head;
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart rightLeg;
    private final ModelPart rightLeg2;
    private final ModelPart rightLeg3;
    private final ModelPart leftLeg;
    private final ModelPart leftLeg2;
    private final ModelPart leftLeg3;
    private final KeyframeAnimation idleSitAnimationState;
    private final KeyframeAnimation idleSit2AnimationState;
    private final KeyframeAnimation runAnimationState;
    private final KeyframeAnimation walkAnimationState;
    private final KeyframeAnimation sitAnimationState;
    private final KeyframeAnimation jumpAnimationState;

    public WolfflueModel(ModelPart root) {
        super(root);
        this.all = root.getChild("all");
        this.head = this.all.getChild("head");
        this.body = this.all.getChild("body");
        this.tail = this.body.getChild("tail");
        this.rightLeg = this.all.getChild("rightLeg");
        this.rightLeg2 = this.rightLeg.getChild("rightLeg2");
        this.rightLeg3 = this.rightLeg.getChild("rightLeg3");
        this.leftLeg = this.all.getChild("leftLeg");
        this.leftLeg2 = this.leftLeg.getChild("leftLeg2");
        this.leftLeg3 = this.leftLeg.getChild("leftLeg3");
        this.idleSitAnimationState = WolfflueAnimations.sit_idle.bake(root);
        this.idleSit2AnimationState = WolfflueAnimations.sit_idle2.bake(root);
        this.walkAnimationState = WolfflueAnimations.walk.bake(root);
        this.runAnimationState = WolfflueAnimations.run.bake(root);
        this.sitAnimationState = WolfflueAnimations.sit.bake(root);
        this.jumpAnimationState = WolfflueAnimations.jump.bake(root);
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cubeDeformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition all = partdefinition.addOrReplaceChild("all", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = all.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 27).addBox(1.0f, -11.0f, -3.0f, 3.0f, 5.0f, 2.0f, cubeDeformation).texOffs(40, 27).addBox(-4.0f, -11.0f, -3.0f, 3.0f, 5.0f, 2.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)-20.0f, (float)-13.0f));
        PartDefinition head_r1 = head.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(52, 39).addBox(-2.0f, -5.0f, -15.0f, 4.0f, 4.0f, 5.0f, cubeDeformation).texOffs(41, 0).addBox(-4.0f, -8.0f, -10.0f, 8.0f, 7.0f, 8.0f, cubeDeformation), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)3.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition body = all.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -22.0f, -5.0f, 12.0f, 10.0f, 17.0f, cubeDeformation).texOffs(0, 27).addBox(-7.0f, -24.0f, -16.0f, 14.0f, 14.0f, 12.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(40, 27).addBox(-0.5f, -1.0f, 1.0f, 1.0f, 1.0f, 11.0f, cubeDeformation).texOffs(58, 15).addBox(-2.0f, -1.5f, 12.0f, 4.0f, 2.0f, 5.0f, cubeDeformation), PartPose.offset((float)0.0f, (float)-19.0f, (float)11.0f));
        PartDefinition rightLeg = all.addOrReplaceChild("rightLeg", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg2 = rightLeg.addOrReplaceChild("rightLeg2", CubeListBuilder.create().texOffs(40, 58).addBox(-1.0f, 0.0f, -1.0f, 3.0f, 12.0f, 3.0f, cubeDeformation).texOffs(53, 22).addBox(-2.0f, 4.0f, -2.0f, 5.0f, 5.0f, 5.0f, cubeDeformation), PartPose.offset((float)-5.0f, (float)-12.0f, (float)-10.0f));
        PartDefinition rightLeg3 = rightLeg.addOrReplaceChild("rightLeg3", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -2.0f, 3.0f, 12.0f, 3.0f, cubeDeformation).texOffs(0, 53).addBox(-2.0f, 4.0f, -3.0f, 5.0f, 5.0f, 5.0f, cubeDeformation), PartPose.offset((float)-5.0f, (float)-12.0f, (float)10.0f));
        PartDefinition leftLeg = all.addOrReplaceChild("leftLeg", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg2 = leftLeg.addOrReplaceChild("leftLeg2", CubeListBuilder.create().texOffs(0, 63).addBox(-2.0f, 0.0f, -1.0f, 3.0f, 12.0f, 3.0f, cubeDeformation).texOffs(47, 48).addBox(-3.0f, 4.0f, -2.0f, 5.0f, 5.0f, 5.0f, cubeDeformation), PartPose.offset((float)5.0f, (float)-12.0f, (float)-10.0f));
        PartDefinition leftLeg3 = leftLeg.addOrReplaceChild("leftLeg3", CubeListBuilder.create().texOffs(52, 58).addBox(-2.0f, 0.0f, -2.0f, 3.0f, 12.0f, 3.0f, cubeDeformation).texOffs(20, 53).addBox(-3.0f, 4.0f, -3.0f, 5.0f, 5.0f, 5.0f, cubeDeformation), PartPose.offset((float)5.0f, (float)-12.0f, (float)10.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity) {
        super.setupAnim(entity);
        this.head.yRot = ((WolfflueRenderState)((Object)entity)).yRot * ((float)Math.PI / 180);
        this.head.xRot = ((WolfflueRenderState)((Object)entity)).xRot * ((float)Math.PI / 180);
        this.tail.xRot = ((WolfflueRenderState)((Object)entity)).tailAngle;
        this.head.zRot = ((WolfflueRenderState)((Object)entity)).headRollAngle;
        float f = ((WolfflueRenderState)((Object)entity)).partialTick;
        if (((WolfflueRenderState)((Object)entity)).isSitting) {
            if (((WolfflueRenderState)((Object)entity)).idleSitAnimationState.isStarted() || ((WolfflueRenderState)((Object)entity)).idleSit2AnimationState.isStarted()) {
                this.idleSitAnimationState.apply(((WolfflueRenderState)((Object)entity)).idleSitAnimationState, ((WolfflueRenderState)((Object)entity)).ageInTicks);
                this.idleSit2AnimationState.apply(((WolfflueRenderState)((Object)entity)).idleSit2AnimationState, ((WolfflueRenderState)((Object)entity)).ageInTicks);
            } else {
                this.sitAnimationState.applyStatic();
            }
        } else if (((WolfflueRenderState)((Object)entity)).jumpAnimationState.isStarted()) {
            this.jumpAnimationState.apply(((WolfflueRenderState)((Object)entity)).jumpAnimationState, ((WolfflueRenderState)((Object)entity)).ageInTicks);
        } else {
            this.runAnimationState.applyWalk(((WolfflueRenderState)((Object)entity)).walkAnimationPos, ((WolfflueRenderState)((Object)entity)).walkAnimationSpeed * ((WolfflueRenderState)((Object)entity)).running, 1.0f, 2.5f);
            this.walkAnimationState.applyWalk(((WolfflueRenderState)((Object)entity)).walkAnimationPos, ((WolfflueRenderState)((Object)entity)).walkAnimationSpeed * (1.0f - ((WolfflueRenderState)((Object)entity)).running), 1.0f, 5.0f);
        }
    }
}

