/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.render;

import baguchan.frostrealm.client.FrostModelLayers;
import baguchan.frostrealm.client.model.GokkurModel;
import baguchan.frostrealm.client.render.layer.CrackingGokkurLayer;
import baguchan.frostrealm.client.render.layer.SnowGokkurLayer;
import baguchan.frostrealm.client.render.state.GokkurRenderState;
import baguchan.frostrealm.entity.hostile.Gokkur;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;

public class GokkurRenderer<T extends Gokkur>
extends MobRenderer<T, GokkurRenderState, GokkurModel<GokkurRenderState>> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"textures/entity/gokkur/gokkur.png");
    private static final ResourceLocation GRASS_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"textures/entity/gokkur/gokkur_grass.png");
    private static final RenderType GLOW = RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"textures/entity/gokkur/gokkur_eye.png"));

    public GokkurRenderer(EntityRendererProvider.Context p_173952_) {
        super(p_173952_, new GokkurModel(p_173952_.bakeLayer(FrostModelLayers.GOKKUR)), 0.5f);
        this.addLayer(new SnowGokkurLayer(this, p_173952_.getBlockRenderDispatcher()));
        this.addLayer(new CrackingGokkurLayer(this));
        this.addLayer((RenderLayer)new EyesLayer<GokkurRenderState, GokkurModel<GokkurRenderState>>(this, (RenderLayerParent)this){

            public RenderType renderType() {
                return GLOW;
            }
        });
    }

    public void extractRenderState(T p_362733_, GokkurRenderState p_360515_, float p_361157_) {
        super.extractRenderState(p_362733_, (LivingEntityRenderState)p_360515_, p_361157_);
        p_360515_.grass = ((Gokkur)((Object)p_362733_)).isGrass();
        p_360515_.snowProgress = ((Gokkur)((Object)p_362733_)).getSnowProgress();
        p_360515_.rollAnimationState.copyFrom(((Gokkur)((Object)p_362733_)).rollAnimationState);
        p_360515_.startRollAnimationState.copyFrom(((Gokkur)((Object)p_362733_)).startRollAnimationState);
        p_360515_.crackiness = ((Gokkur)((Object)p_362733_)).getCrackiness();
    }

    public GokkurRenderState createRenderState() {
        return new GokkurRenderState();
    }

    public ResourceLocation getTextureLocation(GokkurRenderState entity) {
        if (entity.grass) {
            return GRASS_TEXTURE;
        }
        return TEXTURE;
    }
}

