/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.render;

import baguchan.frostrealm.client.FrostModelLayers;
import baguchan.frostrealm.client.model.SeekerModel;
import baguchan.frostrealm.client.render.state.SeekerRenderState;
import baguchan.frostrealm.entity.boss.Seeker;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.resources.ResourceLocation;

public class SeekerRenderer<T extends Seeker>
extends MobRenderer<T, SeekerRenderState, SeekerModel<SeekerRenderState>> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"textures/entity/seeker/seeker.png");
    private static final RenderType WRAITH_GLOW = RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"textures/entity/seeker/seeker_eye.png"));
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(60.0) / 2.0);

    public SeekerRenderer(EntityRendererProvider.Context p_173952_) {
        super(p_173952_, new SeekerModel(p_173952_.bakeLayer(FrostModelLayers.SEEKER)), 0.5f);
        this.addLayer((RenderLayer)new EyesLayer<SeekerRenderState, SeekerModel<SeekerRenderState>>(this, (RenderLayerParent)this){

            public RenderType renderType() {
                return WRAITH_GLOW;
            }
        });
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
    }

    public SeekerRenderState createRenderState() {
        return new SeekerRenderState();
    }

    public void extractRenderState(T p_362733_, SeekerRenderState p_360515_, float p_361157_) {
        super.extractRenderState(p_362733_, (LivingEntityRenderState)p_360515_, p_361157_);
        ArmedEntityRenderState.extractArmedEntityRenderState(p_362733_, (ArmedEntityRenderState)p_360515_, (ItemModelResolver)this.itemModelResolver);
        p_360515_.attackAnimationState.copyFrom(((Seeker)((Object)p_362733_)).attackAnimationState);
        p_360515_.preAttackAnimationState.copyFrom(((Seeker)((Object)p_362733_)).preAttackAnimationState);
        p_360515_.stopAttackAnimationState.copyFrom(((Seeker)((Object)p_362733_)).stopAttackAnimationState);
        p_360515_.deathAnimationState.copyFrom(((Seeker)((Object)p_362733_)).deathAnimationState);
        p_360515_.breathAnimationState.copyFrom(((Seeker)((Object)p_362733_)).breathAnimationState);
        p_360515_.breathPreAnimationState.copyFrom(((Seeker)((Object)p_362733_)).breathPreAnimationState);
        p_360515_.breathStopAnimationState.copyFrom(((Seeker)((Object)p_362733_)).breathStopAnimationState);
        p_360515_.isAgressive = p_362733_.isAggressive();
        p_360515_.state = ((Seeker)((Object)p_362733_)).getState();
    }

    public void translate(ModelPart part, PoseStack p_104300_) {
        p_104300_.translate(part.x / 16.0f, part.y / 16.0f, part.z / 16.0f);
    }

    protected float getFlipDegrees() {
        return 0.0f;
    }

    public ResourceLocation getTextureLocation(SeekerRenderState p_110775_1_) {
        return TEXTURE;
    }
}

