/*
 * Decompiled with CFR 0.152.
 */
package baguchan.frostrealm.client.render;

import baguchan.frostrealm.client.FrostModelLayers;
import baguchan.frostrealm.client.model.VenochemModel;
import baguchan.frostrealm.client.render.state.VenochemRenderState;
import baguchan.frostrealm.entity.hostile.CellingMonster;
import baguchan.frostrealm.entity.hostile.Venochem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Pose;
import org.joml.Quaternionfc;

public class VenochemRenderer<T extends Venochem>
extends MobRenderer<T, VenochemRenderState, VenochemModel<VenochemRenderState>> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"textures/entity/venochem/venochem.png");
    private static final RenderType VENOCHEM_GLOW = RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"frostrealm", (String)"textures/entity/venochem/venochem_glow.png"));

    public VenochemRenderer(EntityRendererProvider.Context p_173952_) {
        super(p_173952_, new VenochemModel(p_173952_.bakeLayer(FrostModelLayers.VENOCHEM)), 0.5f);
        this.addLayer((RenderLayer)new EyesLayer<VenochemRenderState, VenochemModel<VenochemRenderState>>(this, (RenderLayerParent)this){

            public RenderType renderType() {
                return VENOCHEM_GLOW;
            }
        });
    }

    public VenochemRenderState createRenderState() {
        return new VenochemRenderState();
    }

    public void extractRenderState(T p_362733_, VenochemRenderState p_360515_, float p_361157_) {
        super.extractRenderState(p_362733_, (LivingEntityRenderState)p_360515_, p_361157_);
        p_360515_.attackAnimationState.copyFrom(((Venochem)((Object)p_362733_)).attackAnimationState);
        p_360515_.shootAnimationState.copyFrom(((Venochem)((Object)p_362733_)).shootAnimationState);
        p_360515_.attachFace = ((CellingMonster)((Object)p_362733_)).getAttachFacing();
        p_360515_.rotations = ((CellingMonster)((Object)p_362733_)).getCellRotation();
        p_360515_.prevRotations = ((Venochem)((Object)p_362733_)).prevRotation;
        p_360515_.attachChangeProgress = ((CellingMonster)((Object)p_362733_)).getAttachAmount(p_361157_);
    }

    protected void setupRotations(VenochemRenderState entity, PoseStack poseStack, float rotationYaw, float p_115910_) {
        float trans = 0.40625f;
        if (entity.pose != Pose.SLEEPING) {
            if (entity.attachFace == Direction.DOWN) {
                super.setupRotations((LivingEntityRenderState)entity, poseStack, rotationYaw, p_115910_);
            } else {
                float yaw = (float)Math.toDegrees(Mth.atan2((double)entity.rotations.x, (double)entity.rotations.z));
                float pitch = (float)(-Math.toDegrees(Mth.atan2((double)entity.rotations.y, (double)Math.sqrt(entity.rotations.x * entity.rotations.x + entity.rotations.z * entity.rotations.z))));
                float prevYaw = (float)Math.toDegrees(Mth.atan2((double)entity.prevRotations.x, (double)entity.prevRotations.z));
                float prevPitch = (float)(-Math.toDegrees(Mth.atan2((double)entity.prevRotations.y, (double)Math.sqrt(entity.prevRotations.x * entity.prevRotations.x + entity.prevRotations.z * entity.prevRotations.z))));
                float realYaw = prevYaw * (1.0f - entity.attachChangeProgress) - yaw * entity.attachChangeProgress;
                float realPitch = prevPitch * (1.0f - entity.attachChangeProgress) - pitch * entity.attachChangeProgress;
                poseStack.translate(0.0f, trans, 0.0f);
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(realYaw));
                poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f + realPitch));
                poseStack.translate(0.0f, -trans, 0.0f);
                super.setupRotations((LivingEntityRenderState)entity, poseStack, 0.0f, p_115910_);
            }
        } else {
            super.setupRotations((LivingEntityRenderState)entity, poseStack, rotationYaw, p_115910_);
        }
    }

    public ResourceLocation getTextureLocation(VenochemRenderState p_110775_1_) {
        return TEXTURE;
    }
}

